/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.util.blob.BlobOutputStream;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.util.jaxp.SourceBuilder;

public class StreamSourceBuilder
implements SourceBuilder {
    private static final Log log = LogFactory.getLog(StreamSourceBuilder.class);
    private final SynapseEnvironment synEnv;
    private OverflowBlob tmp;
    private InputStream in;

    public StreamSourceBuilder(SynapseEnvironment synEnv) {
        this.synEnv = synEnv;
    }

    public Source getSource(OMElement node) {
        this.tmp = this.synEnv.createOverflowBlob();
        BlobOutputStream out = this.tmp.getOutputStream();
        try {
            node.serialize((OutputStream)out);
        }
        catch (XMLStreamException e) {
            this.release();
            StreamSourceBuilder.handleException("Unable to serialize AXIOM tree", e);
        }
        try {
            out.close();
            this.in = this.tmp.getInputStream();
            return new StreamSource(this.in);
        }
        catch (IOException e) {
            this.release();
            StreamSourceBuilder.handleException("Unable to read temporary file", e);
            return null;
        }
    }

    public void release() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
        if (this.tmp != null) {
            this.tmp.release();
            this.tmp = null;
        }
    }

    private static void handleException(String message, Throwable ex) {
        log.error((Object)message, ex);
        throw new SynapseException(message, ex);
    }
}

