/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.util.TextFileDataSource;
import org.apache.synapse.util.jaxp.ResultBuilder;
import org.apache.synapse.util.jaxp.ResultBuilderFactory;

public class StreamResultBuilder
implements ResultBuilder {
    private static final Log log = LogFactory.getLog(StreamResultBuilder.class);
    private final SynapseEnvironment synEnv;
    private final ResultBuilderFactory.Output expectedOutput;
    private OverflowBlob tmp;
    private OutputStream out;

    public StreamResultBuilder(SynapseEnvironment synEnv, ResultBuilderFactory.Output expectedOutput) {
        this.synEnv = synEnv;
        this.expectedOutput = expectedOutput;
    }

    public Result getResult() {
        this.tmp = this.synEnv.createOverflowBlob();
        this.out = this.tmp.getOutputStream();
        return new StreamResult(this.out);
    }

    public OMElement getNode(Charset charset) {
        XMLStreamReader reader;
        try {
            this.out.close();
        }
        catch (IOException e) {
            StreamResultBuilder.handleException("Error while closing output stream", e);
        }
        if (this.expectedOutput == ResultBuilderFactory.Output.TEXT) {
            return TextFileDataSource.createOMSourcedElement(this.tmp, charset);
        }
        try {
            reader = StAXUtils.createXMLStreamReader((InputStream)this.tmp.getInputStream());
        }
        catch (XMLStreamException e) {
            StreamResultBuilder.handleException("Unable to parse the XML output", e);
            return null;
        }
        catch (IOException e) {
            StreamResultBuilder.handleException("I/O error while reading temporary file", e);
            return null;
        }
        if (this.expectedOutput == ResultBuilderFactory.Output.SOAP_ENVELOPE) {
            return OMXMLBuilderFactory.createStAXSOAPModelBuilder((XMLStreamReader)reader).getSOAPEnvelope();
        }
        return OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)reader).getDocumentElement();
    }

    public void release() {
        if (this.tmp != null) {
            this.tmp.release();
            this.tmp = null;
        }
    }

    private static void handleException(String message, Throwable ex) {
        log.error((Object)message, ex);
        throw new SynapseException(message, ex);
    }
}

