/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.dispatch.DefaultDispatcher;
import org.apache.synapse.rest.dispatch.RESTDispatcher;
import org.apache.synapse.rest.dispatch.URITemplateBasedDispatcher;
import org.apache.synapse.rest.dispatch.URLMappingBasedDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTUtils {
    private static final Log log = LogFactory.getLog(RESTUtils.class);
    private static final List<RESTDispatcher> dispatchers = new ArrayList<RESTDispatcher>();

    public static String trimSlashes(String url) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if (url.startsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String trimTrailingSlashes(String url) {
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getFullRequestPath(MessageContext synCtx) {
        Object obj = synCtx.getProperty("REST_FULL_REQUEST_PATH");
        if (obj != null) {
            return (String)obj;
        }
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String url = (String)msgCtx.getProperty("TransportInURL");
        if (url == null) {
            url = (String)synCtx.getProperty("SERVICE_PREFIX");
        }
        if (url.contains("://")) {
            try {
                url = new URL(url).getPath();
            }
            catch (MalformedURLException e) {
                RESTUtils.handleException("Request URL: " + url + " is malformed", e);
            }
        }
        synCtx.setProperty("REST_FULL_REQUEST_PATH", url);
        return url;
    }

    public static String getSubRequestPath(MessageContext synCtx) {
        return (String)synCtx.getProperty("REST_SUB_REQUEST_PATH");
    }

    public static List<RESTDispatcher> getDispatchers() {
        return dispatchers;
    }

    private static void handleException(String msg, Throwable t) {
        log.error((Object)msg, t);
        throw new SynapseException(msg, t);
    }

    static {
        dispatchers.add(new URLMappingBasedDispatcher());
        dispatchers.add(new URITemplateBasedDispatcher());
        dispatchers.add(new DefaultDispatcher());
    }
}

