/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.store.AbstractMessageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryMessageStore
extends AbstractMessageStore {
    private static final Log log = LogFactory.getLog(InMemoryMessageStore.class);
    private Map<String, MessageContext> messageList = new ConcurrentHashMap<String, MessageContext>();
    private Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(MessageContext messageContext) {
        this.lock.lock();
        try {
            if (messageContext != null) {
                messageContext.getEnvelope().build();
                this.messageList.put(messageContext.getMessageID(), messageContext);
                this.notifyMessageAddition(messageContext.getMessageID());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message with id " + messageContext.getMessageID() + " stored"));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext poll() {
        MessageContext context;
        this.lock.lock();
        try {
            context = this.peek();
            if (context != null) {
                this.messageList.remove(context.getMessageID());
                this.notifyMessageRemoval(context.getMessageID());
            }
        }
        finally {
            this.lock.unlock();
        }
        return context;
    }

    @Override
    public MessageContext peek() {
        if (this.messageList.size() > 0) {
            return (MessageContext)this.messageList.values().toArray()[0];
        }
        return null;
    }

    @Override
    public MessageContext remove() throws NoSuchElementException {
        MessageContext context = this.poll();
        if (context == null) {
            throw new NoSuchElementException();
        }
        return context;
    }

    @Override
    public MessageContext get(int index) {
        if (index >= 0 && index < this.messageList.size()) {
            return (MessageContext)this.messageList.values().toArray()[index];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext remove(String messageID) {
        this.lock.lock();
        try {
            if (messageID != null && this.messageList.remove(messageID) != null) {
                this.notifyMessageRemoval(messageID);
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            for (String k : this.messageList.keySet()) {
                this.messageList.remove(k);
                this.notifyMessageRemoval(k);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageContext> getAll() {
        this.lock.lock();
        try {
            ArrayList<MessageContext> returnList = new ArrayList<MessageContext>();
            for (Map.Entry<String, MessageContext> entry : this.messageList.entrySet()) {
                returnList.add(entry.getValue());
            }
            ArrayList<MessageContext> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext get(String messageId) {
        this.lock.lock();
        try {
            if (messageId != null) {
                MessageContext messageContext = this.messageList.get(messageId);
                return messageContext;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    @Override
    public int size() {
        return this.messageList.size();
    }
}

