/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.MessageStoreObserver;
import org.apache.synapse.message.store.MessageStoreView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageStore
implements MessageStore {
    protected String name;
    protected String sequence;
    protected MessageStoreView messageStoreMBean;
    protected SynapseConfiguration synapseConfiguration;
    protected SynapseEnvironment synapseEnvironment;
    protected Map<String, Object> parameters;
    protected String description;
    protected String fileName;
    protected List<MessageStoreObserver> messageStoreObservers = new ArrayList<MessageStoreObserver>();
    protected Lock lock = new ReentrantLock();

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
        this.synapseConfiguration = this.synapseEnvironment.getSynapseConfiguration();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.messageStoreMBean = new MessageStoreView(name, this);
        MBeanRegistrar.getInstance().registerMBean((Object)this.messageStoreMBean, "MessageStore", this.name);
    }

    @Override
    public void registerObserver(MessageStoreObserver observer) {
        if (observer != null && !this.messageStoreObservers.contains(observer)) {
            this.messageStoreObservers.add(observer);
        }
    }

    @Override
    public void unregisterObserver(MessageStoreObserver observer) {
        if (observer != null && this.messageStoreObservers.contains(observer)) {
            this.messageStoreObservers.remove(observer);
        }
    }

    protected void notifyMessageAddition(String messageId) {
        for (MessageStoreObserver o : this.messageStoreObservers) {
            o.messageAdded(messageId);
        }
    }

    protected void notifyMessageRemoval(String messageId) {
        for (MessageStoreObserver o : this.messageStoreObservers) {
            o.messageRemoved(messageId);
        }
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setFileName(String filename) {
        this.fileName = filename;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public Lock getLock() {
        return this.lock;
    }
}

