/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.elementary;

import java.util.ArrayList;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;
import org.jaxen.JaxenException;

public class EnrichMediator
extends AbstractMediator {
    public static final int CUSTOM = 0;
    public static final int ENVELOPE = 1;
    public static final int BODY = 2;
    public static final int PROPERTY = 3;
    public static final int INLINE = 4;
    private Source source = null;
    private Target target = null;

    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Enrich mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        try {
            ArrayList<OMNode> sourceNodeList = this.source.evaluate(synCtx, synLog);
            if (sourceNodeList == null) {
                this.handleException("Failed to get the source for Enriching : ", synCtx);
            } else {
                this.target.insert(synCtx, sourceNodeList, synLog);
            }
        }
        catch (JaxenException e) {
            this.handleException("Failed to get the source for Enriching", (Exception)((Object)e), synCtx);
        }
        synLog.traceOrDebug("End : Enrich mediator");
        return true;
    }

    public Source getSource() {
        return this.source;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setTarget(Target target) {
        this.target = target;
    }
}

