/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class Value {
    private static final Log log = LogFactory.getLog(Value.class);
    private String name = null;
    private String keyValue = null;
    private SynapseXPath expression = null;
    private List<OMNamespace> namespaceList = new ArrayList<OMNamespace>();

    public Value(String staticKey) {
        this.keyValue = staticKey;
    }

    public Value(SynapseXPath expression) {
        this.expression = expression;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public SynapseXPath getExpression() {
        if (this.expression == null && this.keyValue != null && this.hasExprTypeKey()) {
            try {
                this.expression = new SynapseXPath(this.keyValue.substring(1, this.keyValue.length() - 1));
                for (OMNamespace aNamespaceList : this.namespaceList) {
                    this.expression.addNamespace(aNamespaceList);
                }
            }
            catch (JaxenException e) {
                this.expression = null;
                this.handleException("Can not evaluate escaped expression..");
            }
        }
        return this.expression;
    }

    public String evaluateValue(MessageContext synCtx) {
        if (this.keyValue != null) {
            return this.keyValue;
        }
        if (this.expression != null) {
            return this.expression.stringValueOf(synCtx);
        }
        this.handleException("Can not evaluate the key: key should be static or dynamic key");
        return null;
    }

    public String getName() {
        return this.name;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public boolean hasExprTypeKey() {
        return this.keyValue != null && this.keyValue.startsWith("{") && this.keyValue.endsWith("}");
    }

    public void setNamespaces(OMElement elem) {
        OMElement currentElem = elem;
        while (currentElem != null) {
            Iterator it = currentElem.getAllDeclaredNamespaces();
            while (it.hasNext()) {
                OMNamespace n = (OMNamespace)it.next();
                if (n == null || "".equals(n.getPrefix())) continue;
                this.namespaceList.add(n);
            }
            OMContainer parent = currentElem.getParent();
            if (parent == null || parent instanceof OMDocument) {
                return;
            }
            if (!(parent instanceof OMElement)) continue;
            currentElem = (OMElement)parent;
        }
        Iterator namespaces = elem.getAllDeclaredNamespaces();
        while (namespaces.hasNext()) {
            OMNamespace ns = (OMNamespace)namespaces.next();
            this.namespaceList.add(ns);
        }
    }

    public String toString() {
        return "Value {name ='" + this.name + '\'' + (this.keyValue != null ? ", keyValue ='" + this.keyValue + '\'' : "") + (this.expression != null ? ", expression =" + (Object)((Object)this.expression) : "") + '}';
    }
}

