/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.eventing.builders;

import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.eventing.SynapseSubscription;

public class SubscriptionMessageBuilder {
    private static final Log log = LogFactory.getLog(SubscriptionMessageBuilder.class);
    private static final QName SUBSCRIBE_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Subscribe");
    private static final QName DELIVERY_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Delivery");
    private static final QName FILTER_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Filter");
    private static final QName NOTIFY_TO_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "NotifyTo");
    private static final QName ATT_DIALECT = new QName("", "Dialect");
    private static final QName IDENTIFIER = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier");
    private static final QName EXPIRES = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Expires");
    private static final QName RENEW = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Renew");
    private static String errorSubCode = null;
    private static String errorReason = null;
    private static String errorCode = null;

    public static SynapseSubscription createSubscription(MessageContext mc) {
        SynapseSubscription subscription = null;
        OMElement elem = mc.getEnvelope().getBody().getFirstChildWithName(SUBSCRIBE_QNAME);
        if (elem != null) {
            OMElement expiryElem;
            OMElement deliveryElem = elem.getFirstChildWithName(DELIVERY_QNAME);
            if (deliveryElem != null) {
                OMElement notifyToElem = deliveryElem.getFirstChildWithName(NOTIFY_TO_QNAME);
                if (notifyToElem != null) {
                    subscription = new SynapseSubscription("http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push");
                    subscription.setAddressUrl(notifyToElem.getFirstElement().getText());
                    subscription.setEndpointUrl(notifyToElem.getFirstElement().getText());
                    subscription.setSubManUrl(mc.getTo().getAddress());
                } else {
                    SubscriptionMessageBuilder.handleException("NotifyTo element not found in the subscription message");
                }
            } else {
                SubscriptionMessageBuilder.handleException("Delivery element is not found in the subscription message");
            }
            OMElement filterElem = elem.getFirstChildWithName(FILTER_QNAME);
            if (subscription != null && filterElem != null) {
                OMAttribute dialectAttr = filterElem.getAttribute(ATT_DIALECT);
                if (dialectAttr != null && dialectAttr.getAttributeValue() != null) {
                    subscription.setFilterDialect(dialectAttr.getAttributeValue());
                    subscription.setFilterValue(filterElem.getText());
                } else {
                    SubscriptionMessageBuilder.handleException("Error in creating subscription. Filter dialect not defined");
                }
            }
            if ((expiryElem = elem.getFirstChildWithName(EXPIRES)) != null) {
                Calendar calendarExpires = null;
                try {
                    calendarExpires = expiryElem.getText().startsWith("P") ? ConverterUtil.convertToDuration((String)expiryElem.getText()).getAsCalendar() : ConverterUtil.convertToDateTime((String)expiryElem.getText());
                }
                catch (Exception e) {
                    log.error((Object)("Error converting the expiration date ," + e.toString()));
                    SubscriptionMessageBuilder.setExpirationFault(subscription);
                }
                Calendar calendarNow = Calendar.getInstance();
                if (SubscriptionMessageBuilder.isValidDate(expiryElem.getText(), calendarExpires) && calendarNow.before(calendarExpires)) {
                    subscription.setExpires(calendarExpires);
                } else {
                    SubscriptionMessageBuilder.setExpirationFault(subscription);
                }
            }
        } else {
            SubscriptionMessageBuilder.handleException("Subscribe element is required as the payload of the subscription message");
        }
        return subscription;
    }

    public static SynapseSubscription createUnSubscribeMessage(MessageContext mc) {
        SynapseSubscription subscription = new SynapseSubscription();
        OMElement elem = mc.getEnvelope().getHeader().getFirstChildWithName(IDENTIFIER);
        String id = elem.getText();
        subscription.setId(id);
        subscription.setAddressUrl(mc.getTo().getAddress());
        return subscription;
    }

    public static SynapseSubscription createRenewSubscribeMessage(MessageContext mc) {
        SynapseSubscription subscription = new SynapseSubscription();
        OMElement elem = mc.getEnvelope().getHeader().getFirstChildWithName(IDENTIFIER);
        String id = elem.getText();
        subscription.setId(id);
        subscription.setAddressUrl(mc.getTo().getAddress());
        OMElement renewElem = mc.getEnvelope().getBody().getFirstChildWithName(RENEW);
        if (renewElem != null) {
            OMElement expiryElem = renewElem.getFirstChildWithName(EXPIRES);
            if (expiryElem != null) {
                if (!expiryElem.getText().startsWith("*")) {
                    Calendar calendarExpires = null;
                    try {
                        calendarExpires = expiryElem.getText().startsWith("P") ? ConverterUtil.convertToDuration((String)expiryElem.getText()).getAsCalendar() : ConverterUtil.convertToDateTime((String)expiryElem.getText());
                    }
                    catch (Exception e) {
                        SubscriptionMessageBuilder.setExpirationFault(subscription);
                    }
                    Calendar calendarNow = Calendar.getInstance();
                    if (SubscriptionMessageBuilder.isValidDate(expiryElem.getText(), calendarExpires) && calendarNow.before(calendarExpires)) {
                        subscription.setExpires(calendarExpires);
                    } else {
                        SubscriptionMessageBuilder.setExpirationFault(subscription);
                    }
                    subscription.setExpires(calendarExpires);
                } else {
                    SubscriptionMessageBuilder.setExpirationFault(subscription);
                }
            } else {
                SubscriptionMessageBuilder.setExpirationFault(subscription);
            }
        }
        return subscription;
    }

    public static SynapseSubscription createGetStatusMessage(MessageContext mc) {
        SynapseSubscription subscription = new SynapseSubscription();
        subscription.setAddressUrl(mc.getTo().getAddress());
        OMElement elem = mc.getEnvelope().getHeader().getFirstChildWithName(IDENTIFIER);
        String id = elem.getText();
        subscription.setId(id);
        return subscription;
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }

    public static String getErrorSubCode() {
        return errorSubCode;
    }

    public static void setErrorSubCode(String errorCode) {
        errorSubCode = errorCode;
    }

    public static String getErrorReason() {
        return errorReason;
    }

    public static void setErrorReason(String errorReasons) {
        errorReason = errorReasons;
    }

    public static String getErrorCode() {
        return errorCode;
    }

    public static void setErrorCode(String errorCodes) {
        errorCode = errorCodes;
    }

    private static void setExpirationFault(SynapseSubscription subscription) {
        SubscriptionMessageBuilder.setErrorCode("Sender");
        SubscriptionMessageBuilder.setErrorSubCode("InvalidExpirationTime");
        SubscriptionMessageBuilder.setErrorReason("The expiration time requested is invalid");
        subscription.setId(null);
    }

    private static boolean isValidDate(String original, Calendar converted) {
        try {
            String check = ConverterUtil.convertToString((Calendar)converted);
            return original.equals(check);
        }
        catch (Exception e) {
            log.error((Object)("Converting the date to string, " + e.toString()));
            return false;
        }
    }
}

