/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.eventing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SynapseMessageReceiver;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.eventing.SynapseSubscription;
import org.apache.synapse.eventing.builders.ResponseMessageBuilder;
import org.apache.synapse.eventing.builders.SubscriptionMessageBuilder;
import org.apache.synapse.util.MessageHelper;
import org.wso2.eventing.Event;
import org.wso2.eventing.Subscription;
import org.wso2.eventing.SubscriptionManager;
import org.wso2.eventing.exceptions.EventException;

public class SynapseEventSource
extends SynapseMessageReceiver {
    private String name;
    private SubscriptionManager subscriptionManager;
    private static final Log log = LogFactory.getLog(SynapseEventSource.class);
    private String fileName;
    private Map<String, String> configurationProperties = new HashMap<String, String>();

    public SynapseEventSource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void buildService(AxisConfiguration axisCfg) throws AxisFault {
        AxisService eventSourceService = new AxisService();
        eventSourceService.setName(this.name);
        this.addOperations(eventSourceService);
        axisCfg.addService(eventSourceService);
        eventSourceService.addParameter("subscriptionManager", (Object)this.subscriptionManager);
        eventSourceService.addParameter("serviceType", (Object)"eventing");
    }

    public void receive(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        SynapseConfiguration synCfg = (SynapseConfiguration)mc.getConfigurationContext().getAxisConfiguration().getParameter("synapse.config").getValue();
        SynapseEnvironment synEnv = (SynapseEnvironment)mc.getConfigurationContext().getAxisConfiguration().getParameter("synapse.env").getValue();
        Axis2MessageContext smc = new Axis2MessageContext(mc, synCfg, synEnv);
        ResponseMessageBuilder messageBuilder = new ResponseMessageBuilder(mc);
        try {
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe".equals(mc.getWSAAction())) {
                this.processSubscriptionRequest(mc, messageBuilder);
            } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe".equals(mc.getWSAAction())) {
                this.processUnSubscribeRequest(mc, messageBuilder);
            } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus".equals(mc.getWSAAction())) {
                this.processGetStatusRequest(mc, messageBuilder);
            } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew".equals(mc.getWSAAction())) {
                this.processReNewRequest(mc, messageBuilder);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Event received");
                }
                this.dispatchEvents(smc);
            }
        }
        catch (EventException e) {
            this.handleException("Subscription manager processing error", (Exception)((Object)e));
        }
    }

    private void dispatchResponse(SOAPEnvelope soapEnvelope, String responseAction, org.apache.axis2.context.MessageContext mc, boolean faultMessage) throws AxisFault {
        org.apache.axis2.context.MessageContext rmc = MessageContextBuilder.createOutMessageContext((org.apache.axis2.context.MessageContext)mc);
        rmc.getOperationContext().addMessageContext(rmc);
        rmc.setEnvelope(soapEnvelope);
        rmc.setWSAAction(responseAction);
        rmc.setSoapAction(responseAction);
        rmc.setProperty("synapse.isresponse", (Object)Boolean.TRUE);
        if (faultMessage) {
            AxisEngine.sendFault((org.apache.axis2.context.MessageContext)rmc);
        } else {
            AxisEngine.send((org.apache.axis2.context.MessageContext)rmc);
        }
    }

    public void dispatchEvents(MessageContext msgCtx) {
        Object subscribers = null;
        msgCtx.getEnvironment().getExecutorService().execute(new EventDispatcher(msgCtx));
    }

    private void processSubscriptionRequest(org.apache.axis2.context.MessageContext mc, ResponseMessageBuilder messageBuilder) throws AxisFault, EventException {
        SynapseSubscription subscription = SubscriptionMessageBuilder.createSubscription(mc);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SynapseSubscription request recived  : " + subscription.getId()));
        }
        if (subscription.getId() != null) {
            String subID = this.subscriptionManager.subscribe((Subscription)subscription);
            if (subID != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending subscription response for SynapseSubscription ID : " + subscription.getId()));
                }
                SOAPEnvelope soapEnvelope = messageBuilder.genSubscriptionResponse(subscription);
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse", mc, false);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SynapseSubscription Failed, sending fault response");
                }
                SOAPEnvelope soapEnvelope = messageBuilder.genFaultResponse(mc, "Receiver", "EventSourceUnableToProcess", "Unable to subscribe ", "");
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SynapseSubscription Failed, sending fault response");
            }
            SOAPEnvelope soapEnvelope = messageBuilder.genFaultResponse(mc, SubscriptionMessageBuilder.getErrorCode(), SubscriptionMessageBuilder.getErrorSubCode(), SubscriptionMessageBuilder.getErrorReason(), "");
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
        }
    }

    private void processUnSubscribeRequest(org.apache.axis2.context.MessageContext mc, ResponseMessageBuilder messageBuilder) throws AxisFault, EventException {
        SynapseSubscription subscription = SubscriptionMessageBuilder.createUnSubscribeMessage(mc);
        if (log.isDebugEnabled()) {
            log.debug((Object)("UnSubscribe response recived for SynapseSubscription ID : " + subscription.getId()));
        }
        if (this.subscriptionManager.unsubscribe(subscription.getId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending UnSubscribe responce for SynapseSubscription ID : " + subscription.getId()));
            }
            SOAPEnvelope soapEnvelope = messageBuilder.genUnSubscribeResponse(subscription);
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse", mc, false);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"UnSubscription failed, sending fault repsponse");
            }
            SOAPEnvelope soapEnvelope = messageBuilder.genFaultResponse(mc, "Receiver", "EventSourceUnableToProcess", "Unable to Unsubscribe", "");
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
        }
    }

    private void processGetStatusRequest(org.apache.axis2.context.MessageContext mc, ResponseMessageBuilder messageBuilder) throws AxisFault, EventException {
        SynapseSubscription subscription = SubscriptionMessageBuilder.createGetStatusMessage(mc);
        if (log.isDebugEnabled()) {
            log.debug((Object)("GetStatus request recived for SynapseSubscription ID : " + subscription.getId()));
        }
        if ((subscription = this.subscriptionManager.getSubscription(subscription.getId())) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending GetStatus responce for SynapseSubscription ID : " + subscription.getId()));
            }
            SOAPEnvelope soapEnvelope = messageBuilder.genGetStatusResponse(subscription);
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse", mc, false);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"GetStatus failed, sending fault response");
            }
            SOAPEnvelope soapEnvelope = messageBuilder.genFaultResponse(mc, "Receiver", "EventSourceUnableToProcess", "Subscription Not Found", "");
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
        }
    }

    private void processReNewRequest(org.apache.axis2.context.MessageContext mc, ResponseMessageBuilder messageBuilder) throws AxisFault, EventException {
        String subID;
        SynapseSubscription subscription = SubscriptionMessageBuilder.createRenewSubscribeMessage(mc);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ReNew request recived for SynapseSubscription ID : " + subscription.getId()));
        }
        if ((subID = subscription.getId()) != null) {
            if (this.subscriptionManager.renew((Subscription)subscription)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending ReNew response for SynapseSubscription ID : " + subscription.getId()));
                }
                SOAPEnvelope soapEnvelope = messageBuilder.genRenewSubscriptionResponse(subscription);
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse", mc, false);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ReNew failed, sending fault response");
                }
                SOAPEnvelope soapEnvelope = messageBuilder.genFaultResponse(mc, "Receiver", "UnableToRenew", "Subscription Not Found", "");
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
            }
        } else {
            SOAPEnvelope soapEnvelope = messageBuilder.genFaultResponse(mc, SubscriptionMessageBuilder.getErrorCode(), SubscriptionMessageBuilder.getErrorSubCode(), SubscriptionMessageBuilder.getErrorReason(), "");
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
        }
    }

    private Endpoint getEndpointFromURL(String endpointUrl, SynapseEnvironment se) {
        AddressEndpoint endpoint = new AddressEndpoint();
        EndpointDefinition def = new EndpointDefinition();
        def.setAddress(endpointUrl.trim());
        endpoint.setDefinition(def);
        endpoint.init(se);
        return endpoint;
    }

    private void addOperations(AxisService eventSourceService) throws AxisFault {
        InOutAxisOperation mediateOperation = new InOutAxisOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
        InOutAxisOperation subscribeOperation = new InOutAxisOperation(new QName("SubscribeOp"));
        InOutAxisOperation unsubscribeOperation = new InOutAxisOperation(new QName("UnsubscribeOp"));
        InOutAxisOperation renewOperation = new InOutAxisOperation(new QName("RenewOp"));
        InOutAxisOperation getStatusOperation = new InOutAxisOperation(new QName("GetStatusOp"));
        InOutAxisOperation subscriptionEndOperation = new InOutAxisOperation(new QName("SubscriptionEnd"));
        mediateOperation.setMessageReceiver((MessageReceiver)this);
        subscribeOperation.setMessageReceiver((MessageReceiver)this);
        unsubscribeOperation.setMessageReceiver((MessageReceiver)this);
        renewOperation.setMessageReceiver((MessageReceiver)this);
        getStatusOperation.setMessageReceiver((MessageReceiver)this);
        subscriptionEndOperation.setMessageReceiver((MessageReceiver)this);
        subscribeOperation.setSoapAction("http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe");
        unsubscribeOperation.setSoapAction("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe");
        renewOperation.setSoapAction("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew");
        getStatusOperation.setSoapAction("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus");
        eventSourceService.addOperation((AxisOperation)mediateOperation);
        eventSourceService.addOperation((AxisOperation)subscribeOperation);
        eventSourceService.addOperation((AxisOperation)unsubscribeOperation);
        eventSourceService.addOperation((AxisOperation)renewOperation);
        eventSourceService.addOperation((AxisOperation)getStatusOperation);
        eventSourceService.addOperation((AxisOperation)subscriptionEndOperation);
    }

    public void putConfigurationProperty(String name, String value) {
        this.configurationProperties.put(name, value);
    }

    public String getConfigurationProperty(String name) {
        return this.configurationProperties.get(name);
    }

    public boolean isContainsConfigurationProperty(String name) {
        return this.configurationProperties.containsKey(name);
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new SynapseException(message, e);
    }

    class EventDispatcher
    implements Runnable {
        private MessageContext synCtx;
        private List<Subscription> subscriptions;

        EventDispatcher(MessageContext synCtx) {
            this.synCtx = synCtx;
        }

        public void run() {
            try {
                org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext();
                Event event = new Event((Object)msgCtx);
                this.subscriptions = SynapseEventSource.this.subscriptionManager.getMatchingSubscriptions(event);
            }
            catch (EventException e) {
                SynapseEventSource.this.handleException("Matching subscriptions fetching error", (Exception)((Object)e));
            }
            for (Subscription subscription : this.subscriptions) {
                this.synCtx.setProperty("OUT_ONLY", "true");
                try {
                    SynapseEventSource.this.getEndpointFromURL(subscription.getEndpointUrl(), this.synCtx.getEnvironment()).send(MessageHelper.cloneMessageContext(this.synCtx));
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Event sending failure " + axisFault.toString()));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Event push to  : " + subscription.getEndpointUrl()));
            }
        }
    }
}

