/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.rest.APIFactory;
import org.apache.synapse.config.xml.rest.APISerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.rest.API;

public class APIDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(APIDeployer.class);

    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("API deployment from file : " + fileName + " : Started"));
        }
        try {
            API api = APIFactory.createAPI(artifactConfig);
            if (api != null) {
                api.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API named '" + api.getName() + "' has been built from the file " + fileName));
                }
                api.init(this.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the API: " + api.getName()));
                }
                this.getSynapseConfiguration().addAPI(api.getName(), api);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("API named '" + api.getName() + "' has been deployed from file : " + fileName));
                return api.getName();
            }
            this.handleSynapseArtifactDeploymentError("API deployment Failed. The artifact described in the file " + fileName + " is not a valid API");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("API deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("API update from file : " + fileName + " has started"));
        }
        try {
            API api = APIFactory.createAPI(artifactConfig);
            if (api == null) {
                this.handleSynapseArtifactDeploymentError("API update failed. The artifact defined in the file: " + fileName + " is not a valid API.");
                return null;
            }
            api.setFileName(new File(fileName).getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("API: " + api.getName() + " has been built from the file: " + fileName));
            }
            api.init(this.getSynapseEnvironment());
            API existingAPI = this.getSynapseConfiguration().getAPI(existingArtifactName);
            if (existingArtifactName.equals(api.getName())) {
                this.getSynapseConfiguration().updateAPI(existingArtifactName, api);
            } else {
                this.getSynapseConfiguration().addAPI(api.getName(), api);
                this.getSynapseConfiguration().removeAPI(existingArtifactName);
                log.info((Object)("API: " + existingArtifactName + " has been undeployed"));
            }
            log.info((Object)("API: " + api.getName() + " has been updated from the file: " + fileName));
            this.waitForCompletion();
            existingAPI.destroy();
            return api.getName();
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the API from the file: " + fileName);
            return null;
        }
    }

    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeployment of the API named : " + artifactName + " : Started"));
        }
        try {
            API api = this.getSynapseConfiguration().getAPI(artifactName);
            if (api != null) {
                this.getSynapseConfiguration().removeAPI(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Undeployment of the API named : " + artifactName + " : Completed"));
                }
                log.info((Object)("API named '" + api.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("API " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Undeployment of API named : " + artifactName + " : Failed", e);
        }
    }

    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the API with name : " + artifactName + " : Started"));
        }
        try {
            API api = this.getSynapseConfiguration().getAPI(artifactName);
            OMElement apiElement = APISerializer.serializeAPI(api);
            if (api.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "api" + File.separator + api.getFileName();
                this.writeToFile(apiElement, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the API with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("API named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the API named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the API named '" + artifactName + "' has failed", e);
        }
    }
}

