/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.TargetResolver;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SynapseCallbackReceiver;

public class DynamicAxisOperation
extends OutInAxisOperation {
    public DynamicAxisOperation() {
    }

    public DynamicAxisOperation(QName name) {
        super(name);
    }

    public OperationClient createClient(ServiceContext sc, Options options) {
        return new DynamicOperationClient(this, sc, options);
    }

    static class DynamicOperationClient
    extends OperationClient {
        DynamicOperationClient(OutInAxisOperation axisOp, ServiceContext sc, Options options) {
            super((AxisOperation)axisOp, sc, options);
        }

        public void addMessageContext(MessageContext mc) throws AxisFault {
            mc.setServiceContext(this.sc);
            if (mc.getMessageID() == null) {
                this.setMessageID(mc);
            }
            this.axisOp.registerOperationContext(mc, this.oc);
        }

        public MessageContext getMessageContext(String messageLabel) throws AxisFault {
            return this.oc.getMessageContext(messageLabel);
        }

        public void setCallback(Callback callback) {
            this.callback = callback;
        }

        public void executeImpl(boolean block) throws AxisFault {
            SynapseCallbackReceiver callbackReceiver;
            TransportOutDescription transportOut;
            if (this.completed) {
                throw new AxisFault(Messages.getMessage((String)"mepiscomplted"));
            }
            MessageContext outMsgCtx = this.oc.getMessageContext("Out");
            if (outMsgCtx == null) {
                throw new AxisFault(Messages.getMessage((String)"outmsgctxnull"));
            }
            ConfigurationContext cfgCtx = this.sc.getConfigurationContext();
            outMsgCtx.setOptions(this.options);
            TargetResolver tr = cfgCtx.getAxisConfiguration().getTargetResolverChain();
            if (tr != null) {
                tr.resolveTarget(outMsgCtx);
            }
            if ((transportOut = this.options.getTransportOut()) == null) {
                EndpointReference toEPR = this.options.getTo() != null ? this.options.getTo() : outMsgCtx.getTo();
                transportOut = ClientUtils.inferOutTransport((AxisConfiguration)cfgCtx.getAxisConfiguration(), (EndpointReference)toEPR, (MessageContext)outMsgCtx);
            }
            outMsgCtx.setTransportOut(transportOut);
            if (this.options.getTransportIn() == null && outMsgCtx.getTransportIn() == null) {
                outMsgCtx.setTransportIn(ClientUtils.inferInTransport((AxisConfiguration)cfgCtx.getAxisConfiguration(), (Options)this.options, (MessageContext)outMsgCtx));
            } else if (outMsgCtx.getTransportIn() == null) {
                outMsgCtx.setTransportIn(this.options.getTransportIn());
            }
            this.addReferenceParameters(outMsgCtx);
            if (this.options.isUseSeparateListener()) {
                this.options.setTransportIn(outMsgCtx.getConfigurationContext().getAxisConfiguration().getTransportIn("http"));
                callbackReceiver = (SynapseCallbackReceiver)this.axisOp.getMessageReceiver();
                ((Axis2MessageContext)((AsyncCallback)this.axisCallback).getSynapseOutMsgCtx()).getAxis2MessageContext().setProperty("IGNORE_SC_ACCEPTED", (Object)"true");
                callbackReceiver.addCallback(outMsgCtx.getMessageID(), this.axisCallback);
                EndpointReference replyToFromTransport = outMsgCtx.getConfigurationContext().getListenerManager().getEPRforService(this.sc.getAxisService().getName(), this.axisOp.getName().getLocalPart(), outMsgCtx.getTransportOut().getName());
                if (outMsgCtx.getReplyTo() == null) {
                    outMsgCtx.setReplyTo(replyToFromTransport);
                } else {
                    outMsgCtx.getReplyTo().setAddress(replyToFromTransport.getAddress());
                }
                outMsgCtx.getConfigurationContext().registerOperationContext(outMsgCtx.getMessageID(), this.oc);
                AxisEngine.send((MessageContext)outMsgCtx);
                this.options.setAction("");
            } else {
                callbackReceiver = (SynapseCallbackReceiver)this.axisOp.getMessageReceiver();
                callbackReceiver.addCallback(outMsgCtx.getMessageID(), this.axisCallback);
                this.send(outMsgCtx);
            }
        }

        private void send(MessageContext msgctx) throws AxisFault {
            MessageContext responseMessageContext = new MessageContext();
            responseMessageContext.setMessageID(msgctx.getMessageID());
            responseMessageContext.setProperty("synapse.RelatesToForPox", (Object)msgctx.getMessageID());
            responseMessageContext.setOptions(this.options);
            responseMessageContext.setServerSide(true);
            this.addMessageContext(responseMessageContext);
            responseMessageContext.setProperty("synapse.send", (Object)"true");
            AxisEngine.send((MessageContext)msgctx);
            if (msgctx.getProperty("TRANSPORT_IN") != null) {
                responseMessageContext.setOperationContext(msgctx.getOperationContext());
                responseMessageContext.setAxisMessage(msgctx.getOperationContext().getAxisOperation().getMessage("In"));
                responseMessageContext.setAxisService(msgctx.getAxisService());
                responseMessageContext.setProperty("TRANSPORT_OUT", msgctx.getProperty("TRANSPORT_OUT"));
                responseMessageContext.setProperty("OutTransportInfo", msgctx.getProperty("OutTransportInfo"));
                responseMessageContext.setProperty("synapse.isresponse", (Object)Boolean.TRUE);
                responseMessageContext.setTransportIn(msgctx.getTransportIn());
                responseMessageContext.setTransportOut(msgctx.getTransportOut());
                responseMessageContext.setDoingREST(msgctx.isDoingREST());
                responseMessageContext.setProperty("TRANSPORT_IN", msgctx.getProperty("TRANSPORT_IN"));
                responseMessageContext.setTransportIn(msgctx.getTransportIn());
                responseMessageContext.setTransportOut(msgctx.getTransportOut());
                responseMessageContext.setSoapAction("");
                if (responseMessageContext.getEnvelope() == null) {
                    SOAPEnvelope resenvelope;
                    Options options = responseMessageContext.getOptions();
                    if (options != null) {
                        RelatesTo relatesTo = options.getRelatesTo();
                        if (relatesTo != null) {
                            relatesTo.setValue(msgctx.getMessageID());
                        } else {
                            options.addRelatesTo(new RelatesTo(msgctx.getMessageID()));
                        }
                    }
                    if ((resenvelope = TransportUtils.createSOAPMessage((MessageContext)responseMessageContext)) != null) {
                        responseMessageContext.setEnvelope(resenvelope);
                        AxisEngine.receive((MessageContext)responseMessageContext);
                        if (responseMessageContext.getReplyTo() != null) {
                            this.sc.setTargetEPR(responseMessageContext.getReplyTo());
                        }
                        this.complete(msgctx);
                    } else {
                        throw new AxisFault(Messages.getMessage((String)"blockingInvocationExpectsResponse"));
                    }
                }
            }
        }
    }
}

