/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.endpoints.EndpointDefinition;

public class EndpointDefinitionFactory
implements DefinitionFactory {
    public static final Log log = LogFactory.getLog(EndpointDefinitionFactory.class);

    public EndpointDefinition createDefinition(OMElement elem) {
        OMElement retryDisabledErrorCodes;
        OMElement retryConfig;
        OMElement suspendOnFailure;
        OMElement suspendDurationOnFailure;
        OMElement markAsTimedOut;
        OMElement timeout;
        OMElement wsRm;
        OMElement wsSec;
        OMElement wsAddr;
        EndpointDefinition definition = new EndpointDefinition();
        OMAttribute optimize = elem.getAttribute(new QName("", "optimize"));
        OMAttribute encoding = elem.getAttribute(new QName("", "encoding"));
        OMAttribute trace = elem.getAttribute(new QName("", "trace"));
        if (trace != null && trace.getAttributeValue() != null) {
            String traceValue = trace.getAttributeValue();
            if ("enable".equals(traceValue)) {
                definition.setTraceState(1);
            } else if ("disable".equals(traceValue)) {
                definition.setTraceState(0);
            }
        } else {
            definition.setTraceState(2);
        }
        if (optimize != null && optimize.getAttributeValue().length() > 0) {
            String method = optimize.getAttributeValue().trim();
            if ("mtom".equalsIgnoreCase(method)) {
                definition.setUseMTOM(true);
            } else if ("swa".equalsIgnoreCase(method)) {
                definition.setUseSwa(true);
            }
        }
        if (encoding != null && encoding.getAttributeValue() != null) {
            definition.setCharSetEncoding(encoding.getAttributeValue());
        }
        if ((wsAddr = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableAddressing"))) != null) {
            String useSepList;
            definition.setAddressingOn(true);
            OMAttribute version = wsAddr.getAttribute(new QName("version"));
            if (version != null && version.getAttributeValue() != null) {
                String versionValue = version.getAttributeValue().trim().toLowerCase();
                if ("final".equals(versionValue) || "submission".equals(versionValue)) {
                    definition.setAddressingVersion(version.getAttributeValue());
                } else {
                    EndpointDefinitionFactory.handleException("Unknown value for the addressing version. Possible values for the addressing version are 'final' and 'submission' only.");
                }
            }
            if ((useSepList = wsAddr.getAttributeValue(new QName("separateListener"))) != null && "true".equals(useSepList.trim().toLowerCase())) {
                definition.setUseSeparateListener(true);
            }
        }
        if ((wsSec = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec"))) != null) {
            definition.setSecurityOn(true);
            OMAttribute policyKey = wsSec.getAttribute(new QName("", "policy"));
            OMAttribute inboundPolicyKey = wsSec.getAttribute(new QName("", "inboundPolicy"));
            OMAttribute outboundPolicyKey = wsSec.getAttribute(new QName("", "outboundPolicy"));
            if (policyKey != null && policyKey.getAttributeValue() != null) {
                definition.setWsSecPolicyKey(policyKey.getAttributeValue());
            } else {
                if (inboundPolicyKey != null && inboundPolicyKey.getAttributeValue() != null) {
                    definition.setInboundWsSecPolicyKey(inboundPolicyKey.getAttributeValue());
                }
                if (outboundPolicyKey != null && outboundPolicyKey.getAttributeValue() != null) {
                    definition.setOutboundWsSecPolicyKey(outboundPolicyKey.getAttributeValue());
                }
            }
        }
        if ((wsRm = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableRM"))) != null) {
            definition.setReliableMessagingOn(true);
            OMAttribute policy = wsRm.getAttribute(new QName("", "policy"));
            if (policy != null) {
                definition.setWsRMPolicyKey(policy.getAttributeValue());
            }
        }
        if ((timeout = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "timeout"))) != null) {
            OMElement action;
            String d;
            OMElement duration = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "duration"));
            if (duration != null && (d = duration.getText()) != null) {
                try {
                    long timeoutMilliSeconds = Long.parseLong(d.trim());
                    definition.setTimeoutDuration(timeoutMilliSeconds);
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("Endpoint timeout duration expected as a number but was not a number");
                }
            }
            if ((action = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "responseAction"))) != null && action.getText() != null) {
                String actionString = action.getText();
                if ("discard".equalsIgnoreCase(actionString.trim())) {
                    definition.setTimeoutAction(101);
                    if (definition.getTimeoutDuration() == 0L) {
                        definition.setTimeoutDuration(30000L);
                    }
                } else if ("fault".equalsIgnoreCase(actionString.trim())) {
                    definition.setTimeoutAction(102);
                    if (definition.getTimeoutDuration() == 0L) {
                        definition.setTimeoutDuration(30000L);
                    }
                } else {
                    EndpointDefinitionFactory.handleException("Invalid timeout action, action : " + actionString + " is not supported");
                }
            }
        }
        if ((markAsTimedOut = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "markForSuspension"))) != null) {
            OMElement retryDelay;
            OMElement retriesBeforeSuspend;
            OMElement timeoutCodes = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "errorCodes"));
            if (timeoutCodes != null && timeoutCodes.getText() != null) {
                StringTokenizer st = new StringTokenizer(timeoutCodes.getText().trim(), ", ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        definition.addTimeoutErrorCode(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        EndpointDefinitionFactory.handleException("The timeout error codes should be specified as valid numbers separated by commas : " + timeoutCodes.getText(), e);
                    }
                }
            }
            if ((retriesBeforeSuspend = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retriesBeforeSuspension"))) != null && retriesBeforeSuspend.getText() != null) {
                try {
                    definition.setRetriesOnTimeoutBeforeSuspend(Integer.parseInt(retriesBeforeSuspend.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The retries before suspend [for timeouts] should be specified as a valid number : " + retriesBeforeSuspend.getText(), e);
                }
            }
            if ((retryDelay = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retryDelay"))) != null && retryDelay.getText() != null) {
                try {
                    definition.setRetryDurationOnTimeout(Integer.parseInt(retryDelay.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The retry delay for timeouts should be specified as a valid number : " + retryDelay.getText(), e);
                }
            }
        }
        if ((suspendDurationOnFailure = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendDurationOnFailure"))) != null && suspendDurationOnFailure.getText() != null) {
            log.warn((Object)"Configuration uses deprecated style for endpoint 'suspendDurationOnFailure'");
            try {
                definition.setInitialSuspendDuration(1000L * Long.parseLong(suspendDurationOnFailure.getText().trim()));
                definition.setSuspendProgressionFactor(1.0f);
            }
            catch (NumberFormatException e) {
                EndpointDefinitionFactory.handleException("The initial suspend duration should be specified as a valid number : " + suspendDurationOnFailure.getText(), e);
            }
        }
        if ((suspendOnFailure = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendOnFailure"))) != null) {
            OMElement maximumDuration;
            OMElement progressionFactor;
            OMElement initialDuration;
            OMElement suspendCodes = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "errorCodes"));
            if (suspendCodes != null && suspendCodes.getText() != null) {
                StringTokenizer st = new StringTokenizer(suspendCodes.getText().trim(), ", ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        definition.addSuspendErrorCode(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        EndpointDefinitionFactory.handleException("The suspend error codes should be specified as valid numbers separated by commas : " + suspendCodes.getText(), e);
                    }
                }
            }
            if ((initialDuration = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "initialDuration"))) != null && initialDuration.getText() != null) {
                try {
                    definition.setInitialSuspendDuration(Integer.parseInt(initialDuration.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The initial suspend duration should be specified as a valid number : " + initialDuration.getText(), e);
                }
            }
            if ((progressionFactor = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "progressionFactor"))) != null && progressionFactor.getText() != null) {
                try {
                    definition.setSuspendProgressionFactor(Float.parseFloat(progressionFactor.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The suspend duration progression factor should be specified as a valid float : " + progressionFactor.getText(), e);
                }
            }
            if ((maximumDuration = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "maximumDuration"))) != null && maximumDuration.getText() != null) {
                try {
                    definition.setSuspendMaximumDuration(Long.parseLong(maximumDuration.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The maximum suspend duration should be specified as a valid number : " + maximumDuration.getText(), e);
                }
            }
        }
        if ((retryConfig = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retryConfig"))) != null && (retryDisabledErrorCodes = retryConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "disabledErrorCodes"))) != null && retryDisabledErrorCodes.getText() != null) {
            StringTokenizer st = new StringTokenizer(retryDisabledErrorCodes.getText().trim(), ", ");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                try {
                    definition.addRetryDisabledErrorCode(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The suspend error codes should be specified as valid numbers separated by commas : " + retryDisabledErrorCodes.getText(), e);
                }
            }
        }
        return definition;
    }

    protected static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

