/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.transform.PayloadFactoryMediator;

public class PayloadFactoryMediatorSerializer
extends AbstractMediatorSerializer {
    private static final String PAYLOAD_FACTORY = "payloadFactory";
    private static final String FORMAT = "format";
    private static final String ARGS = "args";
    private static final String ARG = "arg";
    private static final String VALUE = "value";
    private static final String EXPRESSION = "expression";

    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof PayloadFactoryMediator)) {
            this.handleException("Unsupported mediator was passed in for serialization: " + m.getType());
            return null;
        }
        PayloadFactoryMediator mediator = (PayloadFactoryMediator)m;
        OMElement payloadFactoryElem = fac.createOMElement(PAYLOAD_FACTORY, synNS);
        PayloadFactoryMediatorSerializer.saveTracingState(payloadFactoryElem, mediator);
        if (mediator.getFormat() != null) {
            try {
                OMElement formatElem = fac.createOMElement(FORMAT, synNS);
                formatElem.addChild((OMNode)AXIOMUtil.stringToOM((String)mediator.getFormat()));
                payloadFactoryElem.addChild((OMNode)formatElem);
            }
            catch (XMLStreamException e) {
                this.handleException("Error while serializing payloadFactory mediator", e);
            }
        } else {
            this.handleException("Invalid payloadFactory mediator, format is required");
        }
        List<PayloadFactoryMediator.Argument> argList = mediator.getArgumentList();
        if (argList != null && argList.size() > 0) {
            OMElement argumentsElem = fac.createOMElement(ARGS, synNS);
            for (PayloadFactoryMediator.Argument arg : argList) {
                OMElement argElem = fac.createOMElement(ARG, synNS);
                if (arg.getValue() != null) {
                    argElem.addAttribute(fac.createOMAttribute(VALUE, nullNS, arg.getValue()));
                } else if (arg.getExpression() != null) {
                    SynapseXPathSerializer.serializeXPath(arg.getExpression(), argElem, EXPRESSION);
                }
                argumentsElem.addChild((OMNode)argElem);
            }
            payloadFactoryElem.addChild((OMNode)argumentsElem);
        }
        return payloadFactoryElem;
    }

    public String getMediatorClassName() {
        return PayloadFactoryMediator.class.getName();
    }
}

