/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.template.InvokeMediator;

public class InvokeMediatorFactory
extends AbstractMediatorFactory {
    private static final QName INVOKE_Q = new QName("http://ws.apache.org/ns/synapse", "call-template");
    public static final QName WITH_PARAM_Q = new QName("http://ws.apache.org/ns/synapse", "with-param");
    InvokeMediator invoker;

    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        this.invoker = new InvokeMediator();
        OMAttribute targetTemplateAttr = elem.getAttribute(ATT_TARGET);
        if (targetTemplateAttr == null) {
            String msg = "EIP Invoke mediator should have a target template specified.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.invoker.setTargetTemplate(targetTemplateAttr.getAttributeValue());
        this.buildParameters(elem);
        return this.invoker;
    }

    private void buildParameters(OMElement elem) {
        Iterator subElements = elem.getChildElements();
        while (subElements.hasNext()) {
            OMElement child = (OMElement)subElements.next();
            if (!child.getQName().equals(WITH_PARAM_Q)) continue;
            OMAttribute paramNameAttr = child.getAttribute(ATT_NAME);
            Value paramValue = new ValueFactory().createValue("value", child);
            if (paramNameAttr == null) continue;
            this.invoker.addExpressionForParamName(paramNameAttr.getAttributeValue(), paramValue);
        }
    }

    public QName getTagQName() {
        return INVOKE_Q;
    }
}

