/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.transform.HeaderMediator;

public class HeaderMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof HeaderMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        HeaderMediator mediator = (HeaderMediator)m;
        OMElement header = fac.createOMElement("header", synNS);
        HeaderMediatorSerializer.saveTracingState(header, mediator);
        QName qName = mediator.getQName();
        if (qName != null) {
            if (qName.getNamespaceURI().length() != 0) {
                header.addAttribute(fac.createOMAttribute("name", nullNS, (qName.getPrefix() != null && !"".equals(qName.getPrefix()) ? qName.getPrefix() + ":" : "") + qName.getLocalPart()));
                header.declareNamespace(qName.getNamespaceURI(), qName.getPrefix());
            } else {
                header.addAttribute(fac.createOMAttribute("name", nullNS, qName.getLocalPart()));
            }
        }
        if (mediator.getAction() == 1) {
            header.addAttribute(fac.createOMAttribute("action", nullNS, "remove"));
        } else if (mediator.getValue() != null) {
            header.addAttribute(fac.createOMAttribute("value", nullNS, mediator.getValue()));
        } else if (mediator.getExpression() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getExpression(), header, "expression");
        } else {
            this.handleException("Value or expression required for a set header mediator");
        }
        return header;
    }

    public String getMediatorClassName() {
        return HeaderMediator.class.getName();
    }
}

