/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.eip.aggregator.AggregateMediator;

public class AggregateMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator m) {
        AggregateMediator mediator = null;
        if (!(m instanceof AggregateMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        } else {
            mediator = (AggregateMediator)m;
        }
        assert (mediator != null);
        OMElement aggregator = fac.createOMElement("aggregate", synNS);
        AggregateMediatorSerializer.saveTracingState(aggregator, mediator);
        if (mediator.getId() != null) {
            aggregator.addAttribute("id", mediator.getId(), nullNS);
        }
        if (mediator.getCorrelateExpression() != null) {
            OMElement corelateOn = fac.createOMElement("correlateOn", synNS);
            SynapseXPathSerializer.serializeXPath(mediator.getCorrelateExpression(), corelateOn, "expression");
            aggregator.addChild((OMNode)corelateOn);
        }
        OMElement completeCond = fac.createOMElement("completeCondition", synNS);
        if (mediator.getCompletionTimeoutMillis() != 0L) {
            completeCond.addAttribute("timeout", Long.toString(mediator.getCompletionTimeoutMillis() / 1000L), nullNS);
        }
        OMElement messageCount = fac.createOMElement("messageCount", synNS);
        if (mediator.getMinMessagesToComplete() != 0) {
            messageCount.addAttribute("min", Integer.toString(mediator.getMinMessagesToComplete()), nullNS);
        }
        if (mediator.getMaxMessagesToComplete() != 0) {
            messageCount.addAttribute("max", Integer.toString(mediator.getMaxMessagesToComplete()), nullNS);
        }
        completeCond.addChild((OMNode)messageCount);
        aggregator.addChild((OMNode)completeCond);
        OMElement onCompleteElem = fac.createOMElement("onComplete", synNS);
        if (mediator.getAggregationExpression() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getAggregationExpression(), onCompleteElem, "expression");
        }
        if (mediator.getOnCompleteSequenceRef() != null) {
            onCompleteElem.addAttribute("sequence", mediator.getOnCompleteSequenceRef(), nullNS);
        } else if (mediator.getOnCompleteSequence() != null) {
            new SequenceMediatorSerializer().serializeChildren(onCompleteElem, mediator.getOnCompleteSequence().getList());
        }
        aggregator.addChild((OMNode)onCompleteElem);
        return aggregator;
    }

    public String getMediatorClassName() {
        return AggregateMediator.class.getName();
    }
}

