/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerState;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.statistics.StatisticsCollector;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapseObserver;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.DropMediator;
import org.apache.synapse.mediators.builtin.LogMediator;
import org.apache.synapse.securevault.definition.IdentityKeyStoreInformation;
import org.apache.synapse.securevault.definition.KeyStoreInformationFactory;
import org.apache.synapse.securevault.definition.TrustKeyStoreInformation;
import org.apache.synapse.util.SynapseBinaryDataSource;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynapseConfigUtils {
    private static final Log log = LogFactory.getLog(SynapseConfigUtils.class);

    public static StreamSource getStreamSource(Object o) {
        if (o == null) {
            SynapseConfigUtils.handleException("Cannot convert null to a StreamSource");
        } else if (o instanceof OMElement) {
            OMElement omElement = (OMElement)o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                omElement.serialize((OutputStream)baos);
                return new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (XMLStreamException e) {
                SynapseConfigUtils.handleException("Error converting to a StreamSource", e);
            }
        } else if (o instanceof OMText) {
            DataHandler dataHandler = (DataHandler)((OMText)o).getDataHandler();
            if (dataHandler != null) {
                try {
                    return new StreamSource(dataHandler.getInputStream());
                }
                catch (IOException e) {
                    SynapseConfigUtils.handleException("Error in reading content as a stream ");
                }
            }
        } else {
            SynapseConfigUtils.handleException("Cannot convert object to a StreamSource");
        }
        return null;
    }

    public static InputStream getInputStream(Object o) {
        if (o == null) {
            SynapseConfigUtils.handleException("Cannot convert null to a StreamSource");
        } else if (o instanceof OMElement) {
            OMElement omElement = (OMElement)o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                omElement.serialize((OutputStream)baos);
                return new ByteArrayInputStream(baos.toByteArray());
            }
            catch (XMLStreamException e) {
                SynapseConfigUtils.handleException("Error converting to a StreamSource", e);
            }
        } else if (o instanceof OMText) {
            DataHandler dataHandler = (DataHandler)((OMText)o).getDataHandler();
            if (dataHandler != null) {
                try {
                    return dataHandler.getInputStream();
                }
                catch (IOException e) {
                    SynapseConfigUtils.handleException("Error in reading content as a stream ");
                }
            }
        } else if (o instanceof URI) {
            try {
                return ((URI)o).toURL().openStream();
            }
            catch (IOException e) {
                SynapseConfigUtils.handleException("Error opening stream form URI", e);
            }
        } else {
            SynapseConfigUtils.handleException("Cannot convert object to a StreamSource");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getObject(URL url, Properties properties) {
        try {
            OMNode oMNode;
            block24: {
                if (url != null && "file".equals(url.getProtocol())) {
                    try {
                        url.openStream();
                    }
                    catch (IOException ignored) {
                        String synapseHome;
                        String path = url.getPath();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Can not open a connection to the URL with a path :" + path));
                        }
                        if ((synapseHome = (String)properties.get("synapse.home")) == null) break block24;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying  to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                        }
                        if (synapseHome.endsWith("/")) {
                            synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
                        }
                        url = new URL(url.getProtocol() + ":" + synapseHome + "/" + path);
                        try {
                            url.openStream();
                        }
                        catch (IOException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Failed to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                            }
                            log.warn((Object)("IO Error reading from URL " + url.getPath() + e));
                        }
                    }
                }
            }
            if (url == null) {
                return null;
            }
            URLConnection connection = SynapseConfigUtils.getURLConnection(url);
            if (connection == null) {
                if (!log.isDebugEnabled()) return null;
                log.debug((Object)("Cannot create a URLConnection for given URL : " + url));
                return null;
            }
            XMLToObjectMapper xmlToObject = SynapseConfigUtils.getXmlToObjectMapper(connection.getContentType());
            InputStream inputStream = connection.getInputStream();
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)parser);
                OMElement omElem = builder.getDocumentElement();
                omElem.build();
                if (xmlToObject != null) {
                    Object object = xmlToObject.getObjectFromOMNode((OMNode)omElem, properties);
                    return object;
                }
                OMElement oMElement = omElem;
                return oMElement;
            }
            catch (XMLStreamException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Content at URL : " + url + " is non XML.."));
                }
                oMNode = SynapseConfigUtils.readNonXML(url);
                return oMNode;
            }
            catch (OMException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Content at URL : " + url + " is non XML.."));
                }
                oMNode = SynapseConfigUtils.readNonXML(url);
                return oMNode;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error connecting to URL : " + url, e);
            return null;
        }
    }

    public static OMNode readNonXML(URL url) {
        try {
            URLConnection newConnection = SynapseConfigUtils.getURLConnection(url);
            if (newConnection == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot create a URLConnection for given URL : " + url));
                }
                return null;
            }
            BufferedInputStream newInputStream = new BufferedInputStream(newConnection.getInputStream());
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            return omFactory.createOMText((Object)new DataHandler((DataSource)new SynapseBinaryDataSource(newInputStream, newConnection.getContentType())), true);
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error when getting a stream from resource's content", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMNode getOMElementFromURL(String urlStr, String synapseHome) throws IOException {
        URL url = SynapseConfigUtils.getURLFromPath(urlStr, synapseHome);
        if (url == null) {
            return null;
        }
        URLConnection connection = SynapseConfigUtils.getURLConnection(url);
        if (connection == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot create a URLConnection for given URL : " + urlStr));
            }
            return null;
        }
        InputStream inStream = connection.getInputStream();
        try {
            OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((InputStream)inStream);
            OMElement doc = builder.getDocumentElement();
            doc.build();
            OMElement oMElement = doc;
            return oMElement;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.info((Object)("Content at URL : " + url + " is non XML.."));
            }
            OMNode oMNode = SynapseConfigUtils.readNonXML(url);
            return oMNode;
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                log.warn((Object)("Error while closing the input stream to: " + url), (Throwable)e);
            }
        }
    }

    public static InputSource getInputSourceFormURI(URI uri) {
        if (uri == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Can not create a URL from 'null' ");
            }
            return null;
        }
        try {
            URLConnection connection;
            URL url = uri.toURL();
            String protocol = url.getProtocol();
            String path = url.getPath();
            if (protocol == null || "".equals(protocol)) {
                url = new URL("file:" + path);
            }
            if ((connection = SynapseConfigUtils.getURLConnection(url)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot create a URLConnection for given URL : " + uri));
                }
                return null;
            }
            BufferedInputStream urlInStream = new BufferedInputStream(connection.getInputStream());
            return new InputSource(urlInStream);
        }
        catch (MalformedURLException e) {
            SynapseConfigUtils.handleException("Invalid URL ' " + uri + " '", e);
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("IOError when getting a stream from given url : " + uri, e);
        }
        return null;
    }

    private static void handleException(String msg, Exception e) {
        log.warn((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static HttpsURLConnection getHttpsURLConnection(URL url, Properties synapseProperties, Proxy proxy) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a HttpsURL Connection from given URL : " + url));
        }
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        IdentityKeyStoreInformation identityInformation = KeyStoreInformationFactory.createIdentityKeyStoreInformation((Properties)synapseProperties);
        if (identityInformation != null) {
            KeyManagerFactory keyManagerFactory = identityInformation.getIdentityKeyManagerFactoryInstance();
            if (keyManagerFactory != null) {
                keyManagers = keyManagerFactory.getKeyManagers();
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"There is no private key entry store configuration. Will use JDK's default one");
        }
        TrustKeyStoreInformation trustInformation = KeyStoreInformationFactory.createTrustKeyStoreInformation((Properties)synapseProperties);
        if (trustInformation != null) {
            TrustManagerFactory trustManagerFactory = trustInformation.getTrustManagerFactoryInstance();
            if (trustManagerFactory != null) {
                trustManagers = trustManagerFactory.getTrustManagers();
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"There is no trusted certificate store configuration. Will use JDK's default one");
        }
        try {
            HttpsURLConnection connection = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            if (trustInformation != null) {
                boolean enableHostnameVerifier = true;
                String value = trustInformation.getParameter("enableHostnameVerifier");
                if (value != null) {
                    enableHostnameVerifier = Boolean.parseBoolean(value);
                }
                if (!enableHostnameVerifier) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Overriding default HostName Verifier.HostName verification disabled");
                    }
                    connection.setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String hostname, SSLSession session) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"HostName verification disabled");
                                log.trace((Object)("Host:   " + hostname));
                                log.trace((Object)("Peer Host:  " + session.getPeerHost()));
                            }
                            return true;
                        }
                    });
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Using default HostName verifier...");
                }
            }
            return connection;
        }
        catch (NoSuchAlgorithmException e) {
            SynapseConfigUtils.handleException("Error loading SSLContext ", e);
        }
        catch (KeyManagementException e) {
            SynapseConfigUtils.handleException("Error initiation SSLContext with KeyManagers", e);
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error opening a https connection from URL : " + url, e);
        }
        return null;
    }

    public static URLConnection getURLConnection(URL url) {
        try {
            URLConnection connection;
            if (url == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Provided URL is null");
                }
                return null;
            }
            if (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https")) {
                Properties synapseProperties = SynapsePropertiesLoader.loadSynapseProperties();
                String proxyHost = synapseProperties.getProperty("synapse.http.proxy.host");
                String proxyPort = synapseProperties.getProperty("synapse.http.proxy.port");
                List<String> excludedHosts = SynapseConfigUtils.getExcludedHostsForProxy(synapseProperties);
                if (proxyHost != null && proxyPort != null && !excludedHosts.contains(proxyHost)) {
                    InetSocketAddress sockaddr = new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort));
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, sockaddr);
                    connection = url.getProtocol().equalsIgnoreCase("https") ? SynapseConfigUtils.getHttpsURLConnection(url, synapseProperties, proxy) : url.openConnection(proxy);
                } else {
                    connection = url.getProtocol().equalsIgnoreCase("https") ? SynapseConfigUtils.getHttpsURLConnection(url, synapseProperties, null) : url.openConnection();
                }
                String userName = synapseProperties.getProperty("synapse.http.proxy.user");
                String password = synapseProperties.getProperty("synapse.http.proxy.password");
                if (userName != null && password != null) {
                    String header = userName + ":" + password;
                    byte[] encodedHeaderBytes = new Base64().encode(header.getBytes());
                    String encodedHeader = new String(encodedHeaderBytes);
                    connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedHeader);
                }
            } else {
                connection = url.openConnection();
            }
            connection.setReadTimeout(SynapseConfigUtils.getReadTimeout());
            connection.setConnectTimeout(SynapseConfigUtils.getConnectTimeout());
            connection.setRequestProperty("Connection", "close");
            return connection;
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error reading at URI ' " + url + " ' ", e);
            return null;
        }
    }

    private static List<String> getExcludedHostsForProxy(Properties synapseProperties) {
        ArrayList<String> excludedHosts = new ArrayList<String>();
        String excludedHostsConfig = synapseProperties.getProperty("synapse.http.proxy.excluded.hosts");
        if (excludedHostsConfig != null) {
            String[] list;
            for (String host : list = excludedHostsConfig.split(",")) {
                excludedHosts.add(host.trim());
            }
        }
        return excludedHosts;
    }

    private static void handleException(String msg) {
        log.warn((Object)msg);
        throw new SynapseException(msg);
    }

    public static XMLToObjectMapper getXmlToObjectMapper(String contentType) {
        return null;
    }

    public static URL getURLFromPath(String path, String synapseHome) {
        URL url;
        block15: {
            if (path == null || "null".equals(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can not create a URL from 'null' ");
                }
                return null;
            }
            url = null;
            try {
                url = new URL(path);
                if (!"file".equals(url.getProtocol())) break block15;
                try {
                    url.openStream();
                }
                catch (MalformedURLException e) {
                    SynapseConfigUtils.handleException("Invalid URL reference : " + path, e);
                }
                catch (IOException ignored) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Can not open a connection to the URL with a path :" + path));
                    }
                    if (synapseHome == null) break block15;
                    if (synapseHome.endsWith("/")) {
                        synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Trying  to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                    }
                    try {
                        url = new URL(url.getProtocol() + ":" + synapseHome + "/" + url.getPath());
                        url.openStream();
                    }
                    catch (MalformedURLException e) {
                        SynapseConfigUtils.handleException("Invalid URL reference " + url.getPath() + e);
                    }
                    catch (IOException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                        }
                        log.warn((Object)("IO Error reading from URL : " + url.getPath() + e));
                    }
                }
            }
            catch (MalformedURLException e) {
                SynapseConfigUtils.handleException("Invalid URL reference :  " + path, e);
            }
            catch (IOException e) {
                SynapseConfigUtils.handleException("IO Error reading from URL : " + path, e);
            }
        }
        return url;
    }

    public static String resolveRelativeURI(String parentLocation, String relativeLocation) {
        if (relativeLocation == null) {
            throw new IllegalArgumentException("Import URI cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving import URI ' " + parentLocation + " '  " + "against base URI ' " + relativeLocation + " '  "));
        }
        URI importUri = null;
        try {
            importUri = new URI(relativeLocation);
            if (importUri.isAbsolute()) {
                return importUri.toString();
            }
        }
        catch (URISyntaxException e) {
            SynapseConfigUtils.handleException("Invalid URI : " + relativeLocation, e);
        }
        if (parentLocation == null) {
            assert (importUri != null);
            return importUri.toString();
        }
        if (relativeLocation.startsWith("/") || relativeLocation.startsWith("\\")) {
            if (importUri != null && !importUri.isAbsolute()) {
                try {
                    importUri = new URI("file:" + relativeLocation);
                    return importUri.toString();
                }
                catch (URISyntaxException e) {
                    SynapseConfigUtils.handleException("Invalid URI ' " + importUri.getPath() + " '", e);
                }
            }
        } else {
            int index = parentLocation.lastIndexOf("/");
            if (index == -1) {
                index = parentLocation.lastIndexOf("\\");
            }
            if (index != -1) {
                String basepath = parentLocation.substring(0, index + 1);
                String resolvedPath = basepath + relativeLocation;
                try {
                    URI resolvedUri = new URI(resolvedPath);
                    if (!resolvedUri.isAbsolute()) {
                        resolvedUri = new URI("file:" + resolvedPath);
                    }
                    return resolvedUri.toString();
                }
                catch (URISyntaxException e) {
                    SynapseConfigUtils.handleException("Invalid URI ' " + resolvedPath + " '", e);
                }
            } else {
                assert (importUri != null);
                return importUri.toString();
            }
        }
        return null;
    }

    public static int getConnectTimeout() {
        return Integer.parseInt(SynapsePropertiesLoader.getPropertyValue("synapse.connection.connect_timeout", String.valueOf(20000)));
    }

    public static int getReadTimeout() {
        return Integer.parseInt(SynapsePropertiesLoader.getPropertyValue("synapse.connection.read_timeout", String.valueOf(100000)));
    }

    public static long getTimeoutHandlerInterval() {
        return Long.parseLong(SynapsePropertiesLoader.getPropertyValue("synapse.timeout_handler_interval", String.valueOf(15000L)));
    }

    public static long getGlobalTimeoutInterval() {
        return Long.parseLong(SynapsePropertiesLoader.getPropertyValue("synapse.global_timeout_interval", String.valueOf(86400000L)));
    }

    public static SynapseEnvironment getSynapseEnvironment(AxisConfiguration axisCfg) {
        return axisCfg != null && axisCfg.getParameter("synapse.home") != null ? (SynapseEnvironment)axisCfg.getParameterValue("synapse.config") : null;
    }

    public static StatisticsCollector getStatisticsCollector(ServerContextInformation contextInfo) {
        ConfigurationContext context;
        SynapseEnvironment environment;
        Object o;
        if (contextInfo != null && contextInfo.getServerState() == ServerState.INITIALIZED && (o = contextInfo.getServerContext()) instanceof ConfigurationContext && (environment = (SynapseEnvironment)(context = (ConfigurationContext)o).getAxisConfiguration().getParameterValue("synapse.env")) != null) {
            return environment.getStatisticsCollector();
        }
        return null;
    }

    public static OMElement stringToOM(String xml) {
        try {
            return AXIOMUtil.stringToOM((String)xml);
        }
        catch (XMLStreamException e) {
            SynapseConfigUtils.handleException("Unable to convert a string to OM Node as the string is malformed , String : " + xml, e);
            return null;
        }
    }

    public static SynapseConfiguration newConfiguration() {
        SynapseConfiguration synConfig = new SynapseConfiguration();
        Properties synapseProps = SynapsePropertiesLoader.loadSynapseProperties();
        String propValue = synapseProps.getProperty("synapse.observers");
        if (propValue != null) {
            String[] observerNames;
            for (String observer : observerNames = propValue.split(",")) {
                try {
                    Class<?> clazz = SynapseConfigUtils.class.getClassLoader().loadClass(observer.trim());
                    SynapseObserver o = (SynapseObserver)clazz.newInstance();
                    synConfig.registerObserver(o);
                }
                catch (Exception e) {
                    SynapseConfigUtils.handleException("Error while initializing Synapse observers", e);
                }
            }
        }
        return synConfig;
    }

    public static void setDefaultMainSequence(SynapseConfiguration config) {
        SequenceMediator main = new SequenceMediator();
        main.setName("main");
        main.addChild(new LogMediator());
        main.addChild(new DropMediator());
        config.addSequence("main", main);
        AspectConfiguration configuration = new AspectConfiguration(main.getName());
        main.configure(configuration);
    }

    public static void setDefaultFaultSequence(SynapseConfiguration config) {
        SequenceMediator fault = new SequenceMediator();
        fault.setName("fault");
        LogMediator log = new LogMediator();
        log.setLogLevel(3);
        MediatorProperty mp = new MediatorProperty();
        mp.setName("MESSAGE");
        mp.setValue("Executing default \"fault\" sequence");
        log.addProperty(mp);
        mp = new MediatorProperty();
        mp.setName("ERROR_CODE");
        try {
            mp.setExpression(new SynapseXPath("get-property('ERROR_CODE')"));
        }
        catch (JaxenException ignore) {
            // empty catch block
        }
        log.addProperty(mp);
        mp = new MediatorProperty();
        mp.setName("ERROR_MESSAGE");
        try {
            mp.setExpression(new SynapseXPath("get-property('ERROR_MESSAGE')"));
        }
        catch (JaxenException ignore) {
            // empty catch block
        }
        log.addProperty(mp);
        fault.addChild(log);
        fault.addChild(new DropMediator());
        AspectConfiguration configuration = new AspectConfiguration(fault.getName());
        fault.configure(configuration);
        config.addSequence("fault", fault);
    }

    public static boolean isFailSafeEnabled(String componentName) {
        Properties synapseProps = SynapsePropertiesLoader.loadSynapseProperties();
        String failSafeStr = synapseProps.getProperty("failsafe.mode.enable");
        if (failSafeStr != null) {
            String[] failSafeComponents = failSafeStr.split(",");
            List<String> componentList = Arrays.asList(failSafeComponents);
            return componentList.indexOf("all") >= 0 || componentList.indexOf(componentName) >= 0;
        }
        return true;
    }
}

