/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerManager;
import org.apache.synapse.ServerManagerViewMBean;

public class ServerManagerView
implements ServerManagerViewMBean {
    private static final Log log = LogFactory.getLog(ServerManagerView.class);
    private final ServerManager serverManager;

    public ServerManagerView(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    public String getServerState() {
        return this.serverManager.getServerState().toString();
    }

    public void start() throws Exception {
        try {
            Thread.currentThread().setContextClassLoader(this.serverManager.getClassLoader());
            this.serverManager.start();
        }
        catch (Exception ex) {
            throw new Exception("Error performing a server start: " + ex.getMessage());
        }
    }

    public void stop() throws Exception {
        try {
            Thread.currentThread().setContextClassLoader(this.serverManager.getClassLoader());
            this.serverManager.stop();
        }
        catch (Exception ex) {
            throw new Exception("Error performing a server stop: " + ex.getMessage());
        }
    }

    public void restart() throws Exception {
        try {
            log.info((Object)"Re-starting Synapse ..");
            this.stop();
            this.start();
        }
        catch (Exception ex) {
            throw new Exception("Error performing restart: " + ex.getMessage());
        }
    }

    public void shutdown() throws Exception {
        try {
            Thread.currentThread().setContextClassLoader(this.serverManager.getClassLoader());
            this.serverManager.shutdown();
        }
        catch (Exception ex) {
            throw new Exception("Error performing shutdown: " + ex.getMessage());
        }
    }

    public void stopGracefully(long waitSeconds) throws Exception {
        try {
            Thread.currentThread().setContextClassLoader(this.serverManager.getClassLoader());
            this.serverManager.stopGracefully(waitSeconds * 1000L);
        }
        catch (Exception ex) {
            throw new Exception("Error performing graceful stop: " + ex.getMessage());
        }
    }

    public void startMaintenance() throws Exception {
        try {
            Thread.currentThread().setContextClassLoader(this.serverManager.getClassLoader());
            this.serverManager.startMaintenance();
        }
        catch (Exception ex) {
            throw new Exception("Error switching to maintenance mode: " + ex.getMessage());
        }
    }

    public void endMaintenance() throws Exception {
        try {
            Thread.currentThread().setContextClassLoader(this.serverManager.getClassLoader());
            this.serverManager.endMaintenance();
        }
        catch (Exception ex) {
            throw new Exception("Error switching back from maintenance mode: " + ex.getMessage());
        }
    }
}

