/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.experimental.mediators.seda;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueConsumer;

public class DefaultConsumer
implements SEDAQueueConsumer {
    private static final Executor EXECUTOR = Executors.newFixedThreadPool(10);
    private Mediator mediator;

    public DefaultConsumer(Mediator mediator) {
        this.mediator = mediator;
    }

    public void consume(MessageContext messageContext) {
        EXECUTOR.execute(new Worker(this.mediator, messageContext));
    }

    static class Worker
    implements Runnable {
        private final Mediator mediator;
        private final MessageContext messageContext;
        private volatile Exception exception;

        public Worker(Mediator mediator, MessageContext messageContext) {
            this.mediator = mediator;
            this.messageContext = messageContext;
        }

        public void run() {
            try {
                this.mediator.mediate(this.messageContext);
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

