/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.rahas.EncryptedKeyToken;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.ws.security.WSPasswordCallback;
import org.w3c.dom.Element;

public class TokenCallbackHandler
implements CallbackHandler {
    private TokenStorage store;
    private CallbackHandler handler;
    private String tokenIdentifier;

    public TokenCallbackHandler(TokenStorage store, CallbackHandler handler) {
        this.store = store;
        this.handler = handler;
        this.tokenIdentifier = null;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String id = pc.getIdentifer();
                if ((pc.getUsage() == 6 || pc.getUsage() == 7) && this.store != null) {
                    try {
                        Token tok = this.store.getToken(id);
                        if (tok == null) continue;
                        pc.setKey(tok.getSecret());
                        pc.setCustomToken((Element)tok.getToken());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
                if (pc.getUsage() == 8) {
                    try {
                        String[] tokenIdentifiers = this.store.getTokenIdentifiers();
                        for (int j = 0; j < tokenIdentifiers.length; ++j) {
                            Token tok = this.store.getToken(tokenIdentifiers[j]);
                            if (!(tok instanceof EncryptedKeyToken) || !((EncryptedKeyToken)tok).getSHA1().equals(id)) continue;
                            pc.setKey(tok.getSecret());
                            pc.setCustomToken((Element)tok.getToken());
                            this.tokenIdentifier = tokenIdentifiers[j];
                        }
                        continue;
                    }
                    catch (TrustException e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
                if (this.handler == null) continue;
                this.handler.handle(new Callback[]{pc});
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    public void removeEncryptedToken() {
        if (this.tokenIdentifier != null) {
            this.store.removeToken(this.tokenIdentifier);
        }
    }
}

