/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public final class Int64Value
extends IntegerValue {
    private long value;

    public Int64Value(long l) {
        this.value = l;
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    public Int64Value(long l, AtomicType atomicType, boolean bl) throws DynamicError {
        this.value = l;
        this.typeLabel = atomicType;
        if (bl && !Int64Value.checkRange(this.value, atomicType)) {
            DynamicError dynamicError = new DynamicError("Integer value " + l + " is out of range for the requested type " + atomicType.getDescription());
            dynamicError.setErrorCode("XPTY0004");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
    }

    public static Int64Value makeIntegerValue(long l) {
        if (l <= 20L && l >= 0L) {
            return SMALL_INTEGERS[(int)l];
        }
        return new Int64Value(l);
    }

    public static Int64Value makeDerived(long l, AtomicType atomicType) {
        Int64Value int64Value = new Int64Value(l);
        int64Value.typeLabel = atomicType;
        return int64Value;
    }

    public static Int64Value signum(long l) {
        if (l == 0L) {
            return IntegerValue.ZERO;
        }
        return l < 0L ? IntegerValue.MINUS_ONE : IntegerValue.PLUS_ONE;
    }

    public AtomicValue copy(AtomicType atomicType) {
        Int64Value int64Value = new Int64Value(this.value);
        int64Value.typeLabel = atomicType;
        return int64Value;
    }

    public ValidationException convertToSubType(AtomicType atomicType, boolean bl) {
        if (!bl) {
            this.setSubType(atomicType);
            return null;
        }
        if (this.checkRange(atomicType)) {
            return null;
        }
        ValidationException validationException = new ValidationException("String " + this.value + " cannot be converted to integer subtype " + atomicType.getDescription());
        validationException.setErrorCode("FORG0001");
        return validationException;
    }

    public void setSubType(AtomicType atomicType) {
        this.typeLabel = atomicType;
    }

    public boolean checkRange(AtomicType atomicType) {
        this.typeLabel = atomicType;
        return Int64Value.checkRange(this.value, atomicType);
    }

    public int hashCode() {
        if (this.value > Integer.MIN_VALUE && this.value < Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public long longValue() {
        return this.value;
    }

    public boolean effectiveBooleanValue() {
        return this.value != 0L;
    }

    public int compareTo(Object object) {
        if (object instanceof Int64Value) {
            long l = ((Int64Value)object).value;
            if (this.value == l) {
                return 0;
            }
            if (this.value < l) {
                return -1;
            }
            return 1;
        }
        if (object instanceof BigIntegerValue) {
            return new BigIntegerValue(this.value).compareTo(object);
        }
        return super.compareTo(object);
    }

    public int compareTo(long l) {
        if (this.value == l) {
            return 0;
        }
        if (this.value < l) {
            return -1;
        }
        return 1;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.value != 0L);
            }
            case 88: 
            case 532: 
            case 632: 
            case 635: {
                return this;
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                Int64Value int64Value = new Int64Value(this.value);
                ValidationException validationException = int64Value.convertToSubType(builtInAtomicType, bl);
                if (validationException != null) {
                    return new ValidationErrorValue(validationException);
                }
                return int64Value;
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 516: {
                return new FloatValue(this.value);
            }
            case 515: {
                return new DecimalValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert integer to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return Long.toString(this.value);
    }

    public double getDoubleValue() {
        return this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public BigDecimal getDecimalValue() {
        return new BigDecimal(this.value);
    }

    public NumericValue negate() {
        return new Int64Value(-this.value);
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundHalfToEven(int n) {
        long l;
        long l2 = Math.abs(this.value);
        if (n >= 0) {
            return this;
        }
        if (n < -15) {
            return new BigIntegerValue(this.value).roundHalfToEven(n);
        }
        long l3 = 1L;
        for (l = 1L; l <= (long)(-n); ++l) {
            l3 *= 10L;
        }
        l = l2 % l3;
        long l4 = l2 - l;
        long l5 = l * 2L;
        if (l5 > l3) {
            l4 += l3;
        } else if (l5 >= l3 && l4 % (2L * l3) != 0L) {
            l4 += l3;
        }
        if (this.value < 0L) {
            l4 = -l4;
        }
        return new Int64Value(l4);
    }

    public double signum() {
        if (this.value > 0L) {
            return 1.0;
        }
        if (this.value == 0L) {
            return 0.0;
        }
        return -1.0;
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof Int64Value) {
            if (this.value >= Integer.MAX_VALUE || this.value <= Integer.MIN_VALUE || ((Int64Value)numericValue).value >= Integer.MAX_VALUE || ((Int64Value)numericValue).value <= Integer.MIN_VALUE) {
                return new BigIntegerValue(this.value).arithmetic(n, numericValue, xPathContext);
            }
            switch (n) {
                case 15: {
                    return Int64Value.makeIntegerValue(this.value + ((Int64Value)numericValue).value);
                }
                case 16: {
                    return Int64Value.makeIntegerValue(this.value - ((Int64Value)numericValue).value);
                }
                case 17: {
                    return Int64Value.makeIntegerValue(this.value * ((Int64Value)numericValue).value);
                }
                case 50: {
                    try {
                        return Int64Value.makeIntegerValue(this.value / ((Int64Value)numericValue).value);
                    }
                    catch (ArithmeticException arithmeticException) {
                        DynamicError dynamicError;
                        if ("/ by zero".equals(arithmeticException.getMessage())) {
                            dynamicError = new DynamicError("Integer division by zero");
                            dynamicError.setErrorCode("FOAR0001");
                        } else {
                            dynamicError = new DynamicError("Integer division failure", arithmeticException);
                        }
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                }
                case 18: {
                    long l = ((Int64Value)numericValue).value;
                    if (l == 0L) {
                        DynamicError dynamicError = new DynamicError("Integer division by zero");
                        dynamicError.setXPathContext(xPathContext);
                        dynamicError.setErrorCode("FOAR0001");
                        throw dynamicError;
                    }
                    if (this.value % l == 0L) {
                        return Int64Value.makeIntegerValue(this.value / l);
                    }
                    return new DecimalValue(this.value).arithmetic(18, new DecimalValue(l), xPathContext);
                }
                case 19: {
                    return Int64Value.makeIntegerValue(this.value % ((Int64Value)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof BigIntegerValue) {
            return new BigIntegerValue(this.value).arithmetic(n, numericValue, xPathContext);
        }
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getPrimitiveType(), xPathContext);
        return numericValue2.arithmetic(n, numericValue, xPathContext);
    }

    public IntegerValue plus(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            long l = this.value >> 60 & 0xFL;
            if (l != 0L && l != 15L) {
                return new BigIntegerValue(this.value).plus(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            long l2 = ((Int64Value)integerValue).value >> 60 & 0xFL;
            if (l2 != 0L && l2 != 15L) {
                return new BigIntegerValue(this.value).plus(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            return Int64Value.makeIntegerValue(this.value + ((Int64Value)integerValue).value);
        }
        return new BigIntegerValue(this.value).plus(integerValue);
    }

    public IntegerValue minus(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            long l = this.value >> 60 & 0xFL;
            if (l != 0L && l != 15L) {
                return new BigIntegerValue(this.value).minus(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            long l2 = ((Int64Value)integerValue).value >> 60 & 0xFL;
            if (l2 != 0L && l2 != 15L) {
                return new BigIntegerValue(this.value).minus(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            return Int64Value.makeIntegerValue(this.value - ((Int64Value)integerValue).value);
        }
        return new BigIntegerValue(this.value).minus(integerValue);
    }

    public IntegerValue times(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            long l = this.value >> 32 & 0xFFFFFFFFFFFFFFFFL;
            if (l != 0L && l != -1L) {
                return new BigIntegerValue(this.value).times(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            long l2 = ((Int64Value)integerValue).value >> 32 & 0xFFFFFFFFFFFFFFFFL;
            if (l2 != 0L && l2 != -1L) {
                return new BigIntegerValue(this.value).times(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            return Int64Value.makeIntegerValue(this.value * ((Int64Value)integerValue).value);
        }
        return new BigIntegerValue(this.value).times(integerValue);
    }

    public NumericValue div(IntegerValue integerValue) throws XPathException {
        if (integerValue instanceof Int64Value) {
            long l = this.value >> 32 & 0xFFFFFFFFFFFFFFFFL;
            if (l != 0L && l != -1L) {
                return new BigIntegerValue(this.value).div(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            long l2 = ((Int64Value)integerValue).value >> 32 & 0xFFFFFFFFFFFFFFFFL;
            if (l2 != 0L && l2 != -1L) {
                return new BigIntegerValue(this.value).div(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            long l3 = ((Int64Value)integerValue).value;
            if (l3 == 0L) {
                throw new DynamicError("Integer division by zero", "FOAR0001");
            }
            if (this.value % l3 == 0L) {
                return Int64Value.makeIntegerValue(this.value / l3);
            }
            return (NumericValue)Calculator.DECIMAL_DECIMAL[3].compute(new DecimalValue(this.value), new DecimalValue(l3), null);
        }
        return new BigIntegerValue(this.value).div(integerValue);
    }

    public IntegerValue mod(IntegerValue integerValue) throws XPathException {
        if (integerValue instanceof Int64Value) {
            long l = this.value >> 32 & 0xFFFFFFFFFFFFFFFFL;
            if (l != 0L && l != -1L) {
                return new BigIntegerValue(this.value).mod(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            long l2 = ((Int64Value)integerValue).value >> 32 & 0xFFFFFFFFFFFFFFFFL;
            if (l2 != 0L && l2 != -1L) {
                return new BigIntegerValue(this.value).mod(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            return Int64Value.makeIntegerValue(this.value % ((Int64Value)integerValue).value);
        }
        return new BigIntegerValue(this.value).mod(integerValue);
    }

    public IntegerValue idiv(IntegerValue integerValue) throws XPathException {
        if (integerValue instanceof Int64Value) {
            long l = this.value >> 32 & 0xFFFFFFFFFFFFFFFFL;
            if (l != 0L && l != -1L) {
                return new BigIntegerValue(this.value).idiv(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            long l2 = ((Int64Value)integerValue).value >> 32 & 0xFFFFFFFFFFFFFFFFL;
            if (l2 != 0L && l2 != -1L) {
                return new BigIntegerValue(this.value).idiv(new BigIntegerValue(((Int64Value)integerValue).value));
            }
            try {
                return Int64Value.makeIntegerValue(this.value / ((Int64Value)integerValue).value);
            }
            catch (ArithmeticException arithmeticException) {
                DynamicError dynamicError = "/ by zero".equals(arithmeticException.getMessage()) ? new DynamicError("Integer division by zero", "FOAR0001") : new DynamicError("Integer division failure", arithmeticException);
                throw dynamicError;
            }
        }
        return new BigIntegerValue(this.value).times(integerValue);
    }

    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == Object.class) {
            return new Long(this.value);
        }
        if (clazz.isAssignableFrom(Int64Value.class)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(BuiltInAtomicType.BOOLEAN, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == Boolean.class) {
            BooleanValue booleanValue = (BooleanValue)this.convert(BuiltInAtomicType.BOOLEAN, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new Long(this.value);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return new Character((char)this.value);
        }
        if (clazz == BigInteger.class) {
            return BigInteger.valueOf(this.value);
        }
        if (clazz == BigDecimal.class) {
            return BigDecimal.valueOf(this.value);
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of integer to " + clazz.getName() + " is not supported");
        }
        return object;
    }
}

