/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.JMException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.synapse.transport.fix.FIXApplicationFactory;
import org.apache.synapse.transport.fix.FIXIncomingMessageHandler;
import org.apache.synapse.transport.fix.FIXUtils;
import org.quickfixj.jmx.JmxExporter;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.FieldConvertError;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.Initiator;
import quickfix.JdbcLogFactory;
import quickfix.JdbcStoreFactory;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.SLF4JLogFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SleepycatStoreFactory;
import quickfix.SocketAcceptor;
import quickfix.SocketInitiator;

public class FIXSessionFactory {
    private Map<String, Acceptor> acceptorStore;
    private Map<String, Initiator> initiatorStore;
    private Map<String, Application> applicationStore;
    private static FIXApplicationFactory applicationFactory = null;
    private WorkerPool listenerThreadPool = null;
    private WorkerPool senderThreadPool = null;
    private Log log = org.apache.commons.logging.LogFactory.getLog(this.getClass());
    private static FIXSessionFactory INSTANCE = new FIXSessionFactory();

    public static FIXSessionFactory getInstance(FIXApplicationFactory af) {
        if (applicationFactory == null) {
            applicationFactory = af;
        }
        return INSTANCE;
    }

    private FIXSessionFactory() {
        this.acceptorStore = new HashMap<String, Acceptor>();
        this.initiatorStore = new HashMap<String, Initiator>();
        this.applicationStore = new HashMap<String, Application>();
    }

    public boolean createFIXAcceptor(AxisService service) throws AxisFault {
        InputStream fixConfigStream = this.getFIXConfigAsStream(service, true);
        if (fixConfigStream != null) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Initializing a new FIX session for the service " + service.getName()));
                }
                SessionSettings settings = new SessionSettings(fixConfigStream);
                MessageStoreFactory storeFactory = this.getMessageStoreFactory(service, settings, true);
                DefaultMessageFactory messageFactory = new DefaultMessageFactory();
                LogFactory logFactory = this.getLogFactory(service, settings, true);
                Application messageHandler = applicationFactory.getFIXApplication(service, this.listenerThreadPool, true);
                SocketAcceptor acceptor = new SocketAcceptor(messageHandler, storeFactory, settings, logFactory, (MessageFactory)messageFactory);
                acceptor.start();
                this.initJMX((Connector)acceptor, service.getName());
                this.acceptorStore.put(service.getName(), (Acceptor)acceptor);
                return true;
            }
            catch (ConfigError e) {
                String msg = "Error in the specified FIX configuration. Unable to initialize a FIX session for the service " + service.getName();
                this.log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        return false;
    }

    public void createFIXInitiator(String fixEPR, AxisService service, SessionID sessionID) throws AxisFault {
        SessionSettings settings;
        InputStream fixConfigStream;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing a new FIX initiator for the service " + service.getName()));
        }
        if ((fixConfigStream = this.getFIXConfigAsStream(service, false)) == null) {
            settings = new SessionSettings();
            settings.setLong(sessionID, "HeartBtInt", 30L);
            settings.setString(sessionID, "StartTime", "00:00:00");
            settings.setString(sessionID, "EndTime", "00:00:00");
        } else {
            try {
                settings = new SessionSettings(fixConfigStream);
            }
            catch (ConfigError e) {
                throw new AxisFault("Error in the specified FIX configuration for the initiator. Unable to initialize a FIX session for the service " + service.getName(), (Throwable)e);
            }
        }
        Hashtable properties = BaseUtils.getEPRProperties((String)fixEPR);
        for (Map.Entry entry : properties.entrySet()) {
            settings.setString(sessionID, (String)entry.getKey(), (String)entry.getValue());
        }
        String[] socketAddressElements = FIXUtils.getSocketAddressElements(fixEPR);
        settings.setString(sessionID, "ConnectionType", "initiator");
        settings.setString(sessionID, "SocketConnectHost", socketAddressElements[0]);
        settings.setString(sessionID, "SocketConnectPort", socketAddressElements[1]);
        LogFactory logFactory = this.getLogFactory(service, settings, false);
        MessageStoreFactory storeFactory = this.getMessageStoreFactory(service, settings, false);
        DefaultMessageFactory messageFactory = new DefaultMessageFactory();
        Application messageHandler = applicationFactory.getFIXApplication(service, this.senderThreadPool, false);
        try {
            SocketInitiator initiator = new SocketInitiator(messageHandler, storeFactory, settings, logFactory, (MessageFactory)messageFactory);
            initiator.start();
            this.initJMX((Connector)initiator, service.getName());
            this.initiatorStore.put(fixEPR, (Initiator)initiator);
            this.applicationStore.put(fixEPR, messageHandler);
            FIXIncomingMessageHandler fixMessageHandler = (FIXIncomingMessageHandler)messageHandler;
            this.log.info((Object)"Waiting for logon procedure to complete...");
            fixMessageHandler.acquire();
        }
        catch (ConfigError e) {
            throw new AxisFault("Error in the specified FIX configuration for the initiator. Unable to initialize a FIX initiator.", (Throwable)e);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    public boolean createFIXInitiator(AxisService service) throws AxisFault {
        InputStream fixConfigStream = this.getFIXConfigAsStream(service, false);
        if (fixConfigStream != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to initialize a new FIX initiator for the service " + service.getName()));
            }
            try {
                String[] EPRs;
                SessionSettings settings = new SessionSettings(fixConfigStream);
                MessageStoreFactory storeFactory = this.getMessageStoreFactory(service, settings, false);
                DefaultMessageFactory messageFactory = new DefaultMessageFactory();
                LogFactory logFactory = this.getLogFactory(service, settings, false);
                Application messageHandler = applicationFactory.getFIXApplication(service, this.senderThreadPool, false);
                SocketInitiator initiator = new SocketInitiator(messageHandler, storeFactory, settings, logFactory, (MessageFactory)messageFactory);
                initiator.start();
                this.initJMX((Connector)initiator, service.getName());
                for (String EPR : EPRs = FIXUtils.getEPRs(settings)) {
                    this.initiatorStore.put(EPR, (Initiator)initiator);
                    this.applicationStore.put(EPR, messageHandler);
                }
                return true;
            }
            catch (FieldConvertError e) {
                String msg = "FIX configuration file for the initiator session of the service " + service.getName() + " is either incomplete or invalid." + " Not creating the initiator session at this stage.";
                this.log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
            catch (ConfigError e) {
                String msg = "FIX configuration file for the initiator session of the service " + service.getName() + " is either incomplete or invalid." + " Not creating the initiator session at this stage.";
                this.log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        this.log.info((Object)"The transport.fix.InitiatorConfigURL parameter is not specified. Unable to initialize the initiator session at this stage.");
        return false;
    }

    public void disposeFIXAcceptor(AxisService service) {
        Acceptor acceptor;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping the FIX acceptor for the service " + service.getName()));
        }
        if ((acceptor = this.acceptorStore.get(service.getName())) != null) {
            acceptor.stop();
            this.log.info((Object)("FIX session for service " + service.getName() + " terminated..."));
            this.acceptorStore.remove(service.getName());
        }
    }

    public void disposeFIXInitiators() {
        boolean debugEnabled = this.log.isDebugEnabled();
        for (String key : this.initiatorStore.keySet()) {
            this.initiatorStore.get(key).stop();
            if (!debugEnabled) continue;
            this.log.debug((Object)("FIX initiator to the EPR " + key + " stopped"));
        }
        this.initiatorStore.clear();
        this.applicationStore.clear();
    }

    public String[] getServiceEPRs(String serviceName, String ip) {
        SocketAcceptor acceptor;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting EPRs for the service " + serviceName));
        }
        if ((acceptor = (SocketAcceptor)this.acceptorStore.get(serviceName)) != null) {
            return FIXUtils.generateEPRs(acceptor, serviceName, ip);
        }
        return new String[0];
    }

    public Acceptor getAcceptor(String serviceName) {
        return this.acceptorStore.get(serviceName);
    }

    public Initiator getInitiator(String fixEPR) {
        return this.initiatorStore.get(fixEPR);
    }

    private InputStream getFIXConfigAsStream(AxisService service, boolean acceptor) {
        InputStream fixConfigStream = null;
        Parameter fixConfigURLParam = acceptor ? service.getParameter("transport.fix.AcceptorConfigURL") : service.getParameter("transport.fix.InitiatorConfigURL");
        if (fixConfigURLParam != null) {
            String fixConfigURLValue = fixConfigURLParam.getValue().toString();
            try {
                URL url = new URL(fixConfigURLValue);
                fixConfigStream = url.openStream();
            }
            catch (MalformedURLException e) {
                this.log.error((Object)("The FIX configuration URL " + fixConfigURLValue + " is" + " malformed."), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)("Error while reading from the URL " + fixConfigURLValue), (Throwable)e);
            }
        } else {
            this.log.info((Object)("FIX configuration URL is not specified for the service " + service.getName()));
        }
        return fixConfigStream;
    }

    private LogFactory getLogFactory(AxisService service, SessionSettings settings, boolean acceptor) {
        FileLogFactory logFactory = null;
        Parameter fixLogMethod = acceptor ? service.getParameter("transport.fix.AcceptorLogFactory") : service.getParameter("transport.fix.InitiatorLogFactory");
        if (fixLogMethod != null) {
            String method = fixLogMethod.getValue().toString();
            this.log.info((Object)("FIX logging method = " + method));
            if ("file".equals(method)) {
                logFactory = new FileLogFactory(settings);
            } else if ("jdbc".equals(method)) {
                logFactory = new JdbcLogFactory(settings);
            } else if ("console".equals(method)) {
                logFactory = new ScreenLogFactory();
            } else if ("slf4j".equals(method)) {
                logFactory = new SLF4JLogFactory(settings);
            } else {
                this.log.warn((Object)("Invalid acceptor log method " + method + ". Using defaults."));
            }
        }
        return logFactory;
    }

    private MessageStoreFactory getMessageStoreFactory(AxisService service, SessionSettings settings, boolean acceptor) {
        MemoryStoreFactory storeFactory = new MemoryStoreFactory();
        Parameter msgLogMethod = acceptor ? service.getParameter("transport.fix.AcceptorMessageStore") : service.getParameter("transport.fix.InitiatorMessageStore");
        if (msgLogMethod != null) {
            String method = msgLogMethod.getValue().toString();
            this.log.info((Object)("FIX message logging method = " + method));
            if ("jdbc".equals(method)) {
                storeFactory = new JdbcStoreFactory(settings);
            } else if ("sleepycat".equals(method)) {
                storeFactory = new SleepycatStoreFactory(settings);
            } else if ("file".equals(method)) {
                storeFactory = new FileStoreFactory(settings);
            } else if (!"memory".equals(method)) {
                this.log.warn((Object)("Invalid message store " + method + ". Using defaults."));
            }
        }
        return storeFactory;
    }

    public Application getApplication(String fixEPR) {
        Application app = this.applicationStore.get(fixEPR);
        if (app == null) {
            for (String epr : this.applicationStore.keySet()) {
                if (!FIXUtils.compareURLs(epr, fixEPR)) continue;
                app = this.applicationStore.get(epr);
                this.applicationStore.remove(epr);
                this.applicationStore.put(fixEPR, app);
                break;
            }
        }
        return app;
    }

    public void setListenerThreadPool(WorkerPool listenerThreadPool) {
        this.listenerThreadPool = listenerThreadPool;
    }

    public void setSenderThreadPool(WorkerPool senderThreadPool) {
        this.senderThreadPool = senderThreadPool;
    }

    private void initJMX(Connector connector, String service) {
        try {
            JmxExporter jmxExporter = new JmxExporter();
            jmxExporter.setRegistrationBehavior(1);
            jmxExporter.export(connector);
        }
        catch (JMException e) {
            this.log.error((Object)("Error while initializing JMX support for the service: " + service), (Throwable)e);
        }
    }
}

