/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.util.AbstractFactory;
import groovy.util.Factory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class FactoryBuilderSupport
extends GroovyObjectSupport {
    public static final String CURRENT_FACTORY = "_CURRENT_FACTORY_";
    public static final String PARENT_FACTORY = "_PARENT_FACTORY_";
    public static final String CURRENT_NODE = "_CURRENT_NODE_";
    private static final Logger LOG = Logger.getLogger(FactoryBuilderSupport.class.getName());
    private LinkedList contexts = new LinkedList();
    private LinkedList attributeDelegates = new LinkedList();
    private Map factories = new HashMap();
    private Closure nameMappingClosure;
    private FactoryBuilderSupport proxyBuilder;

    public static void checkValueIsNull(Object value, Object name) {
        if (value != null) {
            throw new RuntimeException("'" + name + "' elements do not accept a value argument.");
        }
    }

    public static boolean checkValueIsType(Object value, Object name, Class type) {
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return true;
            }
            throw new RuntimeException("The value argument of '" + name + "' must be of type " + type.getName());
        }
        return false;
    }

    public static boolean checkValueIsTypeNotString(Object value, Object name, Class type) {
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return true;
            }
            if (value instanceof String) {
                return false;
            }
            throw new RuntimeException("The value argument of '" + name + "' must be of type " + type.getName() + " or a String.");
        }
        return false;
    }

    public FactoryBuilderSupport() {
        this.proxyBuilder = this;
    }

    public FactoryBuilderSupport(Closure nameMappingClosure) {
        this.nameMappingClosure = nameMappingClosure;
        this.proxyBuilder = this;
    }

    public Map getFactories() {
        return Collections.unmodifiableMap(this.factories);
    }

    public Map getContext() {
        if (!this.contexts.isEmpty()) {
            return (Map)this.contexts.getFirst();
        }
        return null;
    }

    public Object getCurrent() {
        if (!this.contexts.isEmpty()) {
            Map context = (Map)this.contexts.getFirst();
            return context.get(CURRENT_NODE);
        }
        return null;
    }

    public Factory getCurrentFactory() {
        if (!this.contexts.isEmpty()) {
            Map context = (Map)this.contexts.getFirst();
            return (Factory)context.get(CURRENT_FACTORY);
        }
        return null;
    }

    public Factory getParentFactory() {
        if (!this.contexts.isEmpty()) {
            Map context = (Map)this.contexts.getFirst();
            return (Factory)context.get(PARENT_FACTORY);
        }
        return null;
    }

    public Object invokeMethod(String methodName) {
        return this.invokeMethod(methodName, null);
    }

    public Object invokeMethod(String methodName, Object args) {
        Object name = this.getName(methodName);
        Object result = null;
        try {
            result = this.doInvokeMethod(methodName, name, args);
        }
        catch (RuntimeException e) {
            this.reset();
            throw e;
        }
        return result;
    }

    public void addAttributeDelegate(Closure attrDelegate) {
        this.attributeDelegates.addFirst(attrDelegate);
    }

    public void removeAttributeDelegat(Closure attrDelegate) {
        this.attributeDelegates.remove(attrDelegate);
    }

    public void registerBeanFactory(String theName, final Class beanClass) {
        this.registerFactory(theName, new AbstractFactory(){

            public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
                if (FactoryBuilderSupport.checkValueIsTypeNotString(value, name, beanClass)) {
                    return value;
                }
                return beanClass.newInstance();
            }
        });
    }

    public void registerFactory(String name, Factory factory) {
        this.factories.put(name, factory);
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Object node = null;
        Factory factory = (Factory)this.factories.get(name);
        if (factory == null) {
            LOG.log(Level.WARNING, "Could not find match for name '" + name + "'");
            return null;
        }
        this.getContext().put(CURRENT_FACTORY, factory);
        this.preInstantiate(name, attributes, value);
        try {
            node = factory.newInstance(this, name, value, attributes);
            if (node == null) {
                LOG.log(Level.WARNING, "Factory for name '" + name + "' returned null");
                return null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("For name: " + name + " created node: " + node);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create component for '" + name + "' reason: " + e, e);
        }
        this.postInstantiate(name, attributes, node);
        this.handleNodeAttributes(node, attributes);
        return node;
    }

    protected Object doInvokeMethod(String methodName, Object name, Object args) {
        Object node = null;
        Closure closure = null;
        List list = InvokerHelper.asList(args);
        if (this.contexts.isEmpty()) {
            this.newContext();
        }
        switch (list.size()) {
            case 0: {
                node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, null);
                break;
            }
            case 1: {
                Object object = list.get(0);
                if (object instanceof Map) {
                    node = this.proxyBuilder.createNode(name, (Map)object, null);
                    break;
                }
                if (object instanceof Closure) {
                    closure = (Closure)object;
                    node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, null);
                    break;
                }
                node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, object);
                break;
            }
            case 2: {
                Object object1 = list.get(0);
                Object object2 = list.get(1);
                if (object1 instanceof Map) {
                    if (object2 instanceof Closure) {
                        closure = (Closure)object2;
                        node = this.proxyBuilder.createNode(name, (Map)object1, null);
                        break;
                    }
                    node = this.proxyBuilder.createNode(name, (Map)object1, object2);
                    break;
                }
                if (object2 instanceof Closure) {
                    closure = (Closure)object2;
                    node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, object1);
                    break;
                }
                if (object2 instanceof Map) {
                    node = this.proxyBuilder.createNode(name, (Map)object2, object1);
                    break;
                }
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
            case 3: {
                Object arg0 = list.get(0);
                Object arg1 = list.get(1);
                Object arg2 = list.get(2);
                if (arg0 instanceof Map && arg2 instanceof Closure) {
                    closure = (Closure)arg2;
                    node = this.proxyBuilder.createNode(name, (Map)arg0, arg1);
                    break;
                }
                if (arg1 instanceof Map && arg2 instanceof Closure) {
                    closure = (Closure)arg2;
                    node = this.proxyBuilder.createNode(name, (Map)arg1, arg0);
                    break;
                }
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
            default: {
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
        }
        if (node == null) {
            if (this.contexts.size() == 1) {
                this.popContext();
            }
            return node;
        }
        Object current = this.getCurrent();
        if (current != null) {
            this.proxyBuilder.setParent(current, node);
        }
        if (closure != null) {
            if (this.getCurrentFactory().isLeaf()) {
                throw new RuntimeException("'" + name + "' doesn't support nesting.");
            }
            Factory parentFactory = this.getCurrentFactory();
            this.newContext();
            this.getContext().put(CURRENT_NODE, node);
            this.getContext().put(PARENT_FACTORY, parentFactory);
            this.setClosureDelegate(closure, node);
            closure.call();
            this.popContext();
        }
        this.proxyBuilder.nodeCompleted(current, node);
        if (this.contexts.size() == 1) {
            this.popContext();
        }
        return this.proxyBuilder.postNodeCompletion(current, node);
    }

    protected Object getName(String methodName) {
        if (this.nameMappingClosure != null) {
            return this.nameMappingClosure.call(methodName);
        }
        return methodName;
    }

    protected FactoryBuilderSupport getProxyBuilder() {
        return this.proxyBuilder;
    }

    protected void handleNodeAttributes(Object node, Map attributes) {
        if (node == null) {
            return;
        }
        Iterator iter = this.attributeDelegates.iterator();
        while (iter.hasNext()) {
            ((Closure)iter.next()).call(new Object[]{this, node, attributes});
        }
        if (this.getCurrentFactory().onHandleNodeAttributes(this, node, attributes)) {
            this.setNodeAttributes(node, attributes);
        }
    }

    protected void newContext() {
        this.contexts.addFirst(new HashMap());
    }

    protected void nodeCompleted(Object parent, Object node) {
        this.getCurrentFactory().onNodeCompleted(this, parent, node);
    }

    protected Map popContext() {
        return (Map)this.contexts.removeFirst();
    }

    protected void postInstantiate(Object name, Map attributes, Object node) {
    }

    protected Object postNodeCompletion(Object parent, Object node) {
        return node;
    }

    protected void preInstantiate(Object name, Map attributes, Object value) {
    }

    protected void reset() {
        this.contexts.clear();
    }

    protected void setClosureDelegate(Closure closure, Object node) {
        closure.setDelegate(this);
    }

    protected void setNodeAttributes(Object node, Map attributes) {
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String property = entry.getKey().toString();
            Object value = entry.getValue();
            InvokerHelper.setProperty(node, property, value);
        }
    }

    protected void setParent(Object parent, Object child) {
        this.getCurrentFactory().setParent(this, parent, child);
        Factory parentFactory = this.getParentFactory();
        if (parentFactory != null) {
            parentFactory.setChild(this, parent, child);
        }
    }

    protected void setProxyBuilder(FactoryBuilderSupport proxyBuilder) {
        this.proxyBuilder = proxyBuilder;
    }
}

