/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.text.ParseException;
import java.util.Date;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskTriggerFactory;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class DefaultTaskTriggerFactory
implements TaskTriggerFactory {
    private static final Log log = LogFactory.getLog(DefaultTaskTriggerFactory.class);
    private static final Random RANDOM = new Random();

    public Trigger createTrigger(TaskDescription taskDescription) {
        Trigger trigger;
        String name = taskDescription.getName();
        if (name == null || "".equals(name)) {
            throw new SynapseTaskException("Name of the Task cannot be null", log);
        }
        String cron = taskDescription.getCron();
        int repeatCount = taskDescription.getCount();
        long repeatInterval = taskDescription.getInterval();
        Date startTime = taskDescription.getStartTime();
        Date endTime = taskDescription.getEndTime();
        if (cron == null || "".equals(cron)) {
            trigger = repeatCount >= 0 ? TriggerUtils.makeImmediateTrigger((int)(repeatCount - 1), (long)repeatInterval) : TriggerUtils.makeImmediateTrigger((int)SimpleTrigger.REPEAT_INDEFINITELY, (long)repeatInterval);
        } else {
            CronTrigger cronTrigger = new CronTrigger();
            try {
                cronTrigger.setCronExpression(cron);
                trigger = cronTrigger;
            }
            catch (ParseException e) {
                throw new SynapseTaskException("Error setting cron expression : " + e.getMessage() + cron, log);
            }
        }
        if (trigger == null) {
            throw new SynapseTaskException("Trigger is null for the Task description : " + taskDescription, log);
        }
        if (startTime != null) {
            trigger.setStartTime(startTime);
        }
        if (endTime != null) {
            trigger.setEndTime(endTime);
        }
        trigger.setName(name + "-trigger-" + String.valueOf(RANDOM.nextLong()));
        String group = taskDescription.getGroup();
        if (group != null && !"".equals(group)) {
            trigger.setGroup(group);
        } else {
            trigger.setGroup("synapse.simple.quartz");
        }
        trigger.setVolatility(taskDescription.isVolatility());
        return trigger;
    }
}

