/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class TemporaryData {
    private static final Log log = LogFactory.getLog(TemporaryData.class);
    final int chunkSize;
    final String tempPrefix;
    final String tempSuffix;
    byte[][] chunks;
    int chunkIndex;
    int chunkOffset;
    File temporaryFile;

    public TemporaryData(int numberOfChunks, int chunkSize, String tempPrefix, String tempSuffix) {
        this.chunkSize = chunkSize;
        this.tempPrefix = tempPrefix;
        this.tempSuffix = tempSuffix;
        this.chunks = new byte[numberOfChunks][];
    }

    byte[] getCurrentChunk() {
        if (this.chunkOffset == 0) {
            byte[] chunk = new byte[this.chunkSize];
            this.chunks[this.chunkIndex] = chunk;
            return chunk;
        }
        return this.chunks[this.chunkIndex];
    }

    FileOutputStream switchToTempFile() throws IOException {
        this.temporaryFile = File.createTempFile(this.tempPrefix, this.tempSuffix);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using temporary file " + this.temporaryFile));
        }
        this.temporaryFile.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(this.temporaryFile);
        for (int i = 0; i < this.chunkIndex; ++i) {
            fileOutputStream.write(this.chunks[i]);
        }
        if (this.chunkOffset > 0) {
            fileOutputStream.write(this.chunks[this.chunkIndex], 0, this.chunkOffset);
        }
        this.chunks = null;
        return fileOutputStream;
    }

    public OutputStream getOutputStream() {
        return new OutputStreamImpl();
    }

    public void readFrom(InputStream in) throws IOException {
        int c;
        while ((c = in.read(this.getCurrentChunk(), this.chunkOffset, this.chunkSize - this.chunkOffset)) != -1) {
            this.chunkOffset += c;
            if (this.chunkOffset != this.chunkSize) continue;
            ++this.chunkIndex;
            this.chunkOffset = 0;
            if (this.chunkIndex != this.chunks.length) continue;
            FileOutputStream fileOutputStream = this.switchToTempFile();
            IOUtils.copy((InputStream)in, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            break;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.temporaryFile != null) {
            return new FileInputStream(this.temporaryFile);
        }
        return new InputStreamImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        if (this.temporaryFile != null) {
            FileInputStream in = new FileInputStream(this.temporaryFile);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                in.close();
            }
        } else {
            for (int i = 0; i < this.chunkIndex; ++i) {
                out.write(this.chunks[i]);
            }
            if (this.chunkOffset > 0) {
                out.write(this.chunks[this.chunkIndex], 0, this.chunkOffset);
            }
        }
    }

    public long getLength() {
        if (this.temporaryFile != null) {
            return this.temporaryFile.length();
        }
        return this.chunkIndex * this.chunkSize + this.chunkOffset;
    }

    public void release() {
        if (this.temporaryFile != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting temporary file " + this.temporaryFile));
            }
            FileUtils.deleteQuietly((File)this.temporaryFile);
        }
    }

    protected void finalize() throws Throwable {
        if (this.temporaryFile != null) {
            log.warn((Object)("Cleaning up unreleased temporary file " + this.temporaryFile));
            FileUtils.deleteQuietly((File)this.temporaryFile);
        }
    }

    class InputStreamImpl
    extends InputStream {
        private int currentChunkIndex;
        private int currentChunkOffset;
        private int markChunkIndex;
        private int markChunkOffset;

        InputStreamImpl() {
        }

        public int available() throws IOException {
            return (TemporaryData.this.chunkIndex - this.currentChunkIndex) * TemporaryData.this.chunkSize + TemporaryData.this.chunkOffset - this.currentChunkOffset;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int read = 0;
            while (len > 0 && (this.currentChunkIndex != TemporaryData.this.chunkIndex || this.currentChunkOffset != TemporaryData.this.chunkOffset)) {
                int c = this.currentChunkIndex == TemporaryData.this.chunkIndex ? Math.min(len, TemporaryData.this.chunkOffset - this.currentChunkOffset) : Math.min(len, TemporaryData.this.chunkSize - this.currentChunkOffset);
                System.arraycopy(TemporaryData.this.chunks[this.currentChunkIndex], this.currentChunkOffset, b, off, c);
                len -= c;
                off += c;
                this.currentChunkOffset += c;
                read += c;
                if (this.currentChunkOffset != TemporaryData.this.chunkSize) continue;
                ++this.currentChunkIndex;
                this.currentChunkOffset = 0;
            }
            if (read == 0) {
                return -1;
            }
            return read;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b) == -1 ? -1 : b[0] & 0xFF;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int readlimit) {
            this.markChunkIndex = this.currentChunkIndex;
            this.markChunkOffset = this.currentChunkOffset;
        }

        public void reset() throws IOException {
            this.currentChunkIndex = this.markChunkIndex;
            this.currentChunkOffset = this.markChunkOffset;
        }

        public long skip(long n) throws IOException {
            int available = this.available();
            int c = n < (long)available ? (int)n : available;
            int newOffset = this.currentChunkOffset + c;
            int chunkDelta = newOffset / TemporaryData.this.chunkSize;
            this.currentChunkIndex += chunkDelta;
            this.currentChunkOffset = newOffset - chunkDelta * TemporaryData.this.chunkSize;
            return c;
        }

        public void close() throws IOException {
        }
    }

    class OutputStreamImpl
    extends OutputStream {
        private FileOutputStream fileOutputStream;

        OutputStreamImpl() {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.write(b, off, len);
            } else if (len > (TemporaryData.this.chunks.length - TemporaryData.this.chunkIndex) * TemporaryData.this.chunkSize - TemporaryData.this.chunkOffset) {
                this.fileOutputStream = TemporaryData.this.switchToTempFile();
                this.fileOutputStream.write(b, off, len);
            } else {
                while (len > 0) {
                    byte[] chunk = TemporaryData.this.getCurrentChunk();
                    int c = Math.min(len, TemporaryData.this.chunkSize - TemporaryData.this.chunkOffset);
                    System.arraycopy(b, off, chunk, TemporaryData.this.chunkOffset, c);
                    len -= c;
                    off += c;
                    TemporaryData.this.chunkOffset += c;
                    if (TemporaryData.this.chunkOffset != TemporaryData.this.chunkSize) continue;
                    ++TemporaryData.this.chunkIndex;
                    TemporaryData.this.chunkOffset = 0;
                }
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        public void flush() throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.flush();
            }
        }

        public void close() throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
        }
    }
}

