/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.throttle;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.wso2.throttle.AccessInformation;
import org.wso2.throttle.AccessRateController;
import org.wso2.throttle.ConcurrentAccessController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.ThrottleFactory;

public class ThrottleMediator
extends AbstractMediator
implements ManagedLifecycle {
    private String policyKey = null;
    private OMElement inLinePolicy = null;
    private String onRejectSeqKey = null;
    private Mediator onRejectMediator = null;
    private String onAcceptSeqKey = null;
    private Mediator onAcceptMediator = null;
    private String id;
    private AccessRateController accessControler;
    private ConcurrentAccessController concurrentAccessController = null;
    private String key;
    private boolean isClusteringEnable = false;
    private Throttle throttle;
    private final Object throttleLock = new Object();

    public ThrottleMediator() {
        this.accessControler = new AccessRateController();
    }

    public void init(SynapseEnvironment se) {
        if (this.onAcceptMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onAcceptMediator).init(se);
        }
        if (this.onRejectMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onRejectMediator).init(se);
        }
    }

    public void destroy() {
        if (this.onAcceptMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onAcceptMediator).destroy();
        }
        if (this.onRejectMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onRejectMediator).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mediate(MessageContext synCtx) {
        boolean canAccess;
        SynapseLog synLog;
        block34: {
            Mediator mediator;
            ConfigurationContext cc;
            org.apache.axis2.context.MessageContext axisMC;
            boolean isResponse;
            block33: {
                synLog = this.getLog(synCtx);
                isResponse = synCtx.isResponse();
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)"Start : Throttle mediator");
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
                    }
                }
                Object object = this.throttleLock;
                synchronized (object) {
                    block35: {
                        Object entryValue;
                        block38: {
                            Entry entry;
                            block37: {
                                block36: {
                                    ClusterManager clusterManager;
                                    axisMC = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                                    cc = axisMC.getConfigurationContext();
                                    if ((this.throttle == null && !isResponse || isResponse && this.concurrentAccessController == null) && (clusterManager = cc.getAxisConfiguration().getClusterManager()) != null && clusterManager.getContextManager() != null) {
                                        this.isClusteringEnable = true;
                                    }
                                    if (isResponse) break block35;
                                    if (this.isClusteringEnable) {
                                        this.concurrentAccessController = (ConcurrentAccessController)cc.getProperty(this.key);
                                    }
                                    if (this.inLinePolicy == null) break block36;
                                    if (this.throttle == null) {
                                        if (synLog.isTraceTraceEnabled()) {
                                            synLog.traceTrace((Object)("Initializing using static throttling policy : " + this.inLinePolicy));
                                        }
                                        try {
                                            this.throttle = ThrottleFactory.createMediatorThrottle((Policy)PolicyEngine.getPolicy((OMElement)this.inLinePolicy));
                                            if (this.throttle != null && this.concurrentAccessController == null) {
                                                this.concurrentAccessController = this.throttle.getConcurrentAccessController();
                                                if (this.concurrentAccessController != null) {
                                                    cc.setProperty(this.key, (Object)this.concurrentAccessController);
                                                }
                                            }
                                            break block33;
                                        }
                                        catch (ThrottleException e) {
                                            this.handleException("Error processing the throttling policy", (Exception)((Object)e), synCtx);
                                        }
                                    }
                                    break block33;
                                }
                                if (this.policyKey == null) break block33;
                                entry = synCtx.getConfiguration().getEntryDefinition(this.policyKey);
                                if (entry != null) break block37;
                                this.handleException("Cannot find throttling policy using key : " + this.policyKey, synCtx);
                                break block33;
                            }
                            boolean reCreate = false;
                            if (entry.isDynamic() && (!entry.isCached() || entry.isExpired())) {
                                reCreate = true;
                            }
                            if (!reCreate && this.throttle != null) break block33;
                            entryValue = synCtx.getEntry(this.policyKey);
                            if (entryValue != null) break block38;
                            this.handleException("Null throttling policy returned by Entry : " + this.policyKey, synCtx);
                            break block33;
                        }
                        if (!(entryValue instanceof OMElement)) {
                            this.handleException("Policy returned from key : " + this.policyKey + " is not an OMElement", synCtx);
                            break block33;
                        } else {
                            if (this.isClusteringEnable && this.concurrentAccessController != null && this.throttle != null) {
                                this.concurrentAccessController = null;
                            }
                            try {
                                this.throttle = ThrottleFactory.createMediatorThrottle((Policy)PolicyEngine.getPolicy((OMElement)((OMElement)entryValue)));
                                if (this.throttle == null || this.concurrentAccessController != null && this.isClusteringEnable) break block33;
                                this.concurrentAccessController = this.throttle.getConcurrentAccessController();
                                if (this.concurrentAccessController != null) {
                                    cc.setProperty(this.key, (Object)this.concurrentAccessController);
                                    break block33;
                                }
                                cc.removeProperty(this.key);
                            }
                            catch (ThrottleException e) {
                                this.handleException("Error processing the throttling policy", (Exception)((Object)e), synCtx);
                            }
                        }
                        break block33;
                    }
                    this.concurrentAccessController = (ConcurrentAccessController)cc.getProperty(this.key);
                }
            }
            canAccess = this.doThrottleByConcurrency(isResponse, synLog);
            if (this.throttle != null && !isResponse && canAccess) {
                canAccess = this.throttleByAccessRate(synCtx, axisMC, cc, synLog);
            }
            if (this.isClusteringEnable && this.concurrentAccessController != null && cc != null) {
                try {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("Going to replicates the  states of the ConcurrentAccessController with key : " + this.key));
                    }
                    Replicator.replicate((AbstractContext)cc);
                }
                catch (ClusteringFault clusteringFault) {
                    this.handleException("Error during the replicating  states ", (Exception)((Object)clusteringFault), synCtx);
                }
            }
            if (canAccess) {
                if (this.onAcceptSeqKey != null) {
                    mediator = synCtx.getSequence(this.onAcceptSeqKey);
                    if (mediator != null) {
                        return mediator.mediate(synCtx);
                    }
                    this.handleException("Unable to find onAccept sequence with key : " + this.onAcceptSeqKey, synCtx);
                    break block34;
                } else {
                    if (this.onAcceptMediator != null) {
                        return this.onAcceptMediator.mediate(synCtx);
                    }
                    return true;
                }
            }
            if (this.onRejectSeqKey != null) {
                mediator = synCtx.getSequence(this.onRejectSeqKey);
                if (mediator != null) {
                    return mediator.mediate(synCtx);
                }
                this.handleException("Unable to find onReject sequence with key : " + this.onRejectSeqKey, synCtx);
            } else {
                if (this.onRejectMediator != null) {
                    return this.onRejectMediator.mediate(synCtx);
                }
                return false;
            }
        }
        synLog.traceOrDebug((Object)"End : Throttle mediator");
        return canAccess;
    }

    private boolean doThrottleByConcurrency(boolean isResponse, SynapseLog synLog) {
        boolean canAcess = true;
        if (this.concurrentAccessController != null) {
            int concurrentLimit = this.concurrentAccessController.getLimit();
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("Concurrent access controller for ID : " + this.id + " allows : " + concurrentLimit + " concurrent accesses"));
            }
            if (!isResponse) {
                int available = this.concurrentAccessController.getAndDecrement();
                boolean bl = canAcess = available > 0;
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("Concurrency Throttle : Access " + (canAcess ? "allowed" : "denied") + " :: " + available + " of available of " + concurrentLimit + " connections"));
                }
            } else {
                int available = this.concurrentAccessController.incrementAndGet();
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of " + concurrentLimit + " connections"));
                }
            }
        }
        return canAcess;
    }

    private boolean throttleByAccessRate(MessageContext synCtx, org.apache.axis2.context.MessageContext axisMC, ConfigurationContext cc, SynapseLog synLog) {
        AccessInformation accessInformation;
        ThrottleConfiguration config;
        ThrottleContext context;
        String callerId = null;
        boolean canAccess = true;
        String remoteIP = (String)axisMC.getPropertyNonReplicable("REMOTE_ADDR");
        String domainName = (String)axisMC.getPropertyNonReplicable("REMOTE_HOST");
        if (domainName != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("The Domain Name of the caller is :" + domainName));
            }
            if ((context = this.throttle.getThrottleContext("key_of_domain_based_throttle")) != null && (config = context.getThrottleConfiguration()) != null && (callerId = config.getConfigurationKeyOfCaller(domainName)) != null) {
                if (this.isClusteringEnable) {
                    context.setConfigurationContext(cc);
                    context.setThrottleId(this.id);
                }
                try {
                    accessInformation = this.accessControler.canAccess(context, callerId, 1);
                    canAccess = accessInformation.isAccessAllowed();
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("Access " + (canAccess ? "allowed" : "denied") + " for Domain Name : " + domainName));
                    }
                    if (!canAccess && this.concurrentAccessController != null) {
                        this.concurrentAccessController.incrementAndGet();
                        if (this.isClusteringEnable) {
                            cc.setProperty(this.key, (Object)this.concurrentAccessController);
                        }
                    }
                }
                catch (ThrottleException e) {
                    this.handleException("Error occurd during throttling", (Exception)((Object)e), synCtx);
                }
            }
        } else {
            synLog.traceOrDebug((Object)"The Domain name of the caller cannot be found");
        }
        if (callerId == null) {
            if (remoteIP == null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)"The IP address of the caller cannot be found");
                }
                canAccess = true;
            } else {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("The IP Address of the caller is :" + remoteIP));
                }
                try {
                    context = this.throttle.getThrottleContext("key_of_ip_based_throttle");
                    if (context != null && (config = context.getThrottleConfiguration()) != null && (callerId = config.getConfigurationKeyOfCaller(remoteIP)) != null) {
                        if (this.isClusteringEnable) {
                            context.setConfigurationContext(cc);
                            context.setThrottleId(this.id);
                        }
                        accessInformation = this.accessControler.canAccess(context, callerId, 0);
                        canAccess = accessInformation.isAccessAllowed();
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug((Object)("Access " + (canAccess ? "allowed" : "denied") + " for IP : " + remoteIP));
                        }
                        if (!canAccess && this.concurrentAccessController != null) {
                            this.concurrentAccessController.incrementAndGet();
                            if (this.isClusteringEnable) {
                                cc.setProperty(this.key, (Object)this.concurrentAccessController);
                            }
                        }
                    }
                }
                catch (ThrottleException e) {
                    this.handleException("Error occurd during throttling", (Exception)((Object)e), synCtx);
                }
            }
        }
        return canAccess;
    }

    public String getPolicyKey() {
        return this.policyKey;
    }

    public void setPolicyKey(String policyKey) {
        this.policyKey = policyKey;
    }

    public OMElement getInLinePolicy() {
        return this.inLinePolicy;
    }

    public void setInLinePolicy(OMElement inLinePolicy) {
        this.inLinePolicy = inLinePolicy;
    }

    public String getOnRejectSeqKey() {
        return this.onRejectSeqKey;
    }

    public void setOnRejectSeqKey(String onRejectSeqKey) {
        this.onRejectSeqKey = onRejectSeqKey;
    }

    public Mediator getOnRejectMediator() {
        return this.onRejectMediator;
    }

    public void setOnRejectMediator(Mediator onRejectMediator) {
        this.onRejectMediator = onRejectMediator;
    }

    public String getOnAcceptSeqKey() {
        return this.onAcceptSeqKey;
    }

    public void setOnAcceptSeqKey(String onAcceptSeqKey) {
        this.onAcceptSeqKey = onAcceptSeqKey;
    }

    public Mediator getOnAcceptMediator() {
        return this.onAcceptMediator;
    }

    public void setOnAcceptMediator(Mediator onAcceptMediator) {
        this.onAcceptMediator = onAcceptMediator;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.key = "throttle_" + id + "_cac_key";
    }
}

