/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import com.sun.phobos.script.javascript.RhinoScriptEngineFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.bsf.xml.XMLHelper;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.bsf.ScriptMessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptMediator
extends AbstractMediator {
    private static final String MC_VAR_NAME = "mc";
    private String key;
    private String language;
    private final Map<String, Object> includes;
    private String function = "mediate";
    private String scriptSourceCode;
    protected ScriptEngine scriptEngine;
    private boolean multiThreadedEngine;
    private CompiledScript compiledScript;
    private Invocable invocableScript;
    private XMLHelper xmlHelper;
    private final Object resourceLock = new Object();

    public ScriptMediator(String language, String scriptSourceCode) {
        this.language = language;
        this.scriptSourceCode = scriptSourceCode;
        this.includes = new TreeMap<String, Object>();
        this.initInlineScript();
    }

    public ScriptMediator(String language, Map<String, Object> includeKeysMap, String key, String function) {
        this.language = language;
        this.key = key;
        this.includes = includeKeysMap;
        if (function != null) {
            this.function = function;
        }
        this.initScriptEngine();
        if (!(this.scriptEngine instanceof Invocable)) {
            throw new SynapseException("Script engine is not an Invocable engine for language: " + language);
        }
        this.invocableScript = (Invocable)((Object)this.scriptEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        boolean returnValue;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Script mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("Scripting language : " + this.language + " source " + (this.key == null ? ": specified inline " : " loaded with key : " + this.key) + (this.function != null ? " function : " + this.function : "")));
        }
        if (this.multiThreadedEngine) {
            returnValue = this.invokeScript(synCtx);
        } else {
            Class<?> clazz = this.scriptEngine.getClass();
            synchronized (clazz) {
                returnValue = this.invokeScript(synCtx);
            }
        }
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace((Object)("Result message after execution of script : " + synCtx.getEnvelope()));
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("End : Script mediator return value : " + returnValue));
        }
        return returnValue;
    }

    private boolean invokeScript(MessageContext synCtx) {
        boolean returnValue;
        try {
            Object returnObject = this.key != null ? this.mediateWithExternalScript(synCtx) : this.mediateForInlineScript(synCtx);
            returnValue = returnObject == null || !(returnObject instanceof Boolean) || (Boolean)returnObject != false;
        }
        catch (ScriptException e) {
            this.handleException("The script engine returned an error executing the " + (this.key == null ? "inlined " : "external ") + this.language + " script" + (this.key != null ? " : " + this.key : "") + (this.function != null ? " function " + this.function : ""), e, synCtx);
            returnValue = false;
        }
        catch (NoSuchMethodException e) {
            this.handleException("The script engine returned a NoSuchMethodException executing the external " + this.language + " script" + " : " + this.key + (this.function != null ? " function " + this.function : ""), e, synCtx);
            returnValue = false;
        }
        return returnValue;
    }

    private Object mediateWithExternalScript(MessageContext synCtx) throws ScriptException, NoSuchMethodException {
        this.prepareExternalScript(synCtx);
        ScriptMessageContext scriptMC = new ScriptMessageContext(synCtx, this.xmlHelper);
        return this.invocableScript.invokeFunction(this.function, scriptMC);
    }

    private Object mediateForInlineScript(MessageContext synCtx) throws ScriptException {
        ScriptMessageContext scriptMC = new ScriptMessageContext(synCtx, this.xmlHelper);
        Bindings bindings = this.scriptEngine.createBindings();
        bindings.put(MC_VAR_NAME, (Object)scriptMC);
        Object response = this.compiledScript != null ? this.compiledScript.eval(bindings) : this.scriptEngine.eval(this.scriptSourceCode, bindings);
        return response;
    }

    protected void initInlineScript() {
        try {
            this.initScriptEngine();
            if (this.scriptEngine instanceof Compilable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Script engine supports Compilable interface, compiling script code..");
                }
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.scriptSourceCode);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Script engine does not support the Compilable interface, in-lined script would be evaluated on each invocation..");
            }
        }
        catch (ScriptException e) {
            throw new SynapseException("Exception initializing inline script", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void prepareExternalScript(MessageContext synCtx) throws ScriptException {
        Entry entry = synCtx.getConfiguration().getEntryDefinition(this.key);
        boolean needsReload = entry != null && entry.isDynamic() && (!entry.isCached() || entry.isExpired());
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.scriptSourceCode == null || needsReload) {
                DataHandler dataHandler;
                Object o = synCtx.getEntry(this.key);
                if (o instanceof OMElement) {
                    this.scriptSourceCode = ((OMElement)o).getText();
                    this.scriptEngine.eval(this.scriptSourceCode);
                } else if (o instanceof String) {
                    this.scriptSourceCode = (String)o;
                    this.scriptEngine.eval(this.scriptSourceCode);
                } else if (o instanceof OMText && (dataHandler = (DataHandler)((OMText)o).getDataHandler()) != null) {
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(dataHandler.getInputStream()));
                        this.scriptEngine.eval(reader);
                    }
                    catch (IOException e) {
                        this.handleException("Error in reading script as a stream ", e, synCtx);
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                this.handleException("Error in closing input stream ", e, synCtx);
                            }
                        }
                    }
                }
            }
        }
        for (String includeKey : this.includes.keySet()) {
            String includeSourceCode = (String)this.includes.get(includeKey);
            Entry includeEntry = synCtx.getConfiguration().getEntryDefinition(includeKey);
            boolean includeEntryNeedsReload = includeEntry != null && includeEntry.isDynamic() && (!includeEntry.isCached() || includeEntry.isExpired());
            Object object2 = this.resourceLock;
            synchronized (object2) {
                if (includeSourceCode == null || includeEntryNeedsReload) {
                    DataHandler dataHandler;
                    this.log.debug((Object)("Re-/Loading the include script with key " + includeKey));
                    Object o = synCtx.getEntry(includeKey);
                    if (o instanceof OMElement) {
                        includeSourceCode = ((OMElement)o).getText();
                        this.scriptEngine.eval(includeSourceCode);
                    } else if (o instanceof String) {
                        includeSourceCode = (String)o;
                        this.scriptEngine.eval(includeSourceCode);
                    } else if (o instanceof OMText && (dataHandler = (DataHandler)((OMText)o).getDataHandler()) != null) {
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(dataHandler.getInputStream()));
                            this.scriptEngine.eval(reader);
                        }
                        catch (IOException e) {
                            this.handleException("Error in reading script as a stream ", e, synCtx);
                        }
                        finally {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    this.handleException("Error in closing input stream ", e, synCtx);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected void initScriptEngine() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing script mediator for language : " + this.language));
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        manager.registerEngineExtension("js", (ScriptEngineFactory)new RhinoScriptEngineFactory());
        this.scriptEngine = manager.getEngineByExtension(this.language);
        if (this.scriptEngine == null) {
            this.handleException("No script engine found for language: " + this.language);
        }
        this.xmlHelper = XMLHelper.getArgHelper((ScriptEngine)this.scriptEngine);
        this.multiThreadedEngine = this.scriptEngine.getFactory().getParameter("THREADING") != null;
        this.log.debug((Object)("Script mediator for language : " + this.language + " supports multithreading? : " + this.multiThreadedEngine));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getKey() {
        return this.key;
    }

    public String getFunction() {
        return this.function;
    }

    public String getScriptSrc() {
        return this.scriptSourceCode;
    }

    private void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public Map<String, Object> getIncludeMap() {
        return this.includes;
    }
}

