/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class StaticImportVisitor
extends ClassCodeExpressionTransformer {
    private ClassNode currentClass;
    private SourceUnit source;
    private CompilationUnit compilationUnit;
    private boolean stillResolving;
    private boolean inSpecialContructorCall;
    private boolean inClosure;
    private boolean inPropertyExpression;
    private Expression foundConstant;
    private Expression foundArgs;

    public StaticImportVisitor(CompilationUnit cu) {
        this.compilationUnit = cu;
    }

    public void visitClass(ClassNode node, SourceUnit source) {
        this.currentClass = node;
        this.source = source;
        super.visitClass(node);
    }

    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        if (exp.getClass() == VariableExpression.class) {
            return this.transformVariableExpression((VariableExpression)exp);
        }
        if (exp.getClass() == PropertyExpression.class) {
            return this.transformPropertyExpression((PropertyExpression)exp);
        }
        if (exp.getClass() == MethodCallExpression.class) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        if (exp.getClass() == ClosureExpression.class) {
            return this.transformClosureExpression((ClosureExpression)exp);
        }
        if (exp.getClass() == ConstructorCallExpression.class) {
            return this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        }
        if (exp.getClass() == ArgumentListExpression.class) {
            Expression result = exp.transformExpression(this);
            if (this.inPropertyExpression) {
                this.foundArgs = result;
            }
            return result;
        }
        if (exp.getClass() == ConstantExpression.class) {
            Expression result = exp.transformExpression(this);
            if (this.inPropertyExpression) {
                this.foundConstant = result;
            }
            return result;
        }
        return exp.transformExpression(this);
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v != null && v instanceof DynamicVariable) {
            Expression result = this.findStaticFieldImportFromModule(v.getName());
            if (result != null) {
                return result;
            }
            if (!this.inPropertyExpression || this.inSpecialContructorCall) {
                this.addStaticVariableError(ve);
            }
        }
        return ve;
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression ret;
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        if (mce.isImplicitThis() && (ret = this.findStaticMethodImportFromModule(method, args)) != null) {
            return ret;
        }
        Expression object = this.transform(mce.getObjectExpression());
        mce.setObjectExpression(object);
        mce.setArguments(args);
        mce.setMethod(method);
        return mce;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        this.inSpecialContructorCall = cce.isSpecialCall();
        Expression ret = cce.transformExpression(this);
        this.inSpecialContructorCall = false;
        return ret;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        Statement code = ce.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        Expression result;
        boolean oldInPropertyExpression = this.inPropertyExpression;
        Expression oldFoundArgs = this.foundArgs;
        Expression oldFoundMethod = this.foundConstant;
        this.inPropertyExpression = true;
        Expression objectExpression = this.transform(pe.getObjectExpression());
        this.foundArgs = null;
        this.foundConstant = null;
        if (this.foundArgs != null && this.foundConstant != null && (result = this.findStaticMethodImportFromModule(this.foundConstant, this.foundArgs)) != null) {
            objectExpression = result;
        }
        this.inPropertyExpression = oldInPropertyExpression;
        this.foundArgs = oldFoundArgs;
        this.foundConstant = oldFoundMethod;
        pe.setObjectExpression(objectExpression);
        if (!this.inSpecialContructorCall) {
            this.checkStaticScope(pe);
        }
        return pe;
    }

    private void checkStaticScope(PropertyExpression pe) {
        if (this.inClosure) {
            return;
        }
        for (Expression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof PropertyExpression) continue;
            if (it instanceof VariableExpression) {
                this.addStaticVariableError((VariableExpression)it);
            }
            return;
        }
    }

    private void addStaticVariableError(VariableExpression ve) {
        if (!(this.inSpecialContructorCall || !this.inClosure && ve.isInStaticContext())) {
            return;
        }
        if (this.stillResolving) {
            return;
        }
        if (ve == VariableExpression.THIS_EXPRESSION || ve == VariableExpression.SUPER_EXPRESSION) {
            return;
        }
        Variable v = ve.getAccessedVariable();
        if (v != null && !(v instanceof DynamicVariable) && v.isInStaticContext()) {
            return;
        }
        this.addError("the name " + ve.getName() + " doesn't refer to a declared variable or class. The static" + " scope requires that you declare variables before using them. If the variable should have" + " been a class check the spelling.", ve);
    }

    private Expression findStaticFieldImportFromModule(String name) {
        Map fields;
        String fieldName;
        ClassNode node;
        Expression expression;
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return null;
        }
        Map aliases = module.getStaticImportAliases();
        this.stillResolving = false;
        if (aliases.containsKey(name) && (expression = this.findStaticField(node = (ClassNode)aliases.get(name), fieldName = (String)(fields = module.getStaticImportFields()).get(name))) != null) {
            return expression;
        }
        Map importedClasses = module.getStaticImportClasses();
        Iterator it = importedClasses.keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            ClassNode node2 = (ClassNode)importedClasses.get(className);
            Expression expression2 = this.findStaticField(node2, name);
            if (expression2 == null) continue;
            return expression2;
        }
        return null;
    }

    private Expression findStaticField(ClassNode staticImportType, String fieldName) {
        if (!staticImportType.isResolved() && !staticImportType.isPrimaryClassNode()) {
            this.stillResolving = true;
        }
        if (staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) {
            staticImportType.getFields();
            FieldNode field = staticImportType.getField(fieldName);
            if (field != null && field.isStatic()) {
                return new PropertyExpression((Expression)new ClassExpression(staticImportType), fieldName);
            }
        }
        return null;
    }

    private Expression findStaticMethodImportFromModule(Expression method, Expression args) {
        Map fields;
        String fieldName;
        ClassNode node;
        Expression expression;
        ModuleNode module = this.currentClass.getModule();
        if (module == null || !(method instanceof ConstantExpression)) {
            return null;
        }
        Map aliases = module.getStaticImportAliases();
        ConstantExpression ce = (ConstantExpression)method;
        Object value = ce.getValue();
        if (!(value instanceof String)) {
            return null;
        }
        String name = (String)value;
        if (aliases.containsKey(name) && (expression = this.findStaticMethod(node = (ClassNode)aliases.get(name), fieldName = (String)(fields = module.getStaticImportFields()).get(name), args)) != null) {
            return expression;
        }
        Map importPackages = module.getStaticImportClasses();
        Iterator it = importPackages.keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            ClassNode starImportType = (ClassNode)importPackages.get(className);
            Expression expression2 = this.findStaticMethod(starImportType, name, args);
            if (expression2 == null) continue;
            return expression2;
        }
        return null;
    }

    private Expression findStaticMethod(ClassNode staticImportType, String methodName, Expression args) {
        if ((staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) && staticImportType.hasPossibleStaticMethod(methodName, args)) {
            return new StaticMethodCallExpression(staticImportType, methodName, args);
        }
        return null;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }
}

