/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.exslt.Common;
import net.sf.saxon.exslt.Date;
import net.sf.saxon.exslt.Math;
import net.sf.saxon.exslt.Random;
import net.sf.saxon.exslt.Sets;
import net.sf.saxon.functions.Collection;
import net.sf.saxon.functions.CompileTimeFunction;
import net.sf.saxon.functions.ExtensionFunctionCall;
import net.sf.saxon.functions.Extensions;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.JavaExtensionFunctionFactory;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Value;

public class JavaExtensionLibrary
implements FunctionLibrary {
    private Configuration config;
    private HashMap explicitMappings = new HashMap(10);
    private transient PrintStream diag = System.err;
    private static final Class[] NO_PARAMS = new Class[0];

    public JavaExtensionLibrary(Configuration configuration) {
        this.config = configuration;
        this.setDefaultURIMappings();
    }

    protected void setDefaultURIMappings() {
        this.declareJavaClass("http://saxon.sf.net/", Extensions.class);
        this.declareJavaClass("http://exslt.org/common", Common.class);
        this.declareJavaClass("http://exslt.org/sets", Sets.class);
        this.declareJavaClass("http://exslt.org/math", Math.class);
        this.declareJavaClass("http://exslt.org/dates-and-times", Date.class);
        this.declareJavaClass("http://exslt.org/random", Random.class);
    }

    public void declareJavaClass(String string, Class clazz) {
        this.explicitMappings.put(string, clazz);
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        int n3;
        boolean bl;
        Class<?>[] classArray;
        Class clazz;
        if (!this.config.isAllowExternalFunctions()) {
            return false;
        }
        try {
            clazz = this.getExternalJavaClass(string);
            if (clazz == null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        Class clazz2 = clazz;
        if ("new".equals(string2)) {
            int n4 = clazz2.getModifiers();
            if (Modifier.isAbstract(n4)) {
                return false;
            }
            if (Modifier.isInterface(n4)) {
                return false;
            }
            if (Modifier.isPrivate(n4)) {
                return false;
            }
            if (Modifier.isProtected(n4)) {
                return false;
            }
            if (n2 == -1) {
                return true;
            }
            Constructor<?>[] constructorArray = clazz2.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor = constructorArray[i];
                if (constructor.getParameterTypes().length != n2) continue;
                return true;
            }
            return false;
        }
        String string3 = ExtensionFunctionCall.toCamelCase(string2, false, this.diag);
        Method[] methodArray = clazz2.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(string3) || !Modifier.isPublic(method.getModifiers())) continue;
            if (n2 == -1) {
                return true;
            }
            classArray = method.getParameterTypes();
            bl = Modifier.isStatic(method.getModifiers());
            int n5 = n3 = bl ? n2 : n2 - 1;
            if (n3 < 0) continue;
            if (classArray.length == n3 && (n3 == 0 || classArray[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext))) {
                return true;
            }
            if (classArray.length != n3 + 1 || classArray[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext)) continue;
            return true;
        }
        Field[] fieldArray = clazz2.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            classArray = fieldArray[i];
            if (!classArray.getName().equals(string3) || !Modifier.isPublic(classArray.getModifiers())) continue;
            if (n2 == -1) {
                return true;
            }
            bl = Modifier.isStatic(classArray.getModifiers());
            int n6 = n3 = bl ? n2 : n2 - 1;
            if (n3 != 0) continue;
            return true;
        }
        return false;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        Object object;
        Class clazz;
        boolean bl = this.config.isTraceExternalFunctions();
        if (!this.config.isAllowExternalFunctions()) {
            if (bl) {
                this.diag.println("Calls to extension functions have been disabled");
            }
            return null;
        }
        StaticError staticError = null;
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        Class<?> clazz2 = null;
        try {
            clazz = this.getExternalJavaClass(string);
            if (clazz == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw new StaticError("Cannot load external Java class", exception);
        }
        if (bl) {
            this.diag.println("Looking for method " + string2 + " in Java class " + clazz);
            this.diag.println("Number of actual arguments = " + expressionArray.length);
        }
        int n2 = expressionArray.length;
        Class clazz3 = clazz;
        if ("new".equals(string2)) {
            int n3;
            if (bl) {
                this.diag.println("Looking for a constructor");
            }
            if (Modifier.isAbstract(n3 = clazz3.getModifiers())) {
                staticError = new StaticError("Class " + clazz3 + " is abstract");
            } else if (Modifier.isInterface(n3)) {
                staticError = new StaticError(clazz3 + " is an interface");
            } else if (Modifier.isPrivate(n3)) {
                staticError = new StaticError("Class " + clazz3 + " is private");
            } else if (Modifier.isProtected(n3)) {
                staticError = new StaticError("Class " + clazz3 + " is protected");
            }
            if (staticError != null) {
                if (bl) {
                    this.diag.println("Cannot construct an instance: " + staticError.getMessage());
                }
                return null;
            }
            object = clazz3.getConstructors();
            for (int i = 0; i < ((Executable[])object).length; ++i) {
                Executable executable = object[i];
                if (bl) {
                    this.diag.println("Found a constructor with " + ((Constructor)executable).getParameterTypes().length + " arguments");
                }
                if (((Constructor)executable).getParameterTypes().length != n2) continue;
                arrayList.add(executable);
            }
            if (arrayList.size() == 0) {
                staticError = new StaticError("No constructor with " + n2 + (n2 == 1 ? " parameter" : " parameters") + " found in class " + clazz3.getName());
                if (bl) {
                    this.diag.println(staticError.getMessage());
                }
                return null;
            }
        } else {
            int n4;
            boolean bl2;
            Class<?>[] classArray;
            String string3 = ExtensionFunctionCall.toCamelCase(string2, bl, this.diag);
            object = clazz3.getMethods();
            boolean bl3 = true;
            for (int i = 0; i < ((Method[])object).length; ++i) {
                Method method = object[i];
                if (bl) {
                    if (method.getName().equals(string3)) {
                        this.diag.println("Trying method " + method.getName() + ": name matches");
                        if (!Modifier.isPublic(method.getModifiers())) {
                            this.diag.println(" -- but the method is not public");
                        }
                    } else {
                        this.diag.println("Trying method " + method.getName() + ": name does not match");
                    }
                }
                if (!method.getName().equals(string3) || !Modifier.isPublic(method.getModifiers())) continue;
                if (bl3) {
                    if (clazz2 == null) {
                        clazz2 = method.getReturnType();
                    } else {
                        bl3 = method.getReturnType() == clazz2;
                    }
                }
                classArray = method.getParameterTypes();
                bl2 = Modifier.isStatic(method.getModifiers());
                if (bl) {
                    this.diag.println("Method is " + (bl2 ? "" : "not ") + "static");
                }
                int n5 = n4 = bl2 ? n2 : n2 - 1;
                if (n4 < 0) continue;
                if (bl) {
                    this.diag.println("Method has " + classArray.length + " argument" + (classArray.length == 1 ? "" : "s") + "; expecting " + n4);
                }
                if (classArray.length == n4 && (n4 == 0 || classArray[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext))) {
                    if (bl) {
                        this.diag.println("Found a candidate method:");
                        this.diag.println("    " + method);
                    }
                    arrayList.add(method);
                }
                if (classArray.length != n4 + 1 || classArray[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext)) continue;
                if (bl) {
                    this.diag.println("Method is a candidate because first argument is XPathContext");
                }
                arrayList.add(method);
            }
            Field[] fieldArray = clazz3.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                classArray = fieldArray[i];
                if (bl) {
                    if (classArray.getName().equals(string3)) {
                        this.diag.println("Trying field " + classArray.getName() + ": name matches");
                        if (!Modifier.isPublic(classArray.getModifiers())) {
                            this.diag.println(" -- but the field is not public");
                        }
                    } else {
                        this.diag.println("Trying field " + classArray.getName() + ": name does not match");
                    }
                }
                if (!classArray.getName().equals(string3) || !Modifier.isPublic(classArray.getModifiers())) continue;
                if (bl3) {
                    if (clazz2 == null) {
                        clazz2 = classArray.getType();
                    } else {
                        bl3 = classArray.getType() == clazz2;
                    }
                }
                bl2 = Modifier.isStatic(classArray.getModifiers());
                if (bl) {
                    this.diag.println("Field is " + (bl2 ? "" : "not ") + "static");
                }
                int n6 = n4 = bl2 ? n2 : n2 - 1;
                if (n4 != 0) continue;
                if (bl) {
                    this.diag.println("Found a candidate field:");
                    this.diag.println("    " + classArray);
                }
                arrayList.add(classArray);
            }
            if (arrayList.size() == 0) {
                staticError = new StaticError("No method or field matching " + string3 + " with " + n2 + (n2 == 1 ? " parameter" : " parameters") + " found in class " + clazz3.getName());
                if (bl) {
                    this.diag.println(staticError.getMessage());
                }
                return null;
            }
        }
        if (arrayList.size() == 0) {
            if (bl) {
                this.diag.println("There is no suitable method matching the arguments of function " + string2);
            }
            return null;
        }
        AccessibleObject accessibleObject = this.getBestFit(arrayList, expressionArray, clazz3);
        if (accessibleObject == null) {
            if (arrayList.size() > 1) {
                return new UnresolvedExtensionFunction(n, clazz3, arrayList, expressionArray);
            }
            return null;
        }
        object = (JavaExtensionFunctionFactory)this.config.getExtensionFunctionFactory("java");
        return ((JavaExtensionFunctionFactory)object).makeExtensionFunctionCall(n, clazz3, accessibleObject, expressionArray);
    }

    private AccessibleObject getBestFit(List list, Expression[] expressionArray, Class clazz) {
        Object object;
        int n;
        boolean bl = this.config.isTraceExternalFunctions();
        int n2 = list.size();
        if (n2 == 1) {
            return (AccessibleObject)list.get(0);
        }
        if (bl) {
            this.diag.println("Finding best fit method with arguments:");
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i].display(10, this.diag, this.config);
            }
        }
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = false;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                object = this.getConversionPreferences(expressionArray, (AccessibleObject)list.get(n), clazz);
                this.diag.println("Trying option " + n + ": " + list.get(n).toString());
                if (object == null) {
                    this.diag.println("Arguments cannot be converted to required types");
                    continue;
                }
                String string = "[";
                for (int i = 0; i < ((int[])object).length; ++i) {
                    if (i != 0) {
                        string = string + ", ";
                    }
                    string = string + object[i];
                }
                string = string + "]";
                this.diag.println("Conversion preferences are " + string);
            }
        }
        for (n = 0; n < n2; ++n) {
            object = this.getConversionPreferences(expressionArray, (AccessibleObject)list.get(n), clazz);
            if (object == null) {
                blArray[n] = true;
            }
            if (blArray[n]) continue;
            for (int i = n + 1; i < n2; ++i) {
                if (blArray[i]) continue;
                int[] nArray = this.getConversionPreferences(expressionArray, (AccessibleObject)list.get(i), clazz);
                if (nArray == null) {
                    blArray[i] = true;
                    continue;
                }
                for (int j = 0; j < nArray.length; ++j) {
                    if (object[j] > nArray[j] && !blArray[n]) {
                        blArray[n] = true;
                        if (bl) {
                            this.diag.println("Eliminating option " + n);
                        }
                    }
                    if (object[j] >= nArray[j] || blArray[i]) continue;
                    blArray[i] = true;
                    if (!bl) continue;
                    this.diag.println("Eliminating option " + i);
                }
            }
        }
        n = 0;
        object = null;
        for (int i = 0; i < n2; ++i) {
            if (blArray[i]) continue;
            object = (AccessibleObject)list.get(i);
            ++n;
        }
        if (bl) {
            this.diag.println("Number of candidate methods remaining: " + n);
        }
        if (n == 0) {
            if (bl) {
                this.diag.println("There are " + n2 + " candidate Java methods matching the function name, but none is a unique best match");
            }
            return null;
        }
        if (n > 1) {
            if (bl) {
                this.diag.println("There are several Java methods that match the function name equally well");
            }
            return null;
        }
        return object;
    }

    private int[] getConversionPreferences(Expression[] expressionArray, AccessibleObject accessibleObject, Class clazz) {
        int n;
        Class<?>[] classArray;
        int n2;
        TypeHierarchy typeHierarchy = this.config.getTypeHierarchy();
        if (accessibleObject instanceof Constructor) {
            n2 = 0;
            classArray = ((Constructor)accessibleObject).getParameterTypes();
        } else if (accessibleObject instanceof Method) {
            n = Modifier.isStatic(((Method)accessibleObject).getModifiers());
            n2 = n != 0 ? 0 : 1;
            classArray = ((Method)accessibleObject).getParameterTypes();
        } else if (accessibleObject instanceof Field) {
            n = Modifier.isStatic(((Field)accessibleObject).getModifiers()) ? 1 : 0;
            n2 = n != 0 ? 0 : 1;
            classArray = NO_PARAMS;
        } else {
            throw new AssertionError((Object)("property " + accessibleObject + " was neither constructor, method, nor field"));
        }
        n = expressionArray.length;
        int[] nArray = new int[n];
        int n3 = 0;
        if (classArray.length > 0 && classArray[0] == XPathContext.class) {
            n3 = 1;
        }
        for (int i = n2; i < n; ++i) {
            nArray[i] = this.getConversionPreference(typeHierarchy, expressionArray[i], classArray[i + n3 - n2]);
            if (nArray[i] != -1) continue;
            return null;
        }
        if (n2 == 1) {
            nArray[0] = this.getConversionPreference(typeHierarchy, expressionArray[0], clazz);
            if (nArray[0] == -1) {
                return null;
            }
        }
        return nArray;
    }

    private int getConversionPreference(TypeHierarchy typeHierarchy, Expression expression, Class clazz) {
        ItemType itemType = expression.getItemType(typeHierarchy);
        int n = expression.getCardinality();
        if (clazz == Object.class) {
            return 100;
        }
        if (Cardinality.allowsMany(n)) {
            if (clazz.isAssignableFrom(SequenceIterator.class)) {
                return 20;
            }
            if (clazz.isAssignableFrom(Value.class)) {
                return 21;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return 22;
            }
            if (clazz.isArray()) {
                return 24;
            }
            return 80;
        }
        if (Type.isNodeType(itemType)) {
            if (clazz.isAssignableFrom(NodeInfo.class)) {
                return 20;
            }
            if (clazz.isAssignableFrom(DocumentInfo.class)) {
                return 21;
            }
            return 80;
        }
        if (itemType instanceof ExternalObjectType) {
            Class clazz2 = ((ExternalObjectType)itemType).getJavaClass();
            if (clazz.isAssignableFrom(clazz2)) {
                return 10;
            }
            return -1;
        }
        int n2 = itemType.getPrimitiveType();
        return this.atomicConversionPreference(n2, clazz);
    }

    protected int atomicConversionPreference(int n, Class clazz) {
        if (clazz == Object.class) {
            return 100;
        }
        switch (n) {
            case 513: {
                if (clazz.isAssignableFrom(StringValue.class)) {
                    return 50;
                }
                if (clazz == String.class) {
                    return 51;
                }
                if (clazz == CharSequence.class) {
                    return 51;
                }
                return -1;
            }
            case 517: {
                if (clazz.isAssignableFrom(DoubleValue.class)) {
                    return 50;
                }
                if (clazz == Double.TYPE) {
                    return 50;
                }
                if (clazz == Double.class) {
                    return 51;
                }
                return -1;
            }
            case 516: {
                if (clazz.isAssignableFrom(FloatValue.class)) {
                    return 50;
                }
                if (clazz == Float.TYPE) {
                    return 50;
                }
                if (clazz == Float.class) {
                    return 51;
                }
                if (clazz == Double.TYPE) {
                    return 52;
                }
                if (clazz == Double.class) {
                    return 53;
                }
                return -1;
            }
            case 515: {
                if (clazz.isAssignableFrom(DecimalValue.class)) {
                    return 50;
                }
                if (clazz == BigDecimal.class) {
                    return 50;
                }
                if (clazz == Double.TYPE) {
                    return 51;
                }
                if (clazz == Double.class) {
                    return 52;
                }
                if (clazz == Float.TYPE) {
                    return 53;
                }
                if (clazz == Float.class) {
                    return 54;
                }
                return -1;
            }
            case 532: {
                if (clazz.isAssignableFrom(Int64Value.class)) {
                    return 50;
                }
                if (clazz == BigInteger.class) {
                    return 51;
                }
                if (clazz == BigDecimal.class) {
                    return 52;
                }
                if (clazz == Long.TYPE) {
                    return 53;
                }
                if (clazz == Long.class) {
                    return 54;
                }
                if (clazz == Integer.TYPE) {
                    return 55;
                }
                if (clazz == Integer.class) {
                    return 56;
                }
                if (clazz == Short.TYPE) {
                    return 57;
                }
                if (clazz == Short.class) {
                    return 58;
                }
                if (clazz == Byte.TYPE) {
                    return 59;
                }
                if (clazz == Byte.class) {
                    return 60;
                }
                if (clazz == Double.TYPE) {
                    return 61;
                }
                if (clazz == Double.class) {
                    return 62;
                }
                if (clazz == Float.TYPE) {
                    return 63;
                }
                if (clazz == Float.class) {
                    return 64;
                }
                return -1;
            }
            case 514: {
                if (clazz.isAssignableFrom(BooleanValue.class)) {
                    return 50;
                }
                if (clazz == Boolean.TYPE) {
                    return 51;
                }
                if (clazz == Boolean.class) {
                    return 52;
                }
                return -1;
            }
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                if (clazz.isAssignableFrom(DateValue.class)) {
                    return 50;
                }
                if (clazz.isAssignableFrom(java.util.Date.class)) {
                    return 51;
                }
                return -1;
            }
            case 519: {
                if (clazz.isAssignableFrom(DateTimeValue.class)) {
                    return 50;
                }
                if (clazz.isAssignableFrom(java.util.Date.class)) {
                    return 51;
                }
                return -1;
            }
            case 520: {
                if (clazz.isAssignableFrom(TimeValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 518: 
            case 633: 
            case 634: {
                if (clazz.isAssignableFrom(DurationValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 529: {
                if (clazz.isAssignableFrom(AnyURIValue.class)) {
                    return 50;
                }
                if (clazz == URI.class) {
                    return 51;
                }
                if (clazz == URL.class) {
                    return 52;
                }
                if (clazz == String.class) {
                    return 53;
                }
                if (clazz == CharSequence.class) {
                    return 53;
                }
                return -1;
            }
            case 530: {
                if (clazz.isAssignableFrom(QualifiedNameValue.class)) {
                    return 50;
                }
                if (clazz.getClass().getName().equals("javax.xml.namespace.QName")) {
                    return 51;
                }
                return -1;
            }
            case 528: {
                if (clazz.isAssignableFrom(Base64BinaryValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 527: {
                if (clazz.isAssignableFrom(HexBinaryValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 631: {
                return 50;
            }
        }
        return -1;
    }

    private Class getExternalJavaClass(String string) {
        Class clazz = (Class)this.explicitMappings.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            if (string.startsWith("java:")) {
                return this.config.getClass(string.substring(5), this.config.isTraceExternalFunctions(), null);
            }
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return this.config.getClass(string, this.config.isTraceExternalFunctions(), null);
            }
            if (n == string.length() - 1) {
                return null;
            }
            return this.config.getClass(string.substring(n + 1), this.config.isTraceExternalFunctions(), null);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public FunctionLibrary copy() {
        JavaExtensionLibrary javaExtensionLibrary = new JavaExtensionLibrary(this.config);
        javaExtensionLibrary.explicitMappings = new HashMap(this.explicitMappings);
        javaExtensionLibrary.diag = this.diag;
        return javaExtensionLibrary;
    }

    private class UnresolvedExtensionFunction
    extends CompileTimeFunction {
        List candidateMethods;
        int nameCode;
        Class theClass;

        public UnresolvedExtensionFunction(int n, Class clazz, List list, Expression[] expressionArray) {
            this.setArguments(expressionArray);
            this.nameCode = n;
            this.theClass = clazz;
            this.candidateMethods = list;
        }

        public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
            Serializable serializable;
            for (int i = 0; i < this.argument.length; ++i) {
                serializable = this.argument[i].typeCheck(staticContext, itemType);
                if (serializable == this.argument[i]) continue;
                this.adoptChildExpression((Expression)serializable);
                this.argument[i] = serializable;
            }
            AccessibleObject accessibleObject = JavaExtensionLibrary.this.getBestFit(this.candidateMethods, this.argument, this.theClass);
            if (accessibleObject == null) {
                serializable = new StaticError("There is more than one method matching the function call " + JavaExtensionLibrary.this.config.getNamePool().getDisplayName(this.nameCode) + ", and there is insufficient type information to determine which one should be used");
                ((TransformerException)serializable).setLocator(this);
                throw serializable;
            }
            serializable = (JavaExtensionFunctionFactory)JavaExtensionLibrary.this.config.getExtensionFunctionFactory("java");
            Expression expression = ((JavaExtensionFunctionFactory)serializable).makeExtensionFunctionCall(this.nameCode, this.theClass, accessibleObject, this.argument);
            expression.setLocationId(this.getLocationId());
            expression.setParentExpression(this.getParentExpression());
            return expression;
        }
    }
}

