/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.DifferenceEnumeration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IntersectionEnumeration;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class VennExpression
extends BinaryExpression {
    public VennExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public final ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType = this.operand0.getItemType(typeHierarchy);
        ItemType itemType2 = this.operand1.getItemType(typeHierarchy);
        return Type.getCommonSuperType(itemType, itemType2, typeHierarchy);
    }

    public final int computeCardinality() {
        int n = this.operand0.getCardinality();
        int n2 = this.operand1.getCardinality();
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return n2;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return n;
                }
                return n | n2 | 0x4000 | 0x8000;
            }
            case 23: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return 8192;
                }
                return n & n2 | 0x2000 | 0x4000;
            }
            case 24: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return n;
                }
                return n | 0x2000 | 0x4000;
            }
        }
        return 57344;
    }

    public int computeSpecialProperties() {
        int n = this.operand0.getSpecialProperties();
        int n2 = this.operand1.getSpecialProperties();
        int n3 = 131072;
        if (this.testContextDocumentNodeSet(n, n2)) {
            n3 |= 0x10000;
        }
        if (this.testSubTree(n, n2)) {
            n3 |= 0x100000;
        }
        if (!this.testCreative(n, n2)) {
            n3 |= 0x400000;
        }
        return n3;
    }

    private boolean testContextDocumentNodeSet(int n, int n2) {
        switch (this.operator) {
            case 1: {
                return (n & n2 & 0x10000) != 0;
            }
            case 23: {
                return ((n | n2) & 0x10000) != 0;
            }
            case 24: {
                return (n & 0x10000) != 0;
            }
        }
        return false;
    }

    private boolean testSubTree(int n, int n2) {
        switch (this.operator) {
            case 1: {
                return (n & n2 & 0x100000) != 0;
            }
            case 23: {
                return ((n | n2) & 0x100000) != 0;
            }
            case 24: {
                return (n & 0x100000) != 0;
            }
        }
        return false;
    }

    private boolean testCreative(int n, int n2) {
        return (n & 0x400000) != 1 || (n2 & 0x400000) != 1;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression;
        Expression expression2;
        this.operand0 = this.operand0.simplify(staticContext);
        this.operand1 = this.operand1.simplify(staticContext);
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.operand0) && (this.operand1.getSpecialProperties() & 0x20000) != 0) {
                    return this.operand1;
                }
                if (!Literal.isEmptySequence(this.operand1) || (this.operand0.getSpecialProperties() & 0x20000) == 0) break;
                return this.operand0;
            }
            case 23: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return this.operand0;
                }
                if (!Literal.isEmptySequence(this.operand1)) break;
                return this.operand1;
            }
            case 24: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return this.operand0;
                }
                if (!Literal.isEmptySequence(this.operand1) || (this.operand0.getSpecialProperties() & 0x20000) == 0) break;
                return this.operand0;
            }
        }
        if (this.operand0 instanceof AxisExpression && this.operand1 instanceof AxisExpression) {
            expression2 = (AxisExpression)this.operand0;
            expression = (AxisExpression)this.operand1;
            if (((AxisExpression)expression2).getAxis() == ((AxisExpression)expression).getAxis()) {
                AxisExpression axisExpression = new AxisExpression(((AxisExpression)expression2).getAxis(), new CombinedNodeTest(((AxisExpression)expression2).getNodeTest(), this.operator, ((AxisExpression)expression).getNodeTest()));
                axisExpression.setLocationId(this.getLocationId());
                axisExpression.setParentExpression(this.getParentExpression());
                return axisExpression;
            }
        }
        if (this.operand0 instanceof PathExpression && this.operand1 instanceof PathExpression && this.operator == 1) {
            expression2 = (PathExpression)this.operand0;
            expression = (PathExpression)this.operand1;
            if (((PathExpression)expression2).getFirstStep().equals(((PathExpression)expression).getFirstStep())) {
                VennExpression vennExpression = new VennExpression(((PathExpression)expression2).getRemainingSteps(), this.operator, ((PathExpression)expression).getRemainingSteps());
                vennExpression.setLocationId(this.getLocationId());
                PathExpression pathExpression = new PathExpression(((PathExpression)expression2).getFirstStep(), vennExpression);
                ExpressionTool.copyLocationInfo(this, pathExpression);
                pathExpression.setParentExpression(this.getParentExpression());
                return pathExpression.simplify(staticContext);
            }
        }
        if (this.operand0 instanceof FilterExpression && this.operand1 instanceof FilterExpression) {
            expression2 = (FilterExpression)this.operand0;
            expression = (FilterExpression)this.operand1;
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            if (!((FilterExpression)expression2).isPositional(typeHierarchy) && !((FilterExpression)expression).isPositional(typeHierarchy) && ((FilterExpression)expression2).getBaseExpression().equals(((FilterExpression)expression).getBaseExpression())) {
                Expression expression3;
                BooleanExpression booleanExpression;
                switch (this.operator) {
                    case 1: {
                        booleanExpression = new BooleanExpression(((FilterExpression)expression2).getFilter(), 9, ((FilterExpression)expression).getFilter());
                        break;
                    }
                    case 23: {
                        booleanExpression = new BooleanExpression(((FilterExpression)expression2).getFilter(), 10, ((FilterExpression)expression).getFilter());
                        break;
                    }
                    case 24: {
                        expression3 = SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
                        Expression[] expressionArray = new Expression[]{((FilterExpression)expression).getFilter()};
                        ((FunctionCall)expression3).setArguments(expressionArray);
                        booleanExpression = new BooleanExpression(((FilterExpression)expression2).getFilter(), 10, expression3);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown operator " + this.operator));
                    }
                }
                expression3 = new FilterExpression(((FilterExpression)expression2).getBaseExpression(), booleanExpression);
                ExpressionTool.copyLocationInfo(this, booleanExpression);
                ExpressionTool.copyLocationInfo(this, expression3);
                expression3.setParentExpression(this.getParentExpression());
                return ((FilterExpression)expression3).simplify(staticContext);
            }
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.NODE_SEQUENCE, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.NODE_SEQUENCE, false, roleLocator2, staticContext);
        return this;
    }

    public int hashCode() {
        return this.operand0.hashCode() ^ this.operand1.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand0.iterate(xPathContext);
        if ((this.operand0.getSpecialProperties() & 0x20000) == 0) {
            sequenceIterator = new DocumentOrderIterator(sequenceIterator, GlobalOrderComparer.getInstance());
        }
        SequenceIterator sequenceIterator2 = this.operand1.iterate(xPathContext);
        if ((this.operand1.getSpecialProperties() & 0x20000) == 0) {
            sequenceIterator2 = new DocumentOrderIterator(sequenceIterator2, GlobalOrderComparer.getInstance());
        }
        switch (this.operator) {
            case 1: {
                return new UnionEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
            case 23: {
                return new IntersectionEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
            case 24: {
                return new DifferenceEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
        }
        throw new UnsupportedOperationException("Unknown operator in Set Expression");
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        if (this.operator == 1) {
            return this.operand0.effectiveBooleanValue(xPathContext) || this.operand1.effectiveBooleanValue(xPathContext);
        }
        return super.effectiveBooleanValue(xPathContext);
    }
}

