/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.fix.FIXApplicationFactory;
import org.apache.synapse.transport.fix.FIXOutTransportInfo;
import org.apache.synapse.transport.fix.FIXOutgoingMessageHandler;
import org.apache.synapse.transport.fix.FIXSessionFactory;
import org.apache.synapse.transport.fix.FIXUtils;
import quickfix.Acceptor;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.StringField;
import quickfix.field.DeliverToCompID;
import quickfix.field.DeliverToLocationID;
import quickfix.field.DeliverToSubID;
import quickfix.field.OnBehalfOfCompID;
import quickfix.field.OnBehalfOfLocationID;
import quickfix.field.OnBehalfOfSubID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIXTransportSender
extends AbstractTransportSender {
    private FIXSessionFactory sessionFactory;
    private FIXOutgoingMessageHandler messageSender;
    private WorkerPool workerPool;

    public FIXTransportSender() {
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
        this.sessionFactory = FIXSessionFactory.getInstance(new FIXApplicationFactory(cfgCtx));
        this.workerPool = WorkerPoolFactory.getWorkerPool((int)10, (int)20, (int)5, (int)-1, (String)"FIX Sender Worker thread group", (String)"FIX-Worker");
        this.sessionFactory.setSenderThreadPool(this.workerPool);
        this.messageSender = new FIXOutgoingMessageHandler();
        this.messageSender.setSessionFactory(this.sessionFactory);
        this.log.info((Object)"FIX transport sender initialized...");
    }

    public void stop() {
        try {
            this.workerPool.shutdown(10000);
        }
        catch (InterruptedException e) {
            this.log.warn((Object)"Thread interrupted while waiting for worker pool to shut down");
        }
        this.sessionFactory.disposeFIXInitiators();
        super.stop();
    }

    public void sendMessage(MessageContext msgCtx, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to send a FIX message, Message ID:" + msgCtx.getMessageID()));
        }
        Message fixMessage = null;
        String serviceName = FIXUtils.getServiceName(msgCtx);
        String fixApplication = FIXUtils.getFixApplication(msgCtx);
        String sourceSession = FIXUtils.getSourceSession(msgCtx);
        int counter = FIXUtils.getSequenceNumber(msgCtx);
        try {
            fixMessage = FIXUtils.getInstance().createFIXMessage(msgCtx);
        }
        catch (IOException e) {
            this.handleException("Exception occured while creating the FIX message from SOAP Envelope", e);
        }
        if ("acceptor".equals(fixApplication)) {
            if (targetEPR != null) {
                this.sendUsingEPR(targetEPR, serviceName, fixMessage, sourceSession, counter, msgCtx);
            } else if (outTransportInfo != null && outTransportInfo instanceof FIXOutTransportInfo) {
                this.sendUsingTrpOutInfo(outTransportInfo, serviceName, fixMessage, sourceSession, counter);
            }
        } else if ("initiator".equals(fixApplication)) {
            if (this.sendUsingAcceptorSession(serviceName, fixMessage, sourceSession, counter)) {
                return;
            }
            if (targetEPR != null) {
                this.sendUsingEPR(targetEPR, serviceName, fixMessage, sourceSession, counter, msgCtx);
                return;
            }
            this.handleException("Unable to find a session to send the message...");
        } else if (targetEPR != null) {
            this.sendUsingEPR(targetEPR, serviceName, fixMessage, sourceSession, counter, msgCtx);
        } else {
            this.sendUsingAcceptorSession(serviceName, fixMessage, sourceSession, counter);
        }
    }

    private boolean isTargetVald(Map<String, String> fieldValues, SessionID targetSession, boolean beginStrValidation) {
        String beginString = fieldValues.get("BeginString");
        String deliverToCompID = fieldValues.get("DeliverToCompID");
        String deliverToSubID = fieldValues.get("DeliverToSubID");
        String deliverToLocationID = fieldValues.get("DeliverToLocationID");
        if (beginStrValidation && !targetSession.getBeginString().equals(beginString)) {
            return false;
        }
        if (!targetSession.getTargetCompID().equals(deliverToCompID)) {
            return false;
        }
        if (deliverToSubID != null && !deliverToSubID.equals(targetSession.getTargetSubID())) {
            return false;
        }
        return deliverToLocationID == null || deliverToLocationID.equals(targetSession.getTargetLocationID());
    }

    private void prepareToForwardMessage(Message message, Map<String, String> fieldValues) {
        message.getHeader().setField((StringField)new OnBehalfOfCompID(fieldValues.get("SenderCompID")));
        if (fieldValues.get("SenderSubID") != null) {
            message.getHeader().setField((StringField)new OnBehalfOfSubID(fieldValues.get("SenderSubID")));
        }
        if (fieldValues.get("SenderLocationID") != null) {
            message.getHeader().setField((StringField)new OnBehalfOfLocationID(fieldValues.get("SenderLocationID")));
        }
        message.getHeader().removeField(50);
        message.getHeader().removeField(142);
        message.getHeader().removeField(128);
        message.getHeader().removeField(129);
        message.getHeader().removeField(145);
    }

    private void setDeliverToXFields(Message message, String targetEPR) {
        Hashtable properties = BaseUtils.getEPRProperties((String)targetEPR);
        String deliverTo = (String)properties.get("DeliverToCompID");
        if (deliverTo != null) {
            message.getHeader().setField((StringField)new DeliverToCompID(deliverTo));
            deliverTo = (String)properties.get("DeliverToSubID");
            if (deliverTo != null) {
                message.getHeader().setField((StringField)new DeliverToSubID(deliverTo));
            }
            if ((deliverTo = (String)properties.get("DeliverToLocationID")) != null) {
                message.getHeader().setField((StringField)new DeliverToLocationID(deliverTo));
            }
        }
    }

    private void setDeliverToXFields(Message message, Map<String, String> fieldValues) {
        String onBehalf = fieldValues.get("OnBehalfOfCompID");
        if (onBehalf != null) {
            message.getHeader().setField((StringField)new DeliverToCompID(onBehalf));
            onBehalf = fieldValues.get("OnBehalfOfSubID");
            if (onBehalf != null) {
                message.getHeader().setField((StringField)new DeliverToSubID(onBehalf));
            }
            if ((onBehalf = fieldValues.get("OnBehalfOfLocationID")) != null) {
                message.getHeader().setField((StringField)new DeliverToLocationID(onBehalf));
            }
            message.getHeader().removeField(115);
            message.getHeader().removeField(116);
            message.getHeader().removeField(144);
        }
    }

    private void setDeliverToXFields(Message message, AxisService service) {
        Parameter param = service.getParameter("transport.fix.ResponseDeliverToCompID");
        if (param != null) {
            message.getHeader().setField((StringField)new DeliverToCompID(param.getValue().toString()));
            param = service.getParameter("transport.fix.ResponseDeliverToSubID");
            if (param != null) {
                message.getHeader().setField((StringField)new DeliverToSubID(param.getValue().toString()));
            }
            if ((param = service.getParameter("transport.fix.ResponseDeliverToLocationID")) != null) {
                message.getHeader().setField((StringField)new DeliverToLocationID(param.getValue().toString()));
            }
        }
    }

    private boolean sendUsingEPR(String targetEPR, String serviceName, Message fixMessage, String srcSession, int counter, MessageContext msgCtx) throws AxisFault {
        FIXOutTransportInfo fixOut = new FIXOutTransportInfo(targetEPR);
        SessionID sessionID = fixOut.getSessionID();
        Map<String, String> fieldValues = FIXUtils.getMessageForwardingParameters(fixMessage);
        String beginString = fieldValues.get("BeginString");
        String deliverToCompID = fieldValues.get("DeliverToCompID");
        AxisService service = this.cfgCtx.getAxisConfiguration().getService(serviceName);
        if (this.isValidationOn(service) && beginString != null && !beginString.equals(sessionID.getBeginString())) {
            this.handleException("BeginString validation is on. Cannot forward messages to a session with a different BeginString");
        }
        if (deliverToCompID != null) {
            if (!deliverToCompID.equals(sessionID.getTargetCompID())) {
                this.handleException("Cannot forward messages that do not have a valid DeliverToCompID field");
            } else {
                this.prepareToForwardMessage(fixMessage, fieldValues);
                this.setDeliverToXFields(fixMessage, targetEPR);
            }
        }
        if (!Session.doesSessionExist((SessionID)sessionID)) {
            this.sessionFactory.createFIXInitiator(targetEPR, service, sessionID);
        }
        try {
            this.messageSender.sendMessage(fixMessage, sessionID, srcSession, counter, msgCtx, targetEPR);
            return true;
        }
        catch (SessionNotFound e) {
            this.log.error((Object)("Error while sending the FIX message. Session " + sessionID.toString() + " does" + " not exist"), (Throwable)e);
            return false;
        }
    }

    private boolean sendUsingTrpOutInfo(OutTransportInfo trpOutInfo, String serviceName, Message fixMessage, String srcSession, int counter) throws AxisFault {
        FIXOutTransportInfo fixOut = (FIXOutTransportInfo)trpOutInfo;
        SessionID sessionID = fixOut.getSessionID();
        Map<String, String> fieldValues = FIXUtils.getMessageForwardingParameters(fixMessage);
        String beginString = fieldValues.get("BeginString");
        String deliverToCompID = fieldValues.get("DeliverToCompID");
        AxisService service = this.cfgCtx.getAxisConfiguration().getService(serviceName);
        if (this.isValidationOn(service) && beginString != null && !beginString.equals(sessionID.getBeginString())) {
            this.handleException("BeginString validation is on. Cannot forward messages to a session with a different BeginString");
        }
        if (deliverToCompID != null) {
            if (!deliverToCompID.equals(sessionID.getTargetCompID())) {
                this.handleException("Cannot forward messages that do not have a valid DeliverToCompID field");
            } else {
                this.prepareToForwardMessage(fixMessage, fieldValues);
                this.setDeliverToXFields(fixMessage, service);
            }
        } else {
            this.setDeliverToXFields(fixMessage, fieldValues);
        }
        try {
            this.messageSender.sendMessage(fixMessage, sessionID, srcSession, counter, null, null);
            return true;
        }
        catch (SessionNotFound e) {
            this.log.error((Object)("Error while sending the FIX message. Session " + sessionID.toString() + " does" + " not exist"), (Throwable)e);
            return false;
        }
    }

    private boolean sendUsingAcceptorSession(String serviceName, Message fixMessage, String srcSession, int counter) throws AxisFault {
        Map<String, String> fieldValues = FIXUtils.getMessageForwardingParameters(fixMessage);
        String deliverToCompID = fieldValues.get("DeliverToCompID");
        Acceptor acceptor = this.sessionFactory.getAccepter(serviceName);
        SessionID sessionID = null;
        AxisService service = this.cfgCtx.getAxisConfiguration().getService(serviceName);
        if (acceptor != null) {
            ArrayList sessions = acceptor.getSessions();
            if (sessions.size() == 1) {
                sessionID = (SessionID)sessions.get(0);
                if (deliverToCompID != null && !this.isTargetVald(fieldValues, sessionID, this.isValidationOn(service))) {
                    sessionID = null;
                }
            } else if (sessions.size() > 1 && deliverToCompID != null) {
                for (int i = 0; i < sessions.size() && !this.isTargetVald(fieldValues, sessionID = (SessionID)sessions.get(i), this.isValidationOn(service)); ++i) {
                }
            }
        }
        if (sessionID != null) {
            FIXOutTransportInfo fixOutInfo = new FIXOutTransportInfo(sessionID);
            return this.sendUsingTrpOutInfo(fixOutInfo, serviceName, fixMessage, srcSession, counter);
        }
        return false;
    }

    private boolean isValidationOn(AxisService service) {
        Parameter validationParam = service.getParameter("transport.fix.BeginStringValidation");
        return validationParam != null && "true".equals(validationParam.getValue().toString());
    }

    public void logOutIncomingSession(SessionID sessionID) {
        this.messageSender.cleanUpMessages(sessionID.toString());
    }
}

