/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HttpTransportProperties;

public class LoadbalanceFailoverClient {
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String DEFAULT_CLIENT_REPO = "client_repo";

    public static void main(String[] args) {
        String mode = System.getProperty("mode");
        try {
            if (mode != null) {
                if (mode.equalsIgnoreCase("session")) {
                    new LoadbalanceFailoverClient().sessionfullClient();
                } else if (mode.equalsIgnoreCase("simple") || mode.equalsIgnoreCase("")) {
                    new LoadbalanceFailoverClient().sessionlessClient();
                }
            } else {
                new LoadbalanceFailoverClient().sessionlessClient();
            }
        }
        catch (AxisFault axisFault) {
            System.out.println(axisFault.getMessage());
        }
    }

    public String sessionlessClient() throws AxisFault {
        String synapsePort = "8280";
        int iterations = 100;
        boolean infinite = true;
        String pPort = LoadbalanceFailoverClient.getProperty("port", synapsePort);
        String pIterations = LoadbalanceFailoverClient.getProperty("i", null);
        String addUrl = LoadbalanceFailoverClient.getProperty("addurl", null);
        String trpUrl = LoadbalanceFailoverClient.getProperty("trpurl", null);
        String prxUrl = LoadbalanceFailoverClient.getProperty("prxurl", null);
        String sleep = LoadbalanceFailoverClient.getProperty("sleep", null);
        long sleepTime = -1L;
        if (sleep != null) {
            try {
                sleepTime = Long.parseLong(sleep);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (pPort != null) {
            try {
                Integer.parseInt(pPort);
                synapsePort = pPort;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (pIterations != null) {
            try {
                iterations = Integer.parseInt(pIterations);
                if (iterations != -1) {
                    infinite = false;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement value = fac.createOMElement("Value", null);
        value.setText("Sample string");
        Options options = new Options();
        options.setTo(new EndpointReference("http://localhost:" + synapsePort + "/services/LBService1"));
        options.setAction("urn:sampleOperation");
        String repoLocationProperty = System.getProperty("repository");
        String repo = repoLocationProperty != null ? repoLocationProperty : DEFAULT_CLIENT_REPO;
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
        ServiceClient client = new ServiceClient(configContext, null);
        long timeout = Integer.parseInt(LoadbalanceFailoverClient.getProperty("timeout", "10000000"));
        System.out.println("timeout=" + timeout);
        options.setTimeOutInMilliSeconds(timeout);
        if (addUrl != null && !"null".equals(addUrl)) {
            client.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
        }
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)trpUrl);
        } else {
            client.engageModule("addressing");
        }
        if (prxUrl != null && !"null".equals(prxUrl)) {
            HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
            try {
                URL url = new URL(prxUrl);
                proxyProperties.setProxyName(url.getHost());
                proxyProperties.setProxyPort(url.getPort());
                proxyProperties.setUserName("");
                proxyProperties.setPassWord("");
                proxyProperties.setDomain("");
                options.setProperty("PROXY", (Object)proxyProperties);
            }
            catch (MalformedURLException e) {
                throw new AxisFault("Error creating proxy URL", (Throwable)e);
            }
        }
        client.setOptions(options);
        String testString = "";
        long i = 0L;
        while (i < (long)iterations || infinite) {
            if (sleepTime != -1L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            client.getOptions().setManageSession(true);
            OMElement responseElement = client.sendReceive(value);
            String response = responseElement.getText();
            System.out.println("Request: " + ++i + " ==> " + response);
            testString = testString.concat(":" + i + ">" + response + ":");
        }
        return testString;
    }

    private void sessionfullClient() {
        String synapsePort = "8280";
        int iterations = 100;
        boolean infinite = true;
        String pPort = LoadbalanceFailoverClient.getProperty("port", synapsePort);
        String pIterations = LoadbalanceFailoverClient.getProperty("i", null);
        String addUrl = LoadbalanceFailoverClient.getProperty("addurl", null);
        String trpUrl = LoadbalanceFailoverClient.getProperty("trpurl", null);
        String prxUrl = LoadbalanceFailoverClient.getProperty("prxurl", null);
        String sleep = LoadbalanceFailoverClient.getProperty("sleep", null);
        String session = LoadbalanceFailoverClient.getProperty("session", null);
        long sleepTime = -1L;
        if (sleep != null) {
            try {
                sleepTime = Long.parseLong(sleep);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (pPort != null) {
            try {
                Integer.parseInt(pPort);
                synapsePort = pPort;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (pIterations != null) {
            try {
                iterations = Integer.parseInt(pIterations);
                if (iterations != -1) {
                    infinite = false;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Options options = new Options();
        options.setTo(new EndpointReference("http://localhost:" + synapsePort + "/services/LBService1"));
        options.setAction("urn:sampleOperation");
        options.setTimeOutInMilliSeconds(10000000L);
        try {
            boolean httpSession;
            SOAPEnvelope env1 = this.buildSoapEnvelope("c1", "v1");
            SOAPEnvelope env2 = this.buildSoapEnvelope("c2", "v1");
            SOAPEnvelope env3 = this.buildSoapEnvelope("c3", "v1");
            SOAPEnvelope[] envelopes = new SOAPEnvelope[]{env1, env2, env3};
            String repoLocationProperty = System.getProperty("repository");
            String repo = repoLocationProperty != null ? repoLocationProperty : DEFAULT_CLIENT_REPO;
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            ServiceClient client = new ServiceClient(configContext, null);
            if (addUrl != null && !"null".equals(addUrl)) {
                client.engageModule("addressing");
                options.setTo(new EndpointReference(addUrl));
            }
            if (trpUrl != null && !"null".equals(trpUrl)) {
                options.setProperty("TransportURL", (Object)trpUrl);
            } else {
                client.engageModule("addressing");
            }
            if (prxUrl != null && !"null".equals(prxUrl)) {
                HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
                try {
                    URL url = new URL(prxUrl);
                    proxyProperties.setProxyName(url.getHost());
                    proxyProperties.setProxyPort(url.getPort());
                    proxyProperties.setUserName("");
                    proxyProperties.setPassWord("");
                    proxyProperties.setDomain("");
                    options.setProperty("PROXY", (Object)proxyProperties);
                }
                catch (MalformedURLException e) {
                    throw new AxisFault("Error creating proxy URL", (Throwable)e);
                }
            }
            client.setOptions(options);
            int i = 0;
            String[] cookies = new String[3];
            boolean bl = httpSession = session != null && "http".equals(session);
            while (i < iterations || infinite) {
                ++i;
                if (sleepTime != -1L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
                MessageContext messageContext = new MessageContext();
                int sessionNumber = this.getSessionTurn(envelopes.length);
                messageContext.setEnvelope(envelopes[sessionNumber]);
                int cookieNumber = this.getSessionTurn(cookies.length);
                String cookie = cookies[cookieNumber];
                if (httpSession) {
                    this.setSessionID(messageContext, cookie);
                }
                try {
                    OperationClient op = client.createClient(ServiceClient.ANON_OUT_IN_OP);
                    op.addMessageContext(messageContext);
                    op.execute(true);
                    MessageContext responseContext = op.getMessageContext("In");
                    String receivedCookie = this.extractSessionID(responseContext);
                    String receivedSetCookie = this.getSetCookieHeader(responseContext);
                    if (httpSession && receivedSetCookie != null && !"".equals(receivedSetCookie)) {
                        cookies[cookieNumber] = receivedCookie;
                    }
                    SOAPEnvelope responseEnvelope = responseContext.getEnvelope();
                    OMElement vElement = responseEnvelope.getBody().getFirstChildWithName(new QName("Value"));
                    System.out.println("Request: " + i + " with Session ID: " + (httpSession ? cookie : Integer.valueOf(sessionNumber)) + " ---- " + "Response : with  " + (httpSession && receivedCookie != null ? (receivedSetCookie != null ? receivedSetCookie : receivedCookie) : " ") + " " + vElement.getText());
                }
                catch (AxisFault axisFault) {
                    System.out.println("Request with session id " + (httpSession ? cookie : Integer.valueOf(sessionNumber)) + " " + "- Get a Fault : " + axisFault.getMessage());
                }
            }
        }
        catch (AxisFault axisFault) {
            System.out.println(axisFault.getMessage());
        }
    }

    private int getSessionTurn(int max) {
        Random random = new Random();
        return random.nextInt(max);
    }

    protected String extractSessionID(MessageContext axis2MessageContext) {
        Object o = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map headerMap = (Map)o;
            String cookie = (String)headerMap.get(SET_COOKIE);
            cookie = cookie == null ? (String)headerMap.get(COOKIE) : cookie.split(";")[0];
            return cookie;
        }
        return null;
    }

    protected String getSetCookieHeader(MessageContext axis2MessageContext) {
        Object o = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map headerMap = (Map)o;
            return (String)headerMap.get(SET_COOKIE);
        }
        return null;
    }

    protected void setSessionID(MessageContext axis2MessageContext, String value) {
        if (value == null) {
            return;
        }
        HashMap<String, String> map = (HashMap<String, String>)axis2MessageContext.getProperty("HTTP_HEADERS");
        if (map == null) {
            map = new HashMap<String, String>();
            axis2MessageContext.setProperty("HTTP_HEADERS", map);
        }
        map.put(COOKIE, value);
    }

    private SOAPEnvelope buildSoapEnvelope(String clientID, String value) {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope envelope = soapFactory.createSOAPEnvelope();
        SOAPHeader header = soapFactory.createSOAPHeader();
        envelope.addChild((OMNode)header);
        OMNamespace synNamespace = soapFactory.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
        OMElement clientIDElement = soapFactory.createOMElement("ClientID", synNamespace);
        clientIDElement.setText(clientID);
        header.addChild((OMNode)clientIDElement);
        SOAPBody body = soapFactory.createSOAPBody();
        envelope.addChild((OMNode)body);
        OMElement valueElement = soapFactory.createOMElement("Value", null);
        valueElement.setText(value);
        body.addChild((OMNode)valueElement);
        return envelope;
    }

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }
}

