/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import java.net.URL;
import java.util.Date;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;

public class FIXClient {
    public static void main(String[] args) {
        try {
            FIXClient.executeClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void executeClient() throws Exception {
        ServiceClient serviceClient;
        Options options = new Options();
        ConfigurationContext configContext = null;
        String symbol = FIXClient.getProperty("symbol", "IBM");
        String mode = FIXClient.getProperty("mode", "buy");
        String addUrl = FIXClient.getProperty("addurl", null);
        String trpUrl = FIXClient.getProperty("trpurl", null);
        String prxUrl = FIXClient.getProperty("prxurl", null);
        String repo = FIXClient.getProperty("repository", "client_repo");
        String qty = FIXClient.getProperty("qty", "1");
        String side = "1";
        if (mode.equals("sell")) {
            side = "2";
        }
        if (repo != null && !"null".equals(repo)) {
            configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            serviceClient = new ServiceClient(configContext, null);
        } else {
            serviceClient = new ServiceClient();
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement message = factory.createOMElement("message", null);
        message.addChild((OMNode)FIXClient.getHeader(factory));
        message.addChild((OMNode)FIXClient.getBody(factory, symbol, side, qty));
        message.addChild((OMNode)factory.createOMElement("trailer", null));
        if (addUrl != null && !"null".equals(addUrl)) {
            serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
        }
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)trpUrl);
        }
        if (prxUrl != null && !"null".equals(prxUrl)) {
            HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
            URL url = new URL(prxUrl);
            proxyProperties.setProxyName(url.getHost());
            proxyProperties.setProxyPort(url.getPort());
            proxyProperties.setUserName("");
            proxyProperties.setPassWord("");
            proxyProperties.setDomain("");
            options.setProperty("PROXY", (Object)proxyProperties);
        }
        options.setAction("urn:mediate");
        serviceClient.setOptions(options);
        OMElement response = serviceClient.sendReceive(message);
        Thread.sleep(5000L);
        System.out.println("Response Received: " + response.toString());
        try {
            if (configContext != null) {
                configContext.terminate();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    private static OMElement getHeader(OMFactory factory) {
        OMElement header = factory.createOMElement("header", null);
        OMElement msgType = factory.createOMElement("field", null);
        msgType.addAttribute(factory.createOMAttribute("id", null, "35"));
        factory.createOMText((OMContainer)msgType, "D");
        header.addChild((OMNode)msgType);
        OMElement sendingTime = factory.createOMElement("field", null);
        sendingTime.addAttribute(factory.createOMAttribute("id", null, "52"));
        factory.createOMText((OMContainer)sendingTime, new Date().toString());
        header.addChild((OMNode)sendingTime);
        return header;
    }

    private static OMElement getBody(OMFactory factory, String text, String mode, String qtyValue) {
        OMElement body = factory.createOMElement("body", null);
        OMElement clordID = factory.createOMElement("field", null);
        clordID.addAttribute(factory.createOMAttribute("id", null, "11"));
        factory.createOMText((OMContainer)clordID, "122333");
        body.addChild((OMNode)clordID);
        OMElement handleIns = factory.createOMElement("field", null);
        handleIns.addAttribute(factory.createOMAttribute("id", null, "21"));
        factory.createOMText((OMContainer)handleIns, "1");
        body.addChild((OMNode)handleIns);
        OMElement qty = factory.createOMElement("field", null);
        qty.addAttribute(factory.createOMAttribute("id", null, "38"));
        factory.createOMText((OMContainer)qty, qtyValue);
        body.addChild((OMNode)qty);
        OMElement ordType = factory.createOMElement("field", null);
        ordType.addAttribute(factory.createOMAttribute("id", null, "40"));
        factory.createOMText((OMContainer)ordType, "1");
        body.addChild((OMNode)ordType);
        OMElement side = factory.createOMElement("field", null);
        side.addAttribute(factory.createOMAttribute("id", null, "54"));
        factory.createOMText((OMContainer)side, mode);
        body.addChild((OMNode)side);
        OMElement symbol = factory.createOMElement("field", null);
        symbol.addAttribute(factory.createOMAttribute("id", null, "55"));
        factory.createOMText((OMContainer)symbol, text);
        body.addChild((OMNode)symbol);
        OMElement timeInForce = factory.createOMElement("field", null);
        timeInForce.addAttribute(factory.createOMAttribute("id", null, "59"));
        factory.createOMText((OMContainer)timeInForce, "0");
        body.addChild((OMNode)timeInForce);
        return body;
    }
}

