/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.util.Map;
import java.util.TreeMap;

public final class FileSystemOptions
implements Cloneable {
    private Map options = new TreeMap();

    void setOption(Class fileSystemClass, String name, Object value) {
        this.options.put(new FileSystemOptionKey(fileSystemClass, name), value);
    }

    Object getOption(Class fileSystemClass, String name) {
        FileSystemOptionKey key = new FileSystemOptionKey(fileSystemClass, name);
        return this.options.get(key);
    }

    boolean hasOption(Class fileSystemClass, String name) {
        FileSystemOptionKey key = new FileSystemOptionKey(fileSystemClass, name);
        return this.options.containsKey(key);
    }

    public int compareTo(FileSystemOptions other) {
        int hashFk;
        int propsFkSz;
        if (this == other) {
            return 0;
        }
        int propsSz = this.options == null ? 0 : this.options.size();
        int n = propsFkSz = other.options == null ? 0 : other.options.size();
        if (propsSz < propsFkSz) {
            return -1;
        }
        if (propsSz > propsFkSz) {
            return 1;
        }
        if (propsSz == 0) {
            return 0;
        }
        int hash = ((Object)this.options).hashCode();
        if (hash < (hashFk = ((Object)other.options).hashCode())) {
            return -1;
        }
        if (hash > hashFk) {
            return 1;
        }
        return 0;
    }

    public Object clone() {
        FileSystemOptions clone = new FileSystemOptions();
        clone.options = new TreeMap(this.options);
        return clone;
    }

    private static final class FileSystemOptionKey
    implements Comparable {
        private static final int HASH = 29;
        private final Class fileSystemClass;
        private final String name;

        private FileSystemOptionKey(Class fileSystemClass, String name) {
            this.fileSystemClass = fileSystemClass;
            this.name = name;
        }

        public int compareTo(Object o) {
            FileSystemOptionKey k = (FileSystemOptionKey)o;
            int ret = this.fileSystemClass.getName().compareTo(k.fileSystemClass.getName());
            if (ret != 0) {
                return ret;
            }
            return this.name.compareTo(k.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileSystemOptionKey that = (FileSystemOptionKey)o;
            if (!this.fileSystemClass.equals(that.fileSystemClass)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.fileSystemClass.hashCode();
            result = 29 * result + this.name.hashCode();
            return result;
        }
    }
}

