/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.MessageStoreViewMBean;
import org.apache.synapse.message.store.StorableMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStoreView
implements MessageStoreViewMBean {
    private String messageStoreName;
    private MessageStore messageStore;
    private static final Log log = LogFactory.getLog(MessageStoreView.class);

    public MessageStoreView(String name, MessageStore messageStore) {
        this.messageStoreName = name;
        this.messageStore = messageStore;
    }

    @Override
    public void resendAll() {
        List<StorableMessage> list = this.messageStore.getAllMessages();
        for (int i = 0; i < list.size(); ++i) {
            StorableMessage m = list.get(i);
            while (!m.getEndpoint().readyToSend()) {
            }
            m.getEndpoint().send(m.getMessageContext());
        }
        log.info((Object)("All Messages in Message Store " + this.messageStoreName + " were resent"));
    }

    @Override
    public void deleteAll() {
        this.messageStore.unstoreAll();
        log.info((Object)("All messages in Message Store" + this.messageStoreName + " were deleted"));
    }

    @Override
    public List<String> getMessageIds() {
        ArrayList<String> returnList = new ArrayList<String>();
        List<StorableMessage> list = this.messageStore.getAllMessages();
        for (StorableMessage m : list) {
            returnList.add(m.getMessageContext().getMessageID());
        }
        return returnList;
    }

    @Override
    public boolean resend(String messageID) {
        StorableMessage m = this.messageStore.getMessage(messageID);
        if (m != null) {
            if (m.getEndpoint().readyToSend()) {
                m.getEndpoint().send(m.getMessageContext());
                log.info((Object)("Message with ID " + messageID + " resent via the Endpoint" + m.getEndpoint().getName()));
                return true;
            }
            log.info((Object)("Message with ID " + messageID + " unable resent via the Endpoint" + m.getEndpoint().getName()));
        }
        return false;
    }

    @Override
    public void delete(String messageID) {
        StorableMessage m;
        if (messageID != null && (m = this.messageStore.unstore(messageID)) != null) {
            log.info((Object)("Message with ID :" + messageID + " removed from the MessageStore"));
        }
    }

    @Override
    public String getEnvelope(String messageID) {
        StorableMessage m;
        if (messageID != null && (m = this.messageStore.getMessage(messageID)) != null) {
            return m.getMessageContext().getEnvelope().toString();
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.messageStore.getSize();
    }
}

