/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

public class HeaderMediator
extends AbstractMediator {
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    private QName qName = null;
    private String value = null;
    private int action = 0;
    private SynapseXPath expression = null;

    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Header mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (this.action == 0) {
            String value;
            String string = value = this.getExpression() == null ? this.getValue() : this.expression.stringValueOf(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Set SOAP header : " + this.qName + " to : " + value);
            }
            if (this.qName.getNamespaceURI() == null || "".equals(this.qName.getNamespaceURI())) {
                if ("To".equals(this.qName.getLocalPart())) {
                    synCtx.setTo(new EndpointReference(value));
                } else if ("From".equals(this.qName.getLocalPart())) {
                    synCtx.setFrom(new EndpointReference(value));
                } else if ("Action".equals(this.qName.getLocalPart())) {
                    synCtx.setWSAAction(value);
                } else if ("FaultTo".equals(this.qName.getLocalPart())) {
                    synCtx.setFaultTo(new EndpointReference(value));
                } else if ("ReplyTo".equals(this.qName.getLocalPart())) {
                    synCtx.setReplyTo(new EndpointReference(value));
                } else if ("RelatesTo".equals(this.qName.getLocalPart())) {
                    synCtx.setRelatesTo(new RelatesTo[]{new RelatesTo(value)});
                } else {
                    this.addCustomHeader(synCtx, value);
                }
            } else {
                this.addCustomHeader(synCtx, value);
            }
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Removing SOAP Header : " + this.qName);
            }
            if (this.qName.getNamespaceURI() == null || "".equals(this.qName.getNamespaceURI())) {
                if ("To".equals(this.qName.getLocalPart())) {
                    synCtx.setTo(null);
                } else if ("From".equals(this.qName.getLocalPart())) {
                    synCtx.setFrom(null);
                } else if ("Action".equals(this.qName.getLocalPart())) {
                    synCtx.setWSAAction(null);
                } else if ("FaultTo".equals(this.qName.getLocalPart())) {
                    synCtx.setFaultTo(null);
                } else if ("ReplyTo".equals(this.qName.getLocalPart())) {
                    synCtx.setReplyTo(null);
                } else if ("RelatesTo".equals(this.qName.getLocalPart())) {
                    synCtx.setRelatesTo(null);
                } else {
                    SOAPHeader header;
                    SOAPEnvelope envelope = synCtx.getEnvelope();
                    if (envelope != null && (header = envelope.getHeader()) != null) {
                        this.removeFromHeaderList(header.getHeaderBlocksWithNSURI(""));
                    }
                }
            } else {
                SOAPHeader header;
                SOAPEnvelope envelope = synCtx.getEnvelope();
                if (envelope != null && (header = envelope.getHeader()) != null) {
                    this.removeFromHeaderList(header.getHeaderBlocksWithNSURI(this.qName.getNamespaceURI()));
                }
            }
        }
        synLog.traceOrDebug("End : Header mediator");
        return true;
    }

    private void addCustomHeader(MessageContext synCtx, String value) {
        SOAPEnvelope env = synCtx.getEnvelope();
        if (env == null) {
            return;
        }
        SOAPFactory fac = (SOAPFactory)env.getOMFactory();
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = fac.createSOAPHeader(env);
        }
        SOAPHeaderBlock hb = header.addHeaderBlock(this.qName.getLocalPart(), fac.createOMNamespace(this.qName.getNamespaceURI(), this.qName.getPrefix()));
        hb.setText(value);
    }

    private void removeFromHeaderList(List headersList) {
        if (headersList == null || headersList.isEmpty()) {
            return;
        }
        for (Object o : headersList) {
            OMElement omElem;
            if (o instanceof SOAPHeaderBlock) {
                SOAPHeaderBlock header = (SOAPHeaderBlock)o;
                if (!header.getLocalName().equals(this.qName.getLocalPart())) continue;
                header.detach();
                continue;
            }
            if (!(o instanceof OMElement) || !(omElem = (OMElement)o).getLocalName().equals(this.qName.getLocalPart())) continue;
            omElem.detach();
        }
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName qName) {
        this.qName = qName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }
}

