/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.dispatch.AbstractDispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;

public class SoapSessionDispatcher
extends AbstractDispatcher {
    private static final QName QNAME_SERVICE_GROUP_ID = new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2");

    public SessionInformation getSession(MessageContext synCtx) {
        return SALSessions.getInstance().getSession(this.extractSessionID((OMElement)synCtx.getEnvelope().getHeader(), QNAME_SERVICE_GROUP_ID));
    }

    public void updateSession(MessageContext synCtx) {
        SOAPHeader header = synCtx.getEnvelope().getHeader();
        if (header != null) {
            OMElement replyTo = header.getFirstChildWithName(AddressingConstants.Final.QNAME_WSA_REPLY_TO);
            if (replyTo != null) {
                OMElement referenceParameters = replyTo.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters", "wsa"));
                if (referenceParameters != null) {
                    SALSessions.getInstance().updateSession(synCtx, this.extractSessionID(referenceParameters, QNAME_SERVICE_GROUP_ID));
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Couldn't find the WSA ReferenceParameters in the Reply-To header to retrieve the ServiceQroupId");
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Couldn't find the WSA Reply-To header to retrieve the ServiceQroupId");
            }
        }
    }

    public void unbind(MessageContext synCtx) {
        SALSessions.getInstance().removeSession(this.extractSessionID((OMElement)synCtx.getEnvelope().getHeader(), QNAME_SERVICE_GROUP_ID));
    }

    public boolean isServerInitiatedSession() {
        return true;
    }

    public void removeSessionID(MessageContext syCtx) {
        this.removeSessionID((OMElement)syCtx.getEnvelope().getHeader(), QNAME_SERVICE_GROUP_ID);
    }
}

