/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.util.xpath.SynapseXPath;

public class ResolvingEndpoint
extends AbstractEndpoint {
    private SynapseXPath keyExpression = null;

    public void send(MessageContext synCtx) {
        String key = this.keyExpression.stringValueOf(synCtx);
        Endpoint ep = this.loadAndInitEndpoint(((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext(), key);
        if (ep != null) {
            ep.send(synCtx);
        } else {
            this.informFailure(synCtx, 305100, "Couldn't find the endpoint with the key : " + key);
        }
    }

    private Endpoint loadAndInitEndpoint(ConfigurationContext cc, String key) {
        Parameter parameter = cc.getAxisConfiguration().getParameter("synapse.config");
        Parameter synEnvParameter = cc.getAxisConfiguration().getParameter("synapse.env");
        if (parameter.getValue() instanceof SynapseConfiguration && synEnvParameter.getValue() instanceof SynapseEnvironment) {
            Endpoint ep;
            SynapseConfiguration synCfg = (SynapseConfiguration)parameter.getValue();
            SynapseEnvironment synapseEnvironment = (SynapseEnvironment)synEnvParameter.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading real endpoint with key : " + key));
            }
            if ((ep = synCfg.getEndpoint(key)) != null && !ep.isInitialized()) {
                ep.init(synapseEnvironment);
            }
            return ep;
        }
        return null;
    }

    public SynapseXPath getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(SynapseXPath keyExpression) {
        this.keyExpression = keyExpression;
    }
}

