/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;

public class FailoverEndpoint
extends AbstractEndpoint {
    private Endpoint currentEndpoint = null;

    public void send(MessageContext synCtx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Failover Endpoint : " + this.getName()));
        }
        boolean isARetry = false;
        if (synCtx.getProperty("last_endpoint") == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this + " Building the SoapEnvelope"));
            }
            synCtx.getEnvelope().build();
        } else {
            isARetry = true;
        }
        if (this.getChildren().isEmpty()) {
            this.informFailure(synCtx, 303000, "FailoverLoadbalance endpoint : " + this.getName() + " - no child endpoints");
            return;
        }
        if (this.currentEndpoint == null) {
            this.currentEndpoint = this.getChildren().get(0);
        }
        if (this.currentEndpoint.readyToSend()) {
            if (isARetry && this.metricsMBean != null) {
                this.metricsMBean.reportSendingFault(304100);
            }
            synCtx.pushFaultHandler(this);
            this.currentEndpoint.send(synCtx);
        } else {
            boolean foundEndpoint = false;
            for (Endpoint endpoint : this.getChildren()) {
                if (!endpoint.readyToSend()) continue;
                foundEndpoint = true;
                this.currentEndpoint = endpoint;
                if (isARetry && this.metricsMBean != null) {
                    this.metricsMBean.reportSendingFault(304100);
                }
                synCtx.pushFaultHandler(this);
                this.currentEndpoint.send(synCtx);
                break;
            }
            if (!foundEndpoint) {
                String msg = "Failover endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - no ready child endpoints";
                this.log.warn((Object)msg);
                this.informFailure(synCtx, 303000, msg);
            }
        }
    }

    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        this.logOnChildEndpointFail(endpoint, synMessageContext);
        if (!((AbstractEndpoint)endpoint).isRetryDisabled(synMessageContext)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this + " Retry Attempt for Request with [Message ID : " + synMessageContext.getMessageID() + "], [To : " + synMessageContext.getTo() + "]"));
            }
            this.send(synMessageContext);
        } else {
            String msg = "Failover endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - one of the child endpoints encounterd a non-retry error, " + "not sending message to another endpoint";
            this.log.warn((Object)msg);
            this.informFailure(synMessageContext, 303000, msg);
        }
    }

    public boolean readyToSend() {
        for (Endpoint endpoint : this.getChildren()) {
            if (!endpoint.readyToSend()) continue;
            this.currentEndpoint = endpoint;
            return true;
        }
        return false;
    }
}

