/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.ProxyServiceFactory;
import org.apache.synapse.config.xml.ProxyServiceSerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;

public class ProxyServiceDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(ProxyServiceDeployer.class);

    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProxyService Deployment from file : " + fileName + " : Started"));
        }
        try {
            ProxyService proxy = ProxyServiceFactory.createProxy(artifactConfig, properties);
            if (proxy != null) {
                proxy.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ProxyService named '" + proxy.getName() + "' has been built from the file " + fileName));
                }
                this.initializeProxy(proxy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the ProxyService : " + proxy.getName()));
                }
                proxy.buildAxisService(this.getSynapseConfiguration(), this.getSynapseConfiguration().getAxisConfiguration());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Started the ProxyService : " + proxy.getName()));
                }
                this.getSynapseConfiguration().addProxyService(proxy.getName(), proxy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ProxyService Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("ProxyService named '" + proxy.getName() + "' has been deployed from file : " + fileName));
                return proxy.getName();
            }
            this.handleSynapseArtifactDeploymentError("ProxyService Deployment Failed. The artifact described in the file " + fileName + " is not a ProxyService");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("ProxyService Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProxyService Update from file : " + fileName + " : Started"));
        }
        try {
            ProxyService proxy = ProxyServiceFactory.createProxy(artifactConfig, properties);
            if (proxy != null) {
                proxy.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ProxyService named '" + proxy.getName() + "' has been built from the file " + fileName));
                }
                this.initializeProxy(proxy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the ProxyService : " + proxy.getName()));
                }
                proxy.stop(this.getSynapseConfiguration());
                this.getSynapseConfiguration().removeProxyService(existingArtifactName);
                if (!existingArtifactName.equals(proxy.getName())) {
                    log.info((Object)("ProxyService named " + existingArtifactName + " has been Undeployed"));
                }
                proxy.buildAxisService(this.getSynapseConfiguration(), this.getSynapseConfiguration().getAxisConfiguration());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Started the ProxyService : " + proxy.getName()));
                }
                this.getSynapseConfiguration().addProxyService(proxy.getName(), proxy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ProxyService " + (existingArtifactName.equals(proxy.getName()) ? "update" : "deployment") + " from file : " + fileName + " : Completed"));
                }
                log.info((Object)("ProxyService named '" + proxy.getName() + "' has been " + (existingArtifactName.equals(proxy.getName()) ? "update" : "deployed") + " from file : " + fileName));
                return proxy.getName();
            }
            this.handleSynapseArtifactDeploymentError("ProxyService Update Failed. The artifact described in the file " + fileName + " is not a ProxyService");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("ProxyService Update from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProxyService Undeployment of the proxy named : " + artifactName + " : Started"));
        }
        try {
            ProxyService proxy = this.getSynapseConfiguration().getProxyService(artifactName);
            if (proxy != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Stopping the ProxyService named : " + artifactName));
                }
                proxy.stop(this.getSynapseConfiguration());
                this.getSynapseConfiguration().removeProxyService(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ProxyService Undeployment of the proxy named : " + artifactName + " : Completed"));
                }
                log.info((Object)("ProxyService named '" + proxy.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Proxy service " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("ProxyService Undeployement of proxy named : " + artifactName + " : Failed", e);
        }
    }

    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the ProxyService with name : " + artifactName + " : Started"));
        }
        try {
            ProxyService proxy = this.getSynapseConfiguration().getProxyService(artifactName);
            OMElement proxyElem = ProxyServiceSerializer.serializeProxy(null, proxy);
            if (proxy.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "proxy-services" + File.separator + proxy.getFileName();
                this.writeToFile(proxyElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the ProxyService with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("ProxyService named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the ProxyService named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the ProxyService named '" + artifactName + "' has failed", e);
        }
    }

    private void initializeProxy(ProxyService proxy) throws DeploymentException {
        if (proxy.getTargetInLineEndpoint() != null) {
            proxy.getTargetInLineEndpoint().init(this.getSynapseEnvironment());
        }
        if (proxy.getTargetInLineInSequence() != null) {
            proxy.getTargetInLineInSequence().init(this.getSynapseEnvironment());
        }
        if (proxy.getTargetInLineOutSequence() != null) {
            proxy.getTargetInLineOutSequence().init(this.getSynapseEnvironment());
        }
        if (proxy.getTargetInLineFaultSequence() != null) {
            proxy.getTargetInLineFaultSequence().init(this.getSynapseEnvironment());
        }
    }
}

