/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.ResolvingEndpoint;
import org.jaxen.JaxenException;

public class ResolvingEndpointFactory
extends EndpointFactory {
    private static ResolvingEndpointFactory instance = new ResolvingEndpointFactory();
    private static final QName ATTR_KEY_EXPRESSION = new QName("key-expression");

    private ResolvingEndpointFactory() {
    }

    public static ResolvingEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        ResolvingEndpoint resolvingEndpoint = new ResolvingEndpoint();
        String name = epConfig.getAttributeValue(new QName("name"));
        if (name != null) {
            resolvingEndpoint.setName(name);
        }
        try {
            resolvingEndpoint.setKeyExpression(SynapseXPathFactory.getSynapseXPath(epConfig, ATTR_KEY_EXPRESSION));
        }
        catch (JaxenException e) {
            ResolvingEndpointFactory.handleException("Couldn't build the ResolvingEndpoint, unable to set the key-expression XPath", (Exception)((Object)e));
        }
        this.processProperties(resolvingEndpoint, epConfig);
        return resolvingEndpoint;
    }
}

