/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.clustering.Member;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;

public class LoadbalanceEndpointSerializer
extends EndpointSerializer {
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof LoadbalanceEndpoint)) {
            this.handleException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        LoadbalanceEndpoint loadbalanceEndpoint = (LoadbalanceEndpoint)endpoint;
        this.serializeProperties(loadbalanceEndpoint, endpointElement);
        this.serializeCommonAttributes(endpoint, endpointElement);
        OMElement loadbalanceElement = this.fac.createOMElement("loadbalance", SynapseConstants.SYNAPSE_OMNAMESPACE);
        endpointElement.addChild((OMNode)loadbalanceElement);
        loadbalanceElement.addAttribute("algorithm", loadbalanceEndpoint.getAlgorithm().getClass().getName(), null);
        if (!loadbalanceEndpoint.isFailover()) {
            loadbalanceElement.addAttribute("failover", "false", null);
        }
        if (loadbalanceEndpoint.getChildren() != null) {
            for (Endpoint childEndpoint : loadbalanceEndpoint.getChildren()) {
                loadbalanceElement.addChild((OMNode)EndpointSerializer.getElementFromEndpoint(childEndpoint));
            }
        } else {
            for (Member member : loadbalanceEndpoint.getMembers()) {
                OMElement memberEle = this.fac.createOMElement("member", SynapseConstants.SYNAPSE_OMNAMESPACE, (OMContainer)loadbalanceElement);
                memberEle.addAttribute(this.fac.createOMAttribute("hostName", null, member.getHostName()));
                memberEle.addAttribute(this.fac.createOMAttribute("httpPort", null, String.valueOf(member.getHttpPort())));
                memberEle.addAttribute(this.fac.createOMAttribute("httpsPort", null, String.valueOf(member.getHttpsPort())));
                loadbalanceElement.addChild((OMNode)memberEle);
            }
        }
        return endpointElement;
    }
}

