/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointFactory;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;

public class AddressEndpointFactory
extends DefaultEndpointFactory {
    private static AddressEndpointFactory instance = new AddressEndpointFactory();

    private AddressEndpointFactory() {
    }

    public static AddressEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement addressElement;
        AddressEndpoint addressEndpoint = new AddressEndpoint();
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            addressEndpoint.setName(name.getAttributeValue());
        }
        if ((addressElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "address"))) != null) {
            EndpointDefinition definition = this.createEndpointDefinition(addressElement);
            addressEndpoint.setDefinition(definition);
            this.processAuditStatus(definition, addressEndpoint.getName(), addressElement);
        }
        this.processProperties(addressEndpoint, epConfig);
        return addressEndpoint;
    }

    public EndpointDefinition createEndpointDefinition(OMElement elem) {
        OMAttribute address = elem.getAttribute(new QName("uri"));
        EndpointDefinition endpointDefinition = new EndpointDefinition();
        if (address != null) {
            endpointDefinition.setAddress(address.getAttributeValue().trim());
        }
        this.extractCommonEndpointProperties(endpointDefinition, elem);
        this.extractSpecificEndpointProperties(endpointDefinition, elem);
        return endpointDefinition;
    }
}

