/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorSerializer;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.EntrySerializer;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.MessageStoreSerializer;
import org.apache.synapse.config.xml.ProxyServiceSerializer;
import org.apache.synapse.config.xml.RegistrySerializer;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.config.xml.eventing.EventSourceSerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.startup.AbstractStartup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiXMLConfigurationSerializer {
    private static final Log log = LogFactory.getLog(MultiXMLConfigurationSerializer.class);
    private File rootDirectory;
    private File currentDirectory;

    public MultiXMLConfigurationSerializer(String directoryPath) {
        this.currentDirectory = this.rootDirectory = new File(directoryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(SynapseConfiguration synapseConfig) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Serializing Synapse configuration to the file system");
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace synNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
        OMElement definitions = fac.createOMElement("definitions", synNS);
        try {
            this.currentDirectory = this.createTempDirectoryStructure();
            if (synapseConfig.getRegistry() != null) {
                this.serializeSynapseRegistry(synapseConfig.getRegistry(), synapseConfig, definitions);
            }
            this.serializeProxyServices(synapseConfig.getProxyServices(), synapseConfig, definitions);
            this.serializeEventSources(synapseConfig.getEventSources(), synapseConfig, definitions);
            this.serializeTasks(synapseConfig.getStartups(), synapseConfig, definitions);
            this.serializeLocalRegistryValues(synapseConfig.getLocalRegistry().values(), synapseConfig, definitions);
            this.serializeExecutors(synapseConfig.getPriorityExecutors().values(), definitions);
            this.serializeMessageStores(synapseConfig.getMessageStores().values(), definitions);
            this.serializeSynapseXML(definitions);
            this.markConfigurationForSerialization(synapseConfig);
            if (this.rootDirectory.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting existing files at : " + this.rootDirectory.getAbsolutePath()));
                }
                FileUtils.deleteDirectory((File)this.rootDirectory);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished serializing the configuration to : " + this.currentDirectory.getAbsolutePath() + " - Moving the directory to : " + this.rootDirectory.getAbsolutePath()));
            }
            FileUtils.moveDirectory((File)this.currentDirectory, (File)this.rootDirectory);
        }
        catch (Exception e) {
            log.error((Object)"Error occured while serializing the Synapse configuration.", (Throwable)e);
        }
        finally {
            this.deleteTempDirectory();
            this.currentDirectory = this.rootDirectory;
        }
    }

    public void serializeSynapseXML(SynapseConfiguration synapseConfig) throws Exception {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace synNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
        OMElement definitions = fac.createOMElement("definitions", synNS);
        if (synapseConfig.getRegistry() != null && !Boolean.valueOf(synapseConfig.getProperty("__separateRegDef")).booleanValue()) {
            RegistrySerializer.serializeRegistry(definitions, synapseConfig.getRegistry());
        }
        Collection<ProxyService> proxyServices = synapseConfig.getProxyServices();
        Collection<SynapseEventSource> eventSources = synapseConfig.getEventSources();
        Collection<Startup> tasks = synapseConfig.getStartups();
        Collection localEntries = synapseConfig.getLocalRegistry().values();
        Collection<PriorityExecutor> executors = synapseConfig.getPriorityExecutors().values();
        Collection<MessageStore> messageStores = synapseConfig.getMessageStores().values();
        for (ProxyService service : proxyServices) {
            if (service.getFileName() != null) continue;
            ProxyServiceSerializer.serializeProxy(definitions, service);
        }
        for (SynapseEventSource source : eventSources) {
            if (source.getFileName() != null) continue;
            EventSourceSerializer.serializeEventSource(definitions, source);
        }
        for (Startup task : tasks) {
            if (!(task instanceof AbstractStartup) || task.getFileName() != null) continue;
            StartupFinder.getInstance().serializeStartup(definitions, task);
        }
        for (Object o : localEntries) {
            Entry entry;
            if (o instanceof SequenceMediator) {
                SequenceMediator seq = (SequenceMediator)o;
                if (seq.getFileName() != null) continue;
                MediatorSerializerFinder.getInstance().getSerializer(seq).serializeMediator(definitions, seq);
                continue;
            }
            if (o instanceof AbstractEndpoint) {
                AbstractEndpoint endpoint = (AbstractEndpoint)o;
                if (endpoint.getFileName() != null) continue;
                OMElement endpointElem = EndpointSerializer.getElementFromEndpoint(endpoint);
                definitions.addChild((OMNode)endpointElem);
                continue;
            }
            if (!(o instanceof Entry) || (entry = (Entry)o).getFileName() != null || "SERVER_HOST".equals(entry.getKey()) || "SERVER_IP".equals(entry.getKey()) || entry.getType() == 3) continue;
            EntrySerializer.serializeEntry(entry, definitions);
        }
        for (PriorityExecutor executor : executors) {
            PriorityExecutorSerializer.serialize((OMElement)definitions, (PriorityExecutor)executor, (String)"http://ws.apache.org/ns/synapse");
        }
        for (MessageStore messageStore : messageStores) {
            if (messageStore.getFileName() != null) continue;
            MessageStoreSerializer.serializeMessageStore(definitions, messageStore);
        }
        this.serializeSynapseXML(definitions);
    }

    public OMElement serializeSynapseRegistry(Registry registry, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        OMElement registryElem = RegistrySerializer.serializeRegistry(null, registry);
        if (!Boolean.valueOf(synapseConfig.getProperty("__separateRegDef")).booleanValue() && parent != null) {
            parent.addChild((OMNode)registryElem);
            return registryElem;
        }
        File registryConf = new File(this.currentDirectory, "registry.xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Serializing Synapse registry definition to : " + registryConf.getPath()));
        }
        this.writeToFile(registryElem, registryConf);
        return registryElem;
    }

    public OMElement serializeProxy(ProxyService service, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File proxyDir = this.createDirectory(this.currentDirectory, "proxy-services");
        OMElement proxyElem = ProxyServiceSerializer.serializeProxy(null, service);
        String fileName = service.getFileName();
        if (fileName != null) {
            this.handleDeployment(proxyDir, fileName, service.getName(), synapseConfig.getArtifactDeploymentStore());
            File proxyFile = new File(proxyDir, fileName);
            this.writeToFile(proxyElem, proxyFile);
        } else if (parent != null) {
            parent.addChild((OMNode)proxyElem);
        }
        return proxyElem;
    }

    public OMElement serializeEventSource(SynapseEventSource source, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File eventsDir = this.createDirectory(this.currentDirectory, "event-sources");
        OMElement eventSrcElem = EventSourceSerializer.serializeEventSource(null, source);
        String fileName = source.getFileName();
        if (fileName != null) {
            this.handleDeployment(eventsDir, fileName, source.getName(), synapseConfig.getArtifactDeploymentStore());
            File eventSrcFile = new File(eventsDir, source.getFileName());
            this.writeToFile(eventSrcElem, eventSrcFile);
        } else if (parent != null) {
            parent.addChild((OMNode)eventSrcElem);
        }
        return eventSrcElem;
    }

    public OMElement serializeTask(Startup task, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File tasksDir = this.createDirectory(this.currentDirectory, "tasks");
        OMElement taskElem = StartupFinder.getInstance().serializeStartup(null, task);
        if (task.getFileName() != null) {
            String fileName = task.getFileName();
            this.handleDeployment(tasksDir, fileName, task.getName(), synapseConfig.getArtifactDeploymentStore());
            File taskFile = new File(tasksDir, fileName);
            this.writeToFile(taskElem, taskFile);
        } else if (parent != null) {
            parent.addChild((OMNode)taskElem);
        }
        return taskElem;
    }

    public OMElement serializeSequence(SequenceMediator seq, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File seqDir = this.createDirectory(this.currentDirectory, "sequences");
        OMElement seqElem = MediatorSerializerFinder.getInstance().getSerializer(seq).serializeMediator(null, seq);
        String fileName = seq.getFileName();
        if (fileName != null) {
            this.handleDeployment(seqDir, fileName, seq.getName(), synapseConfig.getArtifactDeploymentStore());
            File seqFile = new File(seqDir, fileName);
            this.writeToFile(seqElem, seqFile);
        } else if (parent != null) {
            parent.addChild((OMNode)seqElem);
        }
        return seqElem;
    }

    public OMElement serializeEndpoint(Endpoint epr, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File eprDir = this.createDirectory(this.currentDirectory, "endpoints");
        OMElement eprElem = EndpointSerializer.getElementFromEndpoint(epr);
        String fileName = epr.getFileName();
        if (fileName != null) {
            this.handleDeployment(eprDir, fileName, epr.getName(), synapseConfig.getArtifactDeploymentStore());
            File eprFile = new File(eprDir, fileName);
            this.writeToFile(eprElem, eprFile);
        } else if (parent != null) {
            parent.addChild((OMNode)eprElem);
        }
        return eprElem;
    }

    public OMElement serializeLocalEntry(Object o, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        if (o instanceof SequenceMediator) {
            return this.serializeSequence((SequenceMediator)o, synapseConfig, parent);
        }
        if (o instanceof Endpoint) {
            return this.serializeEndpoint((Endpoint)o, synapseConfig, parent);
        }
        if (o instanceof Entry) {
            Entry entry = (Entry)o;
            if ("SERVER_HOST".equals(entry.getKey()) || "SERVER_IP".equals(entry.getKey()) || entry.getType() == 3) {
                return null;
            }
            File entriesDir = this.createDirectory(this.currentDirectory, "local-entries");
            OMElement entryElem = EntrySerializer.serializeEntry(entry, null);
            String fileName = entry.getFileName();
            if (fileName != null) {
                this.handleDeployment(entriesDir, fileName, entry.getKey(), synapseConfig.getArtifactDeploymentStore());
                File entryFile = new File(entriesDir, fileName);
                this.writeToFile(entryElem, entryFile);
            } else if (parent != null) {
                parent.addChild((OMNode)entryElem);
            }
            return entryElem;
        }
        return null;
    }

    public OMElement serializeExecutor(PriorityExecutor source, OMElement parent) throws Exception {
        File executorDir = this.createDirectory(this.currentDirectory, "priority-executors");
        OMElement eventDirElem = PriorityExecutorSerializer.serialize(null, (PriorityExecutor)source, (String)"http://ws.apache.org/ns/synapse");
        if (source.getFileName() != null) {
            File eventSrcFile = new File(executorDir, source.getFileName());
            this.writeToFile(eventDirElem, eventSrcFile);
        } else if (parent != null) {
            parent.addChild((OMNode)eventDirElem);
        }
        return eventDirElem;
    }

    public OMElement serializeMessageStore(MessageStore messagestore, OMElement parent) throws Exception {
        File messageStoreDir = this.createDirectory(this.currentDirectory, "message-stores");
        OMElement messageStoreElem = MessageStoreSerializer.serializeMessageStore(null, messagestore);
        String fileName = messagestore.getFileName();
        if (fileName != null) {
            File messageStoreFile = new File(messageStoreDir, fileName);
            this.writeToFile(messageStoreElem, messageStoreFile);
        } else if (parent != null) {
            parent.addChild((OMNode)messageStoreElem);
        }
        return messageStoreElem;
    }

    private void writeToFile(OMElement content, File file) throws Exception {
        File tempFile = File.createTempFile("syn_mx_", ".xml");
        FileOutputStream out = new FileOutputStream(tempFile);
        XMLPrettyPrinter.prettify((OMElement)content, (OutputStream)out);
        out.flush();
        ((OutputStream)out).close();
        FileUtils.copyFile((File)tempFile, (File)file);
        FileUtils.deleteQuietly((File)tempFile);
    }

    private void handleDeployment(File parent, String child, String artifactName, SynapseArtifactDeploymentStore deploymentStore) {
        String fileName = parent.getAbsolutePath() + File.separator + child;
        if (!deploymentStore.containsFileName(fileName)) {
            deploymentStore.addArtifact(fileName, artifactName);
        }
        deploymentStore.addRestoredArtifact(fileName);
    }

    private void serializeProxyServices(Collection<ProxyService> proxyServices, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (ProxyService service : proxyServices) {
            this.serializeProxy(service, synapseConfig, parent);
        }
    }

    private void serializeLocalRegistryValues(Collection localValues, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (Object o : localValues) {
            this.serializeLocalEntry(o, synapseConfig, parent);
        }
    }

    private void serializeTasks(Collection<Startup> tasks, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (Startup task : tasks) {
            this.serializeTask(task, synapseConfig, parent);
        }
    }

    private void serializeEventSources(Collection<SynapseEventSource> eventSources, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (SynapseEventSource source : eventSources) {
            this.serializeEventSource(source, synapseConfig, parent);
        }
    }

    private void serializeExecutors(Collection<PriorityExecutor> executors, OMElement parent) throws Exception {
        for (PriorityExecutor source : executors) {
            this.serializeExecutor(source, parent);
        }
    }

    private void serializeMessageStores(Collection<MessageStore> messaegeStores, OMElement parent) throws Exception {
        for (MessageStore messageStore : messaegeStores) {
            this.serializeMessageStore(messageStore, parent);
        }
    }

    private void serializeSynapseXML(OMElement definitions) throws Exception {
        File synapseXML = new File(this.currentDirectory, "synapse.xml");
        if (!this.currentDirectory.exists()) {
            FileUtils.forceMkdir((File)this.currentDirectory);
        }
        this.writeToFile(definitions, synapseXML);
    }

    private File createTempDirectoryStructure() throws IOException {
        String tempDirName = "__tmp" + new Date().getTime();
        File tempDirectory = new File(this.rootDirectory.getParentFile(), tempDirName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating temporary files at : " + tempDirectory.getAbsolutePath()));
        }
        FileUtils.forceMkdir((File)tempDirectory);
        this.createDirectory(tempDirectory, "proxy-services");
        this.createDirectory(tempDirectory, "event-sources");
        this.createDirectory(tempDirectory, "local-entries");
        this.createDirectory(tempDirectory, "endpoints");
        this.createDirectory(tempDirectory, "sequences");
        this.createDirectory(tempDirectory, "tasks");
        this.createDirectory(tempDirectory, "priority-executors");
        return tempDirectory;
    }

    private void deleteTempDirectory() {
        try {
            if (this.currentDirectory != this.rootDirectory && this.currentDirectory.exists()) {
                FileUtils.deleteDirectory((File)this.currentDirectory);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error while deleting the temporary files at : " + this.currentDirectory.getAbsolutePath() + " - You may delete them manually."), (Throwable)e);
        }
    }

    private File createDirectory(File parent, String name) throws IOException {
        File dir = new File(parent, name);
        if (!dir.exists()) {
            FileUtils.forceMkdir((File)dir);
        }
        return dir;
    }

    private void markConfigurationForSerialization(SynapseConfiguration synapseConfig) {
        SynapseArtifactDeploymentStore deploymentStore = synapseConfig.getArtifactDeploymentStore();
        for (SequenceMediator seq : synapseConfig.getDefinedSequences().values()) {
            if (seq.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "sequences"), seq.getFileName(), seq.getName(), deploymentStore);
        }
        for (Endpoint ep : synapseConfig.getDefinedEndpoints().values()) {
            if (ep.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "endpoints"), ep.getFileName(), ep.getName(), deploymentStore);
        }
        for (ProxyService proxy : synapseConfig.getProxyServices()) {
            if (proxy.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "proxy-services"), proxy.getFileName(), proxy.getName(), deploymentStore);
        }
        for (Entry e : synapseConfig.getDefinedEntries().values()) {
            if (e.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "local-entries"), File.separator + e.getFileName(), e.getKey(), deploymentStore);
        }
        for (SynapseEventSource es : synapseConfig.getEventSources()) {
            if (es.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "event-sources"), es.getFileName(), es.getName(), deploymentStore);
        }
        for (Startup s : synapseConfig.getStartups()) {
            if (s.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "tasks"), s.getFileName(), s.getName(), deploymentStore);
        }
        for (PriorityExecutor exec : synapseConfig.getPriorityExecutors().values()) {
            if (exec.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "priority-executors"), exec.getFileName(), exec.getName(), deploymentStore);
        }
    }
}

