/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;

public class EntrySerializer {
    private static Log log = LogFactory.getLog(EntrySerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializeEntry(Entry entry, OMElement parent) {
        OMElement entryElement = fac.createOMElement("localEntry", synNS);
        if (entry.getDescription() != null) {
            OMElement descriptionElem = fac.createOMElement(new QName("http://ws.apache.org/ns/synapse", "description"));
            descriptionElem.setText(entry.getDescription());
            entryElement.addChild((OMNode)descriptionElem);
        }
        entryElement.addAttribute(fac.createOMAttribute("key", nullNS, entry.getKey().trim()));
        int type = entry.getType();
        if (type == 2) {
            URL srcUrl = entry.getSrc();
            if (srcUrl != null) {
                entryElement.addAttribute(fac.createOMAttribute("src", nullNS, srcUrl.toString().trim()));
            }
        } else if (type == 1) {
            Object value = entry.getValue();
            if (value != null && value instanceof OMElement) {
                entryElement.addChild((OMNode)((OMElement)value));
            }
        } else if (type == 0) {
            Object value = entry.getValue();
            if (value != null && value instanceof String) {
                OMTextImpl textData = (OMTextImpl)fac.createOMText(((String)value).trim());
                textData.setType(12);
                entryElement.addChild((OMNode)textData);
            }
        } else {
            if (type == 3) {
                return null;
            }
            EntrySerializer.handleException("Entry type undefined");
        }
        if (parent != null) {
            parent.addChild((OMNode)entryElement);
        }
        return entryElement;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

