/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.datasource.DataSourceRepositoryHolder;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseObserver;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.endpoints.XMLToEndpointMapper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.registry.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynapseConfiguration
implements ManagedLifecycle,
SynapseArtifact {
    private static final Log log = LogFactory.getLog(SynapseConfiguration.class);
    private static final String ENTRY = "entry";
    private static final String ENDPOINT = "endpoint";
    private static final String SEQUENCE = "sequence";
    private Registry registry = null;
    private QName defaultQName = null;
    private Mediator mandatorySequence = null;
    private final Map<String, ProxyService> proxyServices = new HashMap<String, ProxyService>();
    private final Map<String, Startup> startups = new HashMap<String, Startup>();
    private final Map<String, Object> localRegistry = new HashMap<String, Object>();
    private Properties properties = new Properties();
    private Timer synapseTimer = new Timer(true);
    private AxisConfiguration axisConfiguration = null;
    private String pathToConfigFile = null;
    private Map<String, SynapseEventSource> eventSources = new HashMap<String, SynapseEventSource>();
    private List<SynapseObserver> observers = new ArrayList<SynapseObserver>();
    private Map<String, PriorityExecutor> executors = new HashMap<String, PriorityExecutor>();
    private Map<String, MessageStore> messageStores = new HashMap<String, MessageStore>();
    private String description = null;
    SynapseArtifactDeploymentStore artifactDeploymentStore = new SynapseArtifactDeploymentStore();

    public synchronized void addSequence(String key, Mediator mediator) {
        this.assertAlreadyExists(key, SEQUENCE);
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceAdded(mediator);
        }
    }

    public void addSequence(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        this.localRegistry.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SequenceMediator> getDefinedSequences() {
        HashMap<String, SequenceMediator> definedSequences = new HashMap<String, SequenceMediator>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof SequenceMediator)) continue;
                SequenceMediator seq = (SequenceMediator)o;
                definedSequences.put(seq.getName(), seq);
            }
        }
        return definedSequences;
    }

    public Mediator getMandatorySequence() {
        return this.mandatorySequence;
    }

    public void setMandatorySequence(Mediator mandatorySequence) {
        this.mandatorySequence = mandatorySequence;
    }

    public Mediator getSequence(String key) {
        Object o = this.getEntry(key);
        if (o instanceof Mediator) {
            return (Mediator)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(MediatorFactoryFinder.getInstance());
        }
        if (entry.getType() == 3) {
            if (this.registry != null && (o = this.registry.getResource(entry, this.getProperties())) != null && o instanceof Mediator) {
                this.localRegistry.put(key, entry);
                return (Mediator)o;
            }
        } else {
            Object object;
            Object value = entry.getValue();
            if (value instanceof OMNode && (object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties())) instanceof Mediator) {
                entry.setValue(object);
                return (Mediator)object;
            }
        }
        return null;
    }

    public synchronized void removeSequence(String key) {
        Object sequence = this.localRegistry.get(key);
        if (sequence instanceof Mediator) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.sequenceRemoved((Mediator)sequence);
            }
        } else {
            this.handleException("No sequence exists by the key/name : " + key);
        }
    }

    public Mediator getMainSequence() {
        return this.getSequence("main");
    }

    public Mediator getFaultSequence() {
        return this.getSequence("fault");
    }

    public synchronized void addEntry(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        if (entry.getType() == 2 && entry.getValue() == null) {
            try {
                SynapseEnvironment synEnv = SynapseConfigUtils.getSynapseEnvironment(this.axisConfiguration);
                entry.setValue(SynapseConfigUtils.getOMElementFromURL(entry.getSrc().toString(), synEnv != null ? synEnv.getServerContextInformation().getServerConfigurationInformation().getSynapseHome() : ""));
                this.localRegistry.put(key, entry);
                for (SynapseObserver o : this.observers) {
                    o.entryAdded(entry);
                }
            }
            catch (IOException e) {
                this.handleException("Can not read from source URL : " + entry.getSrc());
            }
        } else {
            this.localRegistry.put(key, entry);
            for (SynapseObserver o : this.observers) {
                o.entryAdded(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Entry> getCachedEntries() {
        HashMap<String, Entry> cachedEntries = new HashMap<String, Entry>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                Entry entry;
                if (o == null || !(o instanceof Entry) || !(entry = (Entry)o).isDynamic() || !entry.isCached()) continue;
                cachedEntries.put(entry.getKey(), entry);
            }
        }
        return cachedEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Entry> getDefinedEntries() {
        HashMap<String, Entry> definedEntries = new HashMap<String, Entry>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof Entry) || ((Entry)o).getType() == 3) continue;
                Entry entry = (Entry)o;
                definedEntries.put(entry.getKey(), entry);
            }
        }
        return definedEntries;
    }

    public Object getEntry(String key) {
        Object o = this.localRegistry.get(key);
        if (o != null && o instanceof Entry) {
            Entry entry = (Entry)o;
            if (!entry.isDynamic() || entry.isCached() && !entry.isExpired()) {
                return entry.getValue();
            }
            if (this.registry != null) {
                if (entry.isCached()) {
                    try {
                        o = this.registry.getResource(entry, this.getProperties());
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error while loading the resource " + key + " from the remote " + "registry. Previously cached value will be used. Check the " + "registry accessibility."));
                        return entry.getValue();
                    }
                } else {
                    o = this.registry.getResource(entry, this.getProperties());
                }
            } else {
                if (entry.isCached()) {
                    log.warn((Object)("The registry is no longer available in the Synapse configuration. Using the previously cached value for the resource : " + key));
                    return entry.getValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will not  evaluate the value of the remote entry with a key " + key + ",  because the registry is not available"));
                }
                return null;
            }
        }
        return o;
    }

    public Entry getEntryDefinition(String key) {
        Object o = this.localRegistry.get(key);
        if (o == null || o instanceof Entry) {
            if (o == null) {
                Entry entry = new Entry(key);
                entry.setType(3);
                this.addEntry(key, entry);
                return entry;
            }
            return (Entry)o;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is no local registry entry for key : " + key));
        }
        return null;
    }

    public synchronized void removeEntry(String key) {
        Object entry = this.localRegistry.get(key);
        if (entry instanceof Entry) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.entryRemoved((Entry)entry);
            }
        } else {
            this.handleException("No entry exists by the key : " + key);
        }
    }

    public void clearCachedEntry(String key) {
        Entry entry = this.getEntryDefinition(key);
        if (entry != null && entry.isDynamic() && entry.isCached()) {
            entry.clearCache();
        }
    }

    public synchronized void clearCache() {
        for (Object o : this.localRegistry.values()) {
            Entry entry;
            if (o == null || !(o instanceof Entry) || !(entry = (Entry)o).isDynamic() || !entry.isCached()) continue;
            entry.clearCache();
        }
    }

    public synchronized void addEndpoint(String key, Endpoint endpoint) {
        this.assertAlreadyExists(key, ENDPOINT);
        this.localRegistry.put(key, endpoint);
        for (SynapseObserver o : this.observers) {
            o.endpointAdded(endpoint);
        }
    }

    public void addEndpoint(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        this.localRegistry.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Endpoint> getDefinedEndpoints() {
        HashMap<String, Endpoint> definedEndpoints = new HashMap<String, Endpoint>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof Endpoint)) continue;
                Endpoint ep = (Endpoint)o;
                definedEndpoints.put(ep.getName(), ep);
            }
        }
        return definedEndpoints;
    }

    public Endpoint getEndpoint(String key) {
        Object o = this.getEntry(key);
        if (o != null && o instanceof Endpoint) {
            return (Endpoint)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(XMLToEndpointMapper.getInstance());
        }
        if (entry.getType() == 3) {
            if (this.registry != null && (o = this.registry.getResource(entry, this.getProperties())) != null && o instanceof Endpoint) {
                this.localRegistry.put(key, entry);
                return (Endpoint)o;
            }
        } else {
            Object object;
            Object value = entry.getValue();
            if (value instanceof OMNode && (object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties())) instanceof Endpoint) {
                entry.setValue(object);
                return (Endpoint)object;
            }
        }
        return null;
    }

    public synchronized void removeEndpoint(String key) {
        Object endpoint = this.localRegistry.get(key);
        if (endpoint instanceof Endpoint) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.endpointRemoved((Endpoint)endpoint);
            }
        } else {
            this.handleException("No endpoint exists by the key/name : " + key);
        }
    }

    public synchronized void addProxyService(String name, ProxyService proxy) {
        if (!this.proxyServices.containsKey(name)) {
            this.proxyServices.put(name, proxy);
            for (SynapseObserver o : this.observers) {
                o.proxyServiceAdded(proxy);
            }
        } else {
            this.handleException("Duplicate proxy service by the name : " + name);
        }
    }

    public ProxyService getProxyService(String name) {
        return this.proxyServices.get(name);
    }

    public synchronized void removeProxyService(String name) {
        ProxyService proxy = this.proxyServices.get(name);
        if (proxy == null) {
            this.handleException("Unknown proxy service for name : " + name);
        } else {
            try {
                if (this.getAxisConfiguration().getServiceForActivation(name) != null) {
                    if (this.getAxisConfiguration().getServiceForActivation(name).isActive()) {
                        this.getAxisConfiguration().getService(name).setActive(false);
                    }
                    this.getAxisConfiguration().removeService(name);
                }
                this.proxyServices.remove(name);
                for (SynapseObserver o : this.observers) {
                    o.proxyServiceRemoved(proxy);
                }
            }
            catch (AxisFault axisFault) {
                this.handleException(axisFault.getMessage());
            }
        }
    }

    public Collection<ProxyService> getProxyServices() {
        return Collections.unmodifiableCollection(this.proxyServices.values());
    }

    public Map getLocalRegistry() {
        return Collections.unmodifiableMap(this.localRegistry);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setAxisConfiguration(AxisConfiguration axisConfig) {
        this.axisConfiguration = axisConfig;
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    public String getPathToConfigFile() {
        return this.pathToConfigFile;
    }

    public void setPathToConfigFile(String pathToConfigFile) {
        this.pathToConfigFile = pathToConfigFile;
    }

    public void setDefaultQName(QName defaultQName) {
        this.defaultQName = defaultQName;
    }

    public QName getDefaultQName() {
        return this.defaultQName;
    }

    public Timer getSynapseTimer() {
        return this.synapseTimer;
    }

    public Collection<Startup> getStartups() {
        return this.startups.values();
    }

    public Startup getStartup(String id) {
        return this.startups.get(id);
    }

    public synchronized void addStartup(Startup startup) {
        if (!this.startups.containsKey(startup.getName())) {
            this.startups.put(startup.getName(), startup);
            for (SynapseObserver o : this.observers) {
                o.startupAdded(startup);
            }
        } else {
            this.handleException("Duplicate startup by the name : " + startup.getName());
        }
    }

    public synchronized void removeStartup(String name) {
        Startup startup = this.startups.get(name);
        if (startup != null) {
            this.startups.remove(name);
            for (SynapseObserver o : this.observers) {
                o.startupRemoved(startup);
            }
        } else {
            this.handleException("No startup exists by the name : " + name);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String propKey, String def) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return val;
        }
        return def;
    }

    public long getProperty(String propKey, long def) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return Long.valueOf(val);
        }
        return def;
    }

    public String getProperty(String propKey) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return val;
        }
        return null;
    }

    @Override
    public synchronized void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying the Synapse Configuration");
        }
        this.synapseTimer.cancel();
        this.synapseTimer = null;
        for (ProxyService p : this.getProxyServices()) {
            if (p.getTargetInLineInSequence() != null) {
                p.getTargetInLineInSequence().destroy();
            }
            if (p.getTargetInLineOutSequence() == null) continue;
            p.getTargetInLineOutSequence().destroy();
        }
        for (SequenceMediator seq : this.getDefinedSequences().values()) {
            seq.destroy();
        }
        for (Endpoint endpoint : this.getDefinedEndpoints().values()) {
            endpoint.destroy();
        }
        for (Startup stp : this.startups.values()) {
            stp.destroy();
        }
        try {
            SALSessions.getInstance().reset();
            DataSourceRepositoryHolder.getInstance().getDataSourceRepositoryManager().clear();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        for (PriorityExecutor pe : this.executors.values()) {
            pe.destroy();
        }
    }

    @Override
    public synchronized void init(SynapseEnvironment se) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the Synapse Configuration using the SynapseEnvironment");
        }
        if (this.registry != null && this.registry instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.registry)).init(se);
        }
        for (Endpoint endpoint : this.getDefinedEndpoints().values()) {
            endpoint.init(se);
        }
        for (SequenceMediator seq : this.getDefinedSequences().values()) {
            if (seq == null) continue;
            seq.init(se);
        }
        for (ProxyService proxy : this.getProxyServices()) {
            if (proxy.getTargetInLineEndpoint() != null) {
                proxy.getTargetInLineEndpoint().init(se);
            }
            if (proxy.getTargetInLineInSequence() != null) {
                proxy.getTargetInLineInSequence().init(se);
            }
            if (proxy.getTargetInLineOutSequence() != null) {
                proxy.getTargetInLineOutSequence().init(se);
            }
            if (proxy.getTargetInLineFaultSequence() == null) continue;
            proxy.getTargetInLineFaultSequence().init(se);
        }
        for (Startup stp : this.getStartups()) {
            if (stp == null) continue;
            stp.init(se);
        }
        for (PriorityExecutor executor : this.getPriorityExecutors().values()) {
            executor.init();
        }
        for (MessageStore messageStore : this.messageStores.values()) {
            ((ManagedLifecycle)((Object)messageStore)).init(se);
        }
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public synchronized void addEventSource(String name, SynapseEventSource eventSource) {
        if (!this.eventSources.containsKey(name)) {
            this.eventSources.put(name, eventSource);
            for (SynapseObserver o : this.observers) {
                o.eventSourceAdded(eventSource);
            }
        } else {
            this.handleException("Duplicate event source by the name : " + name);
        }
    }

    public SynapseEventSource getEventSource(String name) {
        return this.eventSources.get(name);
    }

    public synchronized void removeEventSource(String name) {
        SynapseEventSource eventSource = this.eventSources.get(name);
        if (eventSource == null) {
            this.handleException("No event source exists by the name : " + name);
        } else {
            try {
                if (this.getAxisConfiguration().getServiceForActivation(name) != null) {
                    if (this.getAxisConfiguration().getServiceForActivation(name).isActive()) {
                        this.getAxisConfiguration().getService(name).setActive(false);
                    }
                    this.getAxisConfiguration().removeService(name);
                }
                this.eventSources.remove(name);
                for (SynapseObserver o : this.observers) {
                    o.eventSourceRemoved(eventSource);
                }
            }
            catch (AxisFault axisFault) {
                this.handleException(axisFault.getMessage());
            }
        }
    }

    public Collection<SynapseEventSource> getEventSources() {
        return this.eventSources.values();
    }

    public void setEventSources(Map<String, SynapseEventSource> eventSources) {
        this.eventSources = eventSources;
    }

    public void registerObserver(SynapseObserver o) {
        if (!this.observers.contains(o)) {
            this.observers.add(o);
        }
    }

    public List<SynapseObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    public synchronized void addPriorityExecutor(String name, PriorityExecutor executor) {
        this.executors.put(name, executor);
        for (SynapseObserver o : this.observers) {
            o.priorityExecutorAdded(executor);
        }
    }

    public Map<String, PriorityExecutor> getPriorityExecutors() {
        return this.executors;
    }

    public synchronized PriorityExecutor removeExecutor(String name) {
        PriorityExecutor executor = this.executors.remove(name);
        if (executor != null) {
            for (SynapseObserver o : this.observers) {
                o.priorityExecutorRemoved(executor);
            }
        }
        return executor;
    }

    public MessageStore getMessageStore(String name) {
        return this.messageStores.get(name);
    }

    public void addMessageStore(String name, MessageStore messageStore) {
        if (!this.messageStores.containsKey(name)) {
            this.messageStores.put(name, messageStore);
        } else {
            this.handleException("Duplicate message store by the name: " + name);
        }
    }

    public Map<String, MessageStore> getMessageStores() {
        return this.messageStores;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public SynapseArtifactDeploymentStore getArtifactDeploymentStore() {
        return this.artifactDeploymentStore;
    }

    private void assertAlreadyExists(String key, String type) {
        if (key == null || "".equals(key)) {
            this.handleException("Given entry key is empty or null.");
        }
        if (this.localRegistry.containsKey(key.trim())) {
            this.handleException("Duplicate " + type + " definition for key : " + key);
        }
    }

    private void assertEntryNull(Entry entry, String key) {
        if (entry == null) {
            this.handleException("Cannot locate an either local or remote enrty for key : " + key);
        }
    }
}

