/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.net.InetSocketAddress;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.SSLIOSession;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.nhttp.LoggingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLClientIOEventDispatch
extends org.apache.http.impl.nio.SSLClientIOEventDispatch {
    private static final Log log = LogFactory.getLog(SSLClientIOEventDispatch.class);
    private Map<String, SSLContext> contextMap;

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslcontext, SSLIOSessionHandler sslHandler, HttpParams params) {
        super(LoggingUtils.decorate(handler), sslcontext, sslHandler, params);
    }

    public void setContextMap(Map<String, SSLContext> contextMap) {
        this.contextMap = contextMap;
    }

    protected SSLIOSession createSSLIOSession(IOSession ioSession, SSLContext sslContext, SSLIOSessionHandler sslioSessionHandler) {
        SSLContext customContext = null;
        if (this.contextMap != null) {
            InetSocketAddress address = (InetSocketAddress)ioSession.getRemoteAddress();
            String host = address.getHostName() + ":" + address.getPort();
            customContext = this.contextMap.get(host);
            if (log.isDebugEnabled() && customContext != null) {
                log.debug((Object)("Custom SSL context found for the server: " + host));
            }
        }
        if (customContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using default SSL context for the outbound connection");
            }
            customContext = sslContext;
        }
        return super.createSSLIOSession(ioSession, customContext, sslioSessionHandler);
    }

    protected NHttpClientIOTarget createConnection(IOSession session) {
        session = LoggingUtils.decorate(session, "sslclient");
        return LoggingUtils.createClientConnection(session, this.createHttpResponseFactory(), this.createByteBufferAllocator(), this.params);
    }
}

