/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;

class LoggingNHttpClientConnection
extends DefaultNHttpClientConnection {
    private final Log log;
    private final Log headerlog;

    public LoggingNHttpClientConnection(Log log, Log headerlog, IOSession iosession, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(iosession, responseFactory, allocator, params);
        this.log = log;
        this.headerlog = headerlog;
    }

    public void close() throws IOException {
        this.log.debug((Object)"Close connection");
        super.close();
    }

    public void shutdown() throws IOException {
        this.log.debug((Object)"Shutdown connection");
        super.shutdown();
    }

    public void submitRequest(HttpRequest request) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + (Object)((Object)this) + ": " + request.getRequestLine().toString()));
        }
        super.submitRequest(request);
    }

    public void consumeInput(NHttpClientHandler handler) {
        this.log.debug((Object)"Consume input");
        super.consumeInput(handler);
    }

    public void produceOutput(NHttpClientHandler handler) {
        this.log.debug((Object)"Produce output");
        super.produceOutput(handler);
    }

    protected NHttpMessageWriter createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new LoggingNHttpMessageWriter(super.createRequestWriter(buffer, params));
    }

    protected NHttpMessageParser createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new LoggingNHttpMessageParser(super.createResponseParser(buffer, responseFactory, params));
    }

    class LoggingNHttpMessageParser
    implements NHttpMessageParser {
        private final NHttpMessageParser parser;

        public LoggingNHttpMessageParser(NHttpMessageParser parser) {
            this.parser = parser;
        }

        public void reset() {
            this.parser.reset();
        }

        public int fillBuffer(ReadableByteChannel channel) throws IOException {
            return this.parser.fillBuffer(channel);
        }

        public HttpMessage parse() throws IOException, HttpException {
            HttpMessage message = this.parser.parse();
            if (message != null && LoggingNHttpClientConnection.this.headerlog.isDebugEnabled()) {
                HttpResponse response = (HttpResponse)message;
                LoggingNHttpClientConnection.this.headerlog.debug((Object)("<< " + response.getStatusLine().toString()));
                Header[] headers = response.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    LoggingNHttpClientConnection.this.headerlog.debug((Object)("<< " + headers[i].toString()));
                }
            }
            return message;
        }
    }

    class LoggingNHttpMessageWriter
    implements NHttpMessageWriter {
        private final NHttpMessageWriter writer;

        public LoggingNHttpMessageWriter(NHttpMessageWriter writer) {
            this.writer = writer;
        }

        public void reset() {
            this.writer.reset();
        }

        public void write(HttpMessage message) throws IOException, HttpException {
            if (message != null && LoggingNHttpClientConnection.this.headerlog.isDebugEnabled()) {
                HttpRequest request = (HttpRequest)message;
                LoggingNHttpClientConnection.this.headerlog.debug((Object)(">> " + request.getRequestLine().toString()));
                Header[] headers = request.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    LoggingNHttpClientConnection.this.headerlog.debug((Object)(">> " + headers[i].toString()));
                }
            }
            this.writer.write(message);
        }
    }
}

