/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.format.DataSourceMessageBuilder;
import org.apache.axis2.format.ManagedDataSource;
import org.apache.axis2.format.ManagedDataSourceFactory;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.AbstractPollingTransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.synapse.transport.vfs.FileObjectDataSource;
import org.apache.synapse.transport.vfs.PollTableEntry;
import org.apache.synapse.transport.vfs.VFSOutTransportInfo;
import org.apache.synapse.transport.vfs.VFSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSTransportListener
extends AbstractPollingTransportListener<PollTableEntry>
implements ManagementSupport {
    public static final String TRANSPORT_NAME = "vfs";
    public static final String DELETE = "DELETE";
    public static final String MOVE = "MOVE";
    private FileSystemManager fsManager = null;
    private boolean globalFileLockingFlag = true;

    public void init(ConfigurationContext cfgCtx, TransportInDescription trpInDesc) throws AxisFault {
        super.init(cfgCtx, trpInDesc);
        try {
            String strLockingFlag;
            StandardFileSystemManager fsm = new StandardFileSystemManager();
            fsm.setConfiguration(((Object)((Object)this)).getClass().getClassLoader().getResource("providers.xml"));
            fsm.init();
            this.fsManager = fsm;
            Parameter lockFlagParam = trpInDesc.getParameter("transport.vfs.Locking");
            if (lockFlagParam != null && "disable".equals(strLockingFlag = lockFlagParam.getValue().toString())) {
                this.globalFileLockingFlag = false;
            }
        }
        catch (FileSystemException e) {
            this.handleException("Error initializing the file transport : " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void poll(PollTableEntry entry) {
        this.scanFileOrDirectory(entry, entry.getFileURI());
    }

    private void scanFileOrDirectory(PollTableEntry entry, String fileURI) {
        FileObject fileObject = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Scanning directory or file : " + VFSUtils.maskURLPassword(fileURI)));
        }
        boolean wasError = true;
        int retryCount = 0;
        int maxRetryCount = entry.getMaxRetryCount();
        long reconnectionTimeout = entry.getReconnectTimeout();
        while (wasError) {
            try {
                ++retryCount;
                fileObject = this.fsManager.resolveFile(fileURI);
                if (fileObject == null) {
                    this.log.error((Object)"fileObject is null");
                    throw new FileSystemException("fileObject is null");
                }
                wasError = false;
            }
            catch (FileSystemException e) {
                this.log.error((Object)"cannot resolve fileObject", (Throwable)e);
                if (maxRetryCount <= retryCount) {
                    this.processFailure("cannot resolve fileObject repeatedly: " + e.getMessage(), (Exception)((Object)e), entry);
                }
                return;
            }
            if (!wasError) continue;
            try {
                Thread.sleep(reconnectionTimeout);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        try {
            if (fileObject.exists() && fileObject.isReadable()) {
                entry.setLastPollState(3);
                FileObject[] children = null;
                try {
                    children = fileObject.getChildren();
                }
                catch (FileSystemException ignore) {
                    // empty catch block
                }
                if (children == null || children.length == 0) {
                    if (fileObject.getType() == FileType.FILE) {
                        if (!entry.isFileLockingEnabled() || entry.isFileLockingEnabled() && VFSUtils.acquireLock(this.fsManager, fileObject)) {
                            try {
                                this.processFile(entry, fileObject);
                                entry.setLastPollState(0);
                                this.metrics.incrementMessagesReceived();
                            }
                            catch (AxisFault e) {
                                if (entry.isFileLockingEnabled()) {
                                    VFSUtils.releaseLock(this.fsManager, fileObject);
                                }
                                this.logException("Error processing File URI : " + fileObject.getName(), (Exception)((Object)e));
                                entry.setLastPollState(2);
                                this.metrics.incrementFaultsReceiving();
                            }
                            this.moveOrDeleteAfterProcessing(entry, fileObject);
                            if (entry.isFileLockingEnabled()) {
                                VFSUtils.releaseLock(this.fsManager, fileObject);
                            }
                        } else if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Couldn't get the lock for processing the file : " + fileObject.getName()));
                        }
                    }
                } else {
                    int failCount = 0;
                    int successCount = 0;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("File name pattern : " + entry.getFileNamePattern()));
                    }
                    for (FileObject child : children) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Matching file : " + child.getName().getBaseName()));
                        }
                        if (entry.getFileNamePattern() != null && child.getName().getBaseName().matches(entry.getFileNamePattern()) && (!entry.isFileLockingEnabled() || entry.isFileLockingEnabled() && VFSUtils.acquireLock(this.fsManager, child))) {
                            try {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Processing file :" + child));
                                }
                                this.processFile(entry, child);
                                ++successCount;
                                entry.setLastPollState(0);
                                this.metrics.incrementMessagesReceived();
                            }
                            catch (Exception e) {
                                if (entry.isFileLockingEnabled()) {
                                    VFSUtils.releaseLock(this.fsManager, child);
                                }
                                this.logException("Error processing File URI : " + child.getName(), e);
                                ++failCount;
                                entry.setLastPollState(2);
                                this.metrics.incrementFaultsReceiving();
                            }
                            this.moveOrDeleteAfterProcessing(entry, child);
                            if (!entry.isFileLockingEnabled()) continue;
                            VFSUtils.releaseLock(this.fsManager, child);
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Couldn't get the lock for processing the file : " + child.getName()));
                    }
                    if (failCount == 0 && successCount > 0) {
                        entry.setLastPollState(0);
                    } else if (successCount == 0 && failCount > 0) {
                        entry.setLastPollState(2);
                    } else {
                        entry.setLastPollState(1);
                    }
                }
                long now = System.currentTimeMillis();
                entry.setLastPollTime(now);
                entry.setNextPollTime(now + entry.getPollInterval());
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unable to access or read file or directory : " + VFSUtils.maskURLPassword(fileURI)));
            }
            this.onPollCompletion(entry);
        }
        catch (FileSystemException e) {
            this.processFailure("Error checking for existence and readability : " + VFSUtils.maskURLPassword(fileURI), (Exception)((Object)e), entry);
        }
    }

    private void moveOrDeleteAfterProcessing(PollTableEntry entry, FileObject fileObject) {
        block14: {
            String moveToDirectoryURI = null;
            try {
                switch (entry.getLastPollState()) {
                    case 0: {
                        if (entry.getActionAfterProcess() != 1) break;
                        moveToDirectoryURI = entry.getMoveAfterProcess();
                        break;
                    }
                    case 2: {
                        if (entry.getActionAfterFailure() != 1) break;
                        moveToDirectoryURI = entry.getMoveAfterFailure();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (moveToDirectoryURI != null) {
                    FileObject moveToDirectory = this.fsManager.resolveFile(moveToDirectoryURI);
                    String prefix = entry.getMoveTimestampFormat() != null ? entry.getMoveTimestampFormat().format(new Date()) : "";
                    FileObject dest = moveToDirectory.resolveFile(prefix + fileObject.getName().getBaseName());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Moving to file :" + dest.getName().getURI()));
                    }
                    try {
                        fileObject.moveTo(dest);
                    }
                    catch (FileSystemException e) {
                        this.log.error((Object)("Error moving file : " + fileObject + " to " + moveToDirectoryURI), (Throwable)e);
                    }
                    break block14;
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Deleting file :" + fileObject));
                    }
                    fileObject.close();
                    if (!fileObject.delete()) {
                        this.log.error((Object)("Cannot delete file : " + fileObject));
                    }
                }
                catch (FileSystemException e) {
                    this.log.error((Object)("Error deleting file : " + fileObject), (Throwable)e);
                }
            }
            catch (FileSystemException e) {
                this.log.error((Object)("Error resolving directory to move after processing : " + moveToDirectoryURI), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(PollTableEntry entry, FileObject file) throws AxisFault {
        try {
            ManagedDataSource dataSource;
            InputStream in;
            SOAPBuilder builder;
            String replyFileURI;
            FileContent content = file.getContent();
            String fileName = file.getName().getBaseName();
            String filePath = file.getName().getPath();
            this.metrics.incrementBytesReceived(content.getSize());
            HashMap<String, Object> transportHeaders = new HashMap<String, Object>();
            transportHeaders.put("FILE_PATH", filePath);
            transportHeaders.put("FILE_NAME", fileName);
            try {
                transportHeaders.put("FILE_LENGTH", content.getSize());
                transportHeaders.put("LAST_MODIFIED", content.getLastModifiedTime());
            }
            catch (FileSystemException ignore) {
                // empty catch block
            }
            MessageContext msgContext = entry.createMessageContext();
            String contentType = entry.getContentType();
            if (BaseUtils.isBlank((String)contentType)) {
                if (file.getName().getExtension().toLowerCase().endsWith(".xml")) {
                    contentType = "text/xml";
                } else if (file.getName().getExtension().toLowerCase().endsWith(".txt")) {
                    contentType = "text/plain";
                }
            } else {
                String charSetEnc = null;
                try {
                    if (contentType != null) {
                        charSetEnc = new ContentType(contentType).getParameter("charset");
                    }
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            }
            if (contentType == null) {
                if (entry.getContentType() != null) {
                    contentType = entry.getContentType();
                } else if (VFSUtils.getProperty(content, "Content-Type") != null) {
                    contentType = VFSUtils.getProperty(content, "Content-Type");
                }
            }
            if ((replyFileURI = entry.getReplyFileURI()) != null) {
                msgContext.setProperty("OutTransportInfo", (Object)new VFSOutTransportInfo(replyFileURI, entry.isFileLockingEnabled()));
            }
            if (contentType == null) {
                this.log.debug((Object)"No content type specified. Using SOAP builder.");
                builder = new SOAPBuilder();
            } else {
                int index = contentType.indexOf(59);
                String type = index > 0 ? contentType.substring(0, index) : contentType;
                builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)msgContext);
                if (builder == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                    }
                    builder = new SOAPBuilder();
                }
            }
            if (builder instanceof DataSourceMessageBuilder && entry.isStreaming()) {
                in = null;
                dataSource = ManagedDataSourceFactory.create((DataSource)new FileObjectDataSource(file, contentType));
            } else {
                in = content.getInputStream();
                dataSource = null;
            }
            try {
                OMElement documentElement = in != null ? builder.processDocument(in, contentType, msgContext) : ((DataSourceMessageBuilder)builder).processDocument((DataSource)dataSource, contentType, msgContext);
                msgContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
                this.handleIncomingMessage(msgContext, transportHeaders, null, contentType);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        this.handleException("Error closing stream", ex);
                    }
                } else {
                    dataSource.destroy();
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processed file : " + file + " of Content-type : " + contentType));
            }
        }
        catch (FileSystemException e) {
            this.handleException("Error reading file content or attributes : " + file, (Exception)((Object)e));
        }
        finally {
            try {
                file.close();
            }
            catch (FileSystemException warn) {
                this.log.warn((Object)("Cannot close file after processing : " + file.getName().getPath()), (Throwable)warn);
            }
        }
    }

    protected PollTableEntry createEndpoint() {
        return new PollTableEntry(this.globalFileLockingFlag);
    }
}

