/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.policy;

import java.util.HashMap;
import java.util.Vector;
import org.apache.axis2.policy.model.MTOMAssertion;
import org.apache.neethi.Policy;
import org.apache.rampart.RampartException;
import org.apache.rampart.policy.SupportingPolicyData;
import org.apache.rampart.policy.model.OptimizePartsConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.Trust10;
import org.apache.ws.secpolicy.model.Wss10;
import org.apache.ws.secpolicy.model.Wss11;
import org.apache.ws.security.WSEncryptionPart;

public class RampartPolicyData {
    private boolean symmetricBinding;
    private boolean transportBinding;
    private boolean asymmetricBinding;
    private String layout;
    private boolean includeTimestamp;
    private boolean includeTimestampOptional;
    private boolean entireHeadersAndBodySignatures;
    private String protectionOrder;
    private boolean signatureProtection;
    private boolean tokenProtection;
    private boolean signatureConfirmation;
    private Token encryptionToken;
    private Token signatureToken;
    private Token transportToken;
    private Token recipientToken;
    private Token initiatorToken;
    private boolean signBody;
    private boolean encryptBody;
    private boolean signAttachments;
    private boolean encryptAttachments;
    private boolean signBodyOptional;
    private boolean encryptBodyOptional;
    private boolean signAttachmentsOptional;
    private boolean encryptAttachmentsOptional;
    private boolean signAllHeaders;
    private Vector signedParts = new Vector();
    private Vector signedElements = new Vector();
    private Vector encryptedParts = new Vector();
    private Vector encryptedElements = new Vector();
    private Vector requiredElements = new Vector();
    private Vector contentEncryptedElements = new Vector();
    private HashMap declaredNamespaces = new HashMap();
    private SupportingToken signedSupportingTokens;
    private SupportingToken endorsingSupportingTokens;
    private SupportingToken signedEndorsingSupportingTokens;
    private SupportingToken encryptedSupportingTokens;
    private SupportingToken signedEncryptedSupportingTokens;
    private SupportingToken endorsingEncryptedSupportingTokens;
    private SupportingToken signedEndorsingEncryptedSupportingTokens;
    private AlgorithmSuite algorithmSuite;
    private RampartConfig rampartConfig;
    private MTOMAssertion mtomAssertion;
    private Trust10 trust10;
    private HashMap supportingTokensIdMap;
    private HashMap signedSupportingTokensIdMap;
    private HashMap endorsingSupportingTokensIdMap;
    private HashMap signedEndorsingSupportingTokensIdMap;
    private Wss10 wss10;
    private Wss11 wss11;
    private Policy issuerPolicy;
    private Vector supportingPolicyData = new Vector();
    private Vector supportingTokens = new Vector();

    public Vector getSupportingPolicyData() {
        return this.supportingPolicyData;
    }

    public void addSupportingPolicyData(SupportingPolicyData supportingPolicyData) {
        this.supportingPolicyData.add(supportingPolicyData);
    }

    public boolean isSignBodyOptional() {
        return this.signBodyOptional;
    }

    public void setSignBodyOptional(boolean signBodyOptional) {
        this.signBodyOptional = signBodyOptional;
    }

    public boolean isEncryptBodyOptional() {
        return this.encryptBodyOptional;
    }

    public void setEncryptBodyOptional(boolean encryptBodyOptional) {
        this.encryptBodyOptional = encryptBodyOptional;
    }

    public boolean isSignAttachmentsOptional() {
        return this.signAttachmentsOptional;
    }

    public void setSignAttachmentsOptional(boolean signAttachmentsOptional) {
        this.signAttachmentsOptional = signAttachmentsOptional;
    }

    public boolean isEncryptAttachmentsOptional() {
        return this.encryptAttachmentsOptional;
    }

    public void setEncryptAttachmentsOptional(boolean encryptAttachmentsOptional) {
        this.encryptAttachmentsOptional = encryptAttachmentsOptional;
    }

    public boolean isSymmetricBinding() {
        return this.symmetricBinding;
    }

    public void setSymmetricBinding(boolean symmetricBinding) {
        this.symmetricBinding = symmetricBinding;
    }

    public boolean isAsymmetricBinding() {
        return this.asymmetricBinding;
    }

    public void setAsymmetricBinding(boolean asymmetricBinding) {
        this.asymmetricBinding = asymmetricBinding;
    }

    public boolean isEntireHeadersAndBodySignatures() {
        return this.entireHeadersAndBodySignatures;
    }

    public void setEntireHeadersAndBodySignatures(boolean entireHeaderAndBodySignatures) {
        this.entireHeadersAndBodySignatures = entireHeaderAndBodySignatures;
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    public boolean isIncludeTimestampOptional() {
        return this.includeTimestampOptional;
    }

    public void setIncludeTimestampOptional(boolean includeTimestampOptional) {
        this.includeTimestampOptional = includeTimestampOptional;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getProtectionOrder() {
        return this.protectionOrder;
    }

    public void setProtectionOrder(String protectionOrder) {
        this.protectionOrder = protectionOrder;
    }

    public boolean isSignatureProtection() {
        return this.signatureProtection;
    }

    public void setSignatureProtection(boolean signatureProtection) {
        this.signatureProtection = signatureProtection;
    }

    public boolean isTokenProtection() {
        return this.tokenProtection;
    }

    public void setTokenProtection(boolean tokenProtection) {
        this.tokenProtection = tokenProtection;
    }

    public boolean isSignatureConfirmation() {
        return this.signatureConfirmation;
    }

    public void setSignatureConfirmation(boolean signatureConfirmation) {
        this.signatureConfirmation = signatureConfirmation;
    }

    public Vector getEncryptedElements() {
        return this.encryptedElements;
    }

    public void setEncryptedElements(String encElement) {
        this.encryptedElements.add(encElement);
    }

    public Vector getRequiredElements() {
        return this.requiredElements;
    }

    public void setRequiredElements(String reqElement) {
        this.requiredElements.add(reqElement);
    }

    public Vector getContentEncryptedElements() {
        return this.contentEncryptedElements;
    }

    public void setContentEncryptedElements(String encElement) {
        this.contentEncryptedElements.add(encElement);
    }

    public Vector getEncryptedParts() {
        return this.encryptedParts;
    }

    public void setEncryptedParts(String namespace, String element) {
        WSEncryptionPart wep = new WSEncryptionPart(element, namespace, "Element");
        this.encryptedParts.add(wep);
    }

    public void setEncryptedParts(String namespace, String element, String modifier) {
        WSEncryptionPart wep = new WSEncryptionPart(element, namespace, modifier);
        this.encryptedParts.add(wep);
    }

    public boolean isEncryptBody() {
        return this.encryptBody;
    }

    public void setEncryptBody(boolean encryptBody) {
        this.encryptBody = encryptBody;
    }

    public boolean isSignBody() {
        return this.signBody;
    }

    public void setSignBody(boolean signBody) {
        this.signBody = signBody;
    }

    public boolean isSignAttachments() {
        return this.signAttachments;
    }

    public void setSignAttachments(boolean signAttachments) {
        this.signAttachments = signAttachments;
    }

    public boolean isEncryptAttachments() {
        return this.encryptAttachments;
    }

    public void setEncryptAttachments(boolean encryptAttachments) {
        this.encryptAttachments = encryptAttachments;
    }

    public Vector getSignedElements() {
        return this.signedElements;
    }

    public void setSignedElements(String sigElement) {
        this.signedElements.add(sigElement);
    }

    public Vector getSignedParts() {
        return this.signedParts;
    }

    public HashMap getDeclaredNamespaces() {
        return this.declaredNamespaces;
    }

    public void addDeclaredNamespaces(HashMap namespaces) {
        this.declaredNamespaces.putAll(namespaces);
    }

    public void addSignedPart(String namespace, String element) {
        WSEncryptionPart wep = new WSEncryptionPart(element, namespace, "Content");
        this.signedParts.add(wep);
    }

    public void addSignedPart(WSEncryptionPart part) {
        this.signedParts.add(part);
    }

    public void setSignedParts(Vector signedParts) {
        this.signedParts = signedParts;
    }

    public void setSupportingTokens(SupportingToken suppTokens) throws WSSPolicyException {
        int tokenType = suppTokens.getTokenType();
        if (tokenType == 1) {
            this.supportingTokens.add(suppTokens);
        } else if (tokenType == 3) {
            this.signedSupportingTokens = suppTokens;
        } else if (tokenType == 2) {
            this.endorsingSupportingTokens = suppTokens;
        } else if (tokenType == 4) {
            this.signedEndorsingSupportingTokens = suppTokens;
        } else if (tokenType == 6) {
            this.encryptedSupportingTokens = suppTokens;
        } else if (tokenType == 5) {
            this.signedEncryptedSupportingTokens = suppTokens;
        } else if (tokenType == 7) {
            this.endorsingEncryptedSupportingTokens = suppTokens;
        } else if (tokenType == 8) {
            this.signedEndorsingEncryptedSupportingTokens = suppTokens;
        }
    }

    public RampartConfig getRampartConfig() {
        return this.rampartConfig;
    }

    public Token getEncryptionToken() {
        return this.encryptionToken;
    }

    public void setEncryptionToken(Token encryptionToken) {
        this.encryptionToken = encryptionToken;
        this.extractIssuerPolicy(encryptionToken);
    }

    public Token getInitiatorToken() {
        return this.initiatorToken;
    }

    public void setInitiatorToken(Token initiatorToken) {
        this.initiatorToken = initiatorToken;
    }

    public Token getTransportToken() {
        return this.transportToken;
    }

    public void setTransportToken(Token transportToken) {
        this.transportToken = transportToken;
    }

    public Token getRecipientToken() {
        return this.recipientToken;
    }

    public void setRecipientToken(Token recipientToken) {
        this.recipientToken = recipientToken;
    }

    public void setProtectionToken(Token protectionToken) {
        this.setEncryptionToken(protectionToken);
        this.setSignatureToken(protectionToken);
        this.extractIssuerPolicy(protectionToken);
    }

    public Token getSignatureToken() {
        return this.signatureToken;
    }

    public void setSignatureToken(Token signatureToken) {
        this.signatureToken = signatureToken;
        this.extractIssuerPolicy(signatureToken);
    }

    public SupportingToken getSignedEndorsingSupportingTokens() {
        return this.signedEndorsingSupportingTokens;
    }

    public void setSignedEndorsingSupportingTokens(SupportingToken signedEndorsingSupportingTokens) {
        this.signedEndorsingSupportingTokens = signedEndorsingSupportingTokens;
    }

    public SupportingToken getSignedEndorsingEncryptedSupportingTokens() {
        return this.signedEndorsingEncryptedSupportingTokens;
    }

    public void setSignedEndorsingEncryptedSupportingTokens(SupportingToken signedEndorsingEncryptedSupportingTokens) {
        this.signedEndorsingEncryptedSupportingTokens = signedEndorsingEncryptedSupportingTokens;
    }

    public SupportingToken getSignedSupportingTokens() {
        return this.signedSupportingTokens;
    }

    public void setSignedSupportingTokens(SupportingToken signedSupportingTokens) {
        this.signedSupportingTokens = signedSupportingTokens;
    }

    public SupportingToken getSignedEncryptedSupportingTokens() {
        return this.signedEncryptedSupportingTokens;
    }

    public void setSignedEncryptedSupportingTokens(SupportingToken signedEncryptedSupportingTokens) {
        this.signedEncryptedSupportingTokens = signedEncryptedSupportingTokens;
    }

    public Vector getSupportingTokensList() {
        return this.supportingTokens;
    }

    public SupportingToken getSupportingTokens() {
        if (this.supportingTokens.size() > 0) {
            return (SupportingToken)this.supportingTokens.get(0);
        }
        return null;
    }

    public void setEncryptedSupportingTokens(SupportingToken encryptedSupportingTokens) {
        this.encryptedSupportingTokens = encryptedSupportingTokens;
    }

    public SupportingToken getEncryptedSupportingTokens() {
        return this.encryptedSupportingTokens;
    }

    public void setEndorsingSupportingTokens(SupportingToken endorsingSupportingTokens) {
        this.endorsingSupportingTokens = endorsingSupportingTokens;
    }

    public SupportingToken getEndorsingSupportingTokens() {
        return this.endorsingSupportingTokens;
    }

    public void setEndorsingEncryptedSupportingTokens(SupportingToken endorsingEncryptedSupportingTokens) {
        this.endorsingEncryptedSupportingTokens = endorsingEncryptedSupportingTokens;
    }

    public SupportingToken getEndorsingEncryptedSupportingTokens() {
        return this.endorsingEncryptedSupportingTokens;
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public Trust10 getTrust10() {
        return this.trust10;
    }

    public void setTrust10(Trust10 trust10) {
        this.trust10 = trust10;
    }

    public void setRampartConfig(RampartConfig rampartConfig) {
        this.rampartConfig = rampartConfig;
    }

    public boolean isTransportBinding() {
        return this.transportBinding;
    }

    public void setTransportBinding(boolean transportBinding) {
        this.transportBinding = transportBinding;
    }

    public void setSupporttingtokenId(Token token, String id, int type) throws RampartException {
        HashMap tokenMap = null;
        switch (type) {
            case 1: {
                if (this.supportingTokensIdMap == null) {
                    this.supportingTokensIdMap = new HashMap();
                }
                tokenMap = this.supportingTokensIdMap;
                break;
            }
            case 3: {
                if (this.signedSupportingTokensIdMap == null) {
                    this.signedSupportingTokensIdMap = new HashMap();
                }
                tokenMap = this.signedSupportingTokensIdMap;
                break;
            }
            case 2: {
                if (this.endorsingSupportingTokensIdMap == null) {
                    this.endorsingSupportingTokensIdMap = new HashMap();
                }
                tokenMap = this.endorsingSupportingTokensIdMap;
                break;
            }
            case 4: {
                if (this.signedEndorsingSupportingTokensIdMap == null) {
                    this.signedEndorsingSupportingTokensIdMap = new HashMap();
                }
                tokenMap = this.signedEndorsingSupportingTokensIdMap;
                break;
            }
            default: {
                throw new RampartException("invalidSupportingVersionType", new String[]{Integer.toString(type)});
            }
        }
        tokenMap.put(token, id);
    }

    public String getSupportingTokenID(Token token, int type) throws RampartException {
        switch (type) {
            case 1: {
                if (this.supportingTokensIdMap != null) {
                    return (String)this.supportingTokensIdMap.get(token);
                }
                return null;
            }
            case 3: {
                if (this.signedSupportingTokensIdMap != null) {
                    return (String)this.signedSupportingTokensIdMap.get(token);
                }
                return null;
            }
            case 2: {
                if (this.endorsingSupportingTokensIdMap != null) {
                    return (String)this.endorsingSupportingTokensIdMap.get(token);
                }
                return null;
            }
            case 4: {
                if (this.signedEndorsingSupportingTokensIdMap == null) {
                    this.signedEndorsingSupportingTokensIdMap = new HashMap();
                }
                return null;
            }
        }
        throw new RampartException("invalidSupportingVersionType", new String[]{Integer.toString(type)});
    }

    public Wss10 getWss10() {
        return this.wss10;
    }

    public void setWss10(Wss10 wss10) {
        this.wss10 = wss10;
    }

    public Wss11 getWss11() {
        return this.wss11;
    }

    public void setWss11(Wss11 wss11) {
        this.wss11 = wss11;
    }

    private void extractIssuerPolicy(Token token) {
        if (token instanceof SecureConversationToken && this.issuerPolicy == null) {
            this.issuerPolicy = ((SecureConversationToken)token).getBootstrapPolicy();
        }
    }

    public Policy getIssuerPolicy() {
        return this.issuerPolicy;
    }

    public void setMTOMAssertion(MTOMAssertion mtomAssertion) {
        this.mtomAssertion = mtomAssertion;
    }

    public MTOMAssertion getMTOMAssertion() {
        return this.mtomAssertion;
    }

    public boolean isSignAllHeaders() {
        return this.signAllHeaders;
    }

    public void setSignAllHeaders(boolean signAllHeaders) {
        this.signAllHeaders = signAllHeaders;
    }

    public boolean isMTOMSerialize() {
        if (this.mtomAssertion == null) {
            return false;
        }
        return !this.mtomAssertion.isOptional();
    }

    public OptimizePartsConfig getOptimizePartsConfig() {
        return this.rampartConfig.getOptimizeParts();
    }
}

